/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ReferenceCountUtil;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.driver.ser.AbstractMessageSerializer;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoMapper;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoVersion;
import org.apache.tinkerpop.shaded.kryo.Kryo;
import org.apache.tinkerpop.shaded.kryo.Serializer;
import org.apache.tinkerpop.shaded.kryo.io.Input;
import org.apache.tinkerpop.shaded.kryo.io.Output;

@Deprecated
public abstract class AbstractGryoMessageSerializerV1d0
extends AbstractMessageSerializer {
    private GryoMapper gryoMapper;
    private ThreadLocal<Kryo> kryoThreadLocal = new ThreadLocal<Kryo>(){

        @Override
        protected Kryo initialValue() {
            return AbstractGryoMessageSerializerV1d0.this.gryoMapper.createMapper();
        }
    };
    private static final Charset UTF8 = Charset.forName("UTF-8");
    public static final String TOKEN_CUSTOM = "custom";
    public static final String TOKEN_SERIALIZE_RESULT_TO_STRING = "serializeResultToString";
    public static final String TOKEN_BUFFER_SIZE = "bufferSize";
    public static final String TOKEN_CLASS_RESOLVER_SUPPLIER = "classResolverSupplier";
    protected boolean serializeToString = false;
    private int bufferSize = 4096;

    public AbstractGryoMessageSerializerV1d0(GryoMapper kryo) {
        this.gryoMapper = kryo;
    }

    GryoMapper.Builder configureBuilder(GryoMapper.Builder builder, Map<String, Object> config, Map<String, Graph> graphs) {
        return builder;
    }

    @Override
    public final void configure(Map<String, Object> config, Map<String, Graph> graphs) {
        GryoMapper.Builder builder = GryoMapper.build().version(GryoVersion.V1_0);
        this.addIoRegistries(config, builder);
        this.addClassResolverSupplier(config, builder);
        this.addCustomClasses(config, builder);
        this.serializeToString = Boolean.parseBoolean(config.getOrDefault(TOKEN_SERIALIZE_RESULT_TO_STRING, "false").toString());
        this.bufferSize = Integer.parseInt(config.getOrDefault(TOKEN_BUFFER_SIZE, "4096").toString());
        this.gryoMapper = this.configureBuilder(builder, config, graphs).create();
    }

    private void addClassResolverSupplier(Map<String, Object> config, GryoMapper.Builder builder) {
        String className2 = config.getOrDefault(TOKEN_CLASS_RESOLVER_SUPPLIER, null);
        if (className2 != null && !className2.isEmpty()) {
            try {
                Class<?> clazz2 = Class.forName(className2);
                try {
                    Method instanceMethod = this.tryInstanceMethod(clazz2);
                    builder.classResolver((Supplier)instanceMethod.invoke(null, new Object[0]));
                }
                catch (Exception methodex) {
                    builder.classResolver((Supplier)clazz2.newInstance());
                }
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private void addCustomClasses(Map<String, Object> config, GryoMapper.Builder builder) {
        List<String> classNameList = this.getListStringFromConfig(TOKEN_CUSTOM, config);
        classNameList.stream().forEach(serializerDefinition -> {
            Optional<Object> serializerName;
            String className2;
            if (serializerDefinition.contains(";")) {
                String[] split2 = serializerDefinition.split(";");
                if (split2.length != 2) {
                    throw new IllegalStateException(String.format("Invalid format for serializer definition [%s] - expected <class>;<serializer-class>", serializerDefinition));
                }
                className2 = split2[0];
                serializerName = Optional.of(split2[1]);
            } else {
                serializerName = Optional.empty();
                className2 = serializerDefinition;
            }
            try {
                Class<?> clazz2 = Class.forName(className2);
                if (serializerName.isPresent()) {
                    Class<?> serializerClazz = Class.forName((String)serializerName.get());
                    Serializer serializer = (Serializer)serializerClazz.newInstance();
                    builder.addCustom(clazz2, kryo -> serializer);
                } else {
                    builder.addCustom(clazz2);
                }
            }
            catch (Exception ex) {
                throw new IllegalStateException("Class could not be found", ex);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResponseMessage deserializeResponse(ByteBuf msg) throws SerializationException {
        try {
            Kryo kryo = this.kryoThreadLocal.get();
            byte[] payload = new byte[msg.capacity()];
            msg.readBytes(payload);
            try (Input input2 = new Input(payload);){
                UUID requestId = kryo.readObjectOrNull(input2, UUID.class);
                short status = input2.readShort();
                String statusMsg = input2.readString();
                Map statusAttributes = (Map)kryo.readClassAndObject(input2);
                Object result2 = kryo.readClassAndObject(input2);
                Map metaAttributes = (Map)kryo.readClassAndObject(input2);
                ResponseMessage responseMessage = ResponseMessage.build(requestId).code(ResponseStatusCode.getFromValue(status)).statusMessage(statusMsg).statusAttributes(statusAttributes).result(result2).responseMetaData(metaAttributes).create();
                return responseMessage;
            }
        }
        catch (Exception ex) {
            logger.warn(String.format("Response [%s] could not be deserialized by %s.", msg, AbstractGryoMessageSerializerV1d0.class.getName()), ex);
            throw new SerializationException(ex);
        }
    }

    @Override
    public ByteBuf serializeResponseAsBinary(ResponseMessage responseMessage, ByteBufAllocator allocator) throws SerializationException {
        ByteBuf encodedMessage = null;
        try {
            Kryo kryo = this.kryoThreadLocal.get();
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                Output output = new Output(baos, this.bufferSize);
                kryo.writeObjectOrNull(output, (Object)(responseMessage.getRequestId() != null ? responseMessage.getRequestId() : null), UUID.class);
                output.writeShort(responseMessage.getStatus().getCode().getValue());
                output.writeString(responseMessage.getStatus().getMessage());
                kryo.writeClassAndObject(output, responseMessage.getStatus().getAttributes());
                kryo.writeClassAndObject(output, this.serializeToString ? this.serializeResultToString(responseMessage) : responseMessage.getResult().getData());
                kryo.writeClassAndObject(output, responseMessage.getResult().getMeta());
                long size2 = output.total();
                if (size2 > Integer.MAX_VALUE) {
                    throw new SerializationException(String.format("Message size of %s exceeds allocatable space", size2));
                }
                output.flush();
                encodedMessage = allocator.buffer((int)size2);
                encodedMessage.writeBytes(baos.toByteArray());
            }
            return encodedMessage;
        }
        catch (Exception ex) {
            if (encodedMessage != null) {
                ReferenceCountUtil.release(encodedMessage);
            }
            logger.warn(String.format("Response [%s] could not be serialized by %s.", responseMessage, AbstractGryoMessageSerializerV1d0.class.getName()), ex);
            throw new SerializationException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RequestMessage deserializeRequest(ByteBuf msg) throws SerializationException {
        try {
            Kryo kryo = this.kryoThreadLocal.get();
            byte[] payload = new byte[msg.readableBytes()];
            msg.readBytes(payload);
            try (Input input2 = new Input(payload);){
                UUID id = kryo.readObject(input2, UUID.class);
                String processor = input2.readString();
                String op = input2.readString();
                RequestMessage.Builder builder = RequestMessage.build(op).overrideRequestId(id).processor(processor);
                Map args2 = kryo.readObject(input2, HashMap.class);
                args2.forEach(builder::addArg);
                RequestMessage requestMessage = builder.create();
                return requestMessage;
            }
        }
        catch (Exception ex) {
            logger.warn(String.format("Request [%s] could not be deserialized by %s.", msg, AbstractGryoMessageSerializerV1d0.class.getName()), ex);
            throw new SerializationException(ex);
        }
    }

    @Override
    public ByteBuf serializeRequestAsBinary(RequestMessage requestMessage, ByteBufAllocator allocator) throws SerializationException {
        ByteBuf encodedMessage = null;
        try {
            Kryo kryo = this.kryoThreadLocal.get();
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                Output output = new Output(baos, this.bufferSize);
                String mimeType = this.mimeTypesSupported()[0];
                output.writeByte(mimeType.length());
                output.write(mimeType.getBytes(UTF8));
                kryo.writeObject(output, requestMessage.getRequestId());
                output.writeString(requestMessage.getProcessor());
                output.writeString(requestMessage.getOp());
                kryo.writeObject(output, requestMessage.getArgs());
                long size2 = output.total();
                if (size2 > Integer.MAX_VALUE) {
                    throw new SerializationException(String.format("Message size of %s exceeds allocatable space", size2));
                }
                output.flush();
                encodedMessage = allocator.buffer((int)size2);
                encodedMessage.writeBytes(baos.toByteArray());
            }
            return encodedMessage;
        }
        catch (Exception ex) {
            if (encodedMessage != null) {
                ReferenceCountUtil.release(encodedMessage);
            }
            logger.warn(String.format("Request [%s] could not be serialized by %s.", requestMessage, AbstractGryoMessageSerializerV1d0.class.getName()), ex);
            throw new SerializationException(ex);
        }
    }

    private Object serializeResultToString(ResponseMessage msg) {
        if (msg.getResult() == null) {
            return "null";
        }
        if (msg.getResult().getData() == null) {
            return "null";
        }
        Object o = msg.getResult().getData();
        if (o instanceof Collection) {
            return ((Collection)o).stream().map(d -> null == d ? "null" : d.toString()).collect(Collectors.toList());
        }
        return o.toString();
    }
}

