/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.tinkerpop.gremlin.driver.Host;
import org.apache.tinkerpop.gremlin.driver.Result;
import org.apache.tinkerpop.gremlin.driver.ResultQueue;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;

public final class ResultSet
implements Iterable<Result> {
    private final ResultQueue resultQueue;
    private final ExecutorService executor;
    private final RequestMessage originalRequestMessage;
    private final Host host;
    private final CompletableFuture<Void> readCompleted;

    public ResultSet(ResultQueue resultQueue, ExecutorService executor, CompletableFuture<Void> readCompleted, RequestMessage originalRequestMessage, Host host) {
        this.executor = executor;
        this.host = host;
        this.resultQueue = resultQueue;
        this.readCompleted = readCompleted;
        this.originalRequestMessage = originalRequestMessage;
    }

    public RequestMessage getOriginalRequestMessage() {
        return this.originalRequestMessage;
    }

    public Host getHost() {
        return this.host;
    }

    public CompletableFuture<Map<String, Object>> statusAttributes() {
        CompletableFuture<Map<String, Object>> attrs = new CompletableFuture<Map<String, Object>>();
        this.readCompleted.thenRun(() -> attrs.complete(null == this.resultQueue.getStatusAttributes() ? Collections.emptyMap() : this.resultQueue.getStatusAttributes()));
        return attrs;
    }

    public boolean allItemsAvailable() {
        return this.readCompleted.isDone();
    }

    public CompletableFuture<Void> allItemsAvailableAsync() {
        CompletableFuture<Void> allAvailable = new CompletableFuture<Void>();
        this.readCompleted.thenRun(() -> allAvailable.complete(null));
        this.readCompleted.exceptionally(t -> {
            allAvailable.completeExceptionally((Throwable)t);
            return null;
        });
        return allAvailable;
    }

    public int getAvailableItemCount() {
        return this.resultQueue.size();
    }

    public Result one() {
        List<Result> results2 = this.some(1).join();
        assert (results2.size() <= 1);
        return results2.size() == 1 ? results2.get(0) : null;
    }

    public CompletableFuture<List<Result>> some(int items) {
        return this.resultQueue.await(items);
    }

    public CompletableFuture<List<Result>> all() {
        return this.readCompleted.thenApplyAsync(it -> {
            ArrayList<Result> list2 = new ArrayList<Result>();
            this.resultQueue.drainTo(list2);
            return list2;
        }, (Executor)this.executor);
    }

    public Stream<Result> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 1088), false);
    }

    @Override
    public Iterator<Result> iterator() {
        return new Iterator<Result>(){
            private Result nextOne = null;

            @Override
            public boolean hasNext() {
                if (null == this.nextOne) {
                    this.nextOne = ResultSet.this.one();
                }
                return this.nextOne != null;
            }

            @Override
            public Result next() {
                if (null != this.nextOne || this.hasNext()) {
                    Result r = this.nextOne;
                    this.nextOne = null;
                    return r;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

