/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URI;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.tinkerpop.gremlin.driver.Channelizer;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.ConnectionPool;
import org.apache.tinkerpop.gremlin.driver.Result;
import org.apache.tinkerpop.gremlin.driver.ResultQueue;
import org.apache.tinkerpop.gremlin.driver.ResultSet;
import org.apache.tinkerpop.gremlin.driver.exception.ConnectionException;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Connection {
    private static final Logger logger = LoggerFactory.getLogger(Connection.class);
    private final Channel channel;
    private final URI uri;
    private final ConcurrentMap<UUID, ResultQueue> pending = new ConcurrentHashMap<UUID, ResultQueue>();
    private final Cluster cluster;
    private final Client client;
    private final ConnectionPool pool;
    private final long keepAliveInterval;
    public static final int MAX_IN_PROCESS = 4;
    public static final int MIN_IN_PROCESS = 1;
    public static final int MAX_WAIT_FOR_CONNECTION = 16000;
    public static final int MAX_WAIT_FOR_SESSION_CLOSE = 3000;
    public static final int MAX_CONTENT_LENGTH = 65536;
    public static final int RECONNECT_INTERVAL = 1000;
    public static final int RESULT_ITERATION_BATCH_SIZE = 64;
    public static final long KEEP_ALIVE_INTERVAL = 180000L;
    public final AtomicInteger borrowed = new AtomicInteger(0);
    private final AtomicReference<Class<Channelizer>> channelizerClass = new AtomicReference<Object>(null);
    private final int maxInProcess;
    private final String connectionLabel;
    private final Channelizer channelizer;
    private final AtomicReference<CompletableFuture<Void>> closeFuture = new AtomicReference();
    private final AtomicBoolean shutdownInitiated = new AtomicBoolean(false);
    private final AtomicReference<ScheduledFuture> keepAliveFuture = new AtomicReference();

    public Connection(URI uri2, ConnectionPool pool, int maxInProcess) throws ConnectionException {
        this.uri = uri2;
        this.cluster = pool.getCluster();
        this.client = pool.getClient();
        this.pool = pool;
        this.maxInProcess = maxInProcess;
        this.keepAliveInterval = pool.settings().keepAliveInterval;
        this.connectionLabel = String.format("Connection{host=%s}", pool.host);
        if (this.cluster.isClosing()) {
            throw new IllegalStateException("Cannot open a connection with the cluster after close() is called");
        }
        Bootstrap b = this.cluster.getFactory().createBootstrap();
        try {
            if (this.channelizerClass.get() == null) {
                this.channelizerClass.compareAndSet(null, Class.forName(this.cluster.connectionPoolSettings().channelizer));
            }
            this.channelizer = this.channelizerClass.get().newInstance();
            this.channelizer.init(this);
            ((Bootstrap)b.channel(NioSocketChannel.class)).handler(this.channelizer);
            this.channel = b.connect(uri2.getHost(), uri2.getPort()).sync().channel();
            this.channelizer.connected();
            logger.info("Created new connection for {}", (Object)uri2);
            this.scheduleKeepAlive();
        }
        catch (Exception ie) {
            logger.debug("Error opening connection on {}", (Object)uri2);
            throw new ConnectionException(uri2, "Could not open connection", ie);
        }
    }

    public int availableInProcess() {
        return Math.max(0, this.maxInProcess - this.pending.size());
    }

    public boolean isDead() {
        return this.channel != null && !this.channel.isActive();
    }

    boolean isClosing() {
        return this.closeFuture.get() != null;
    }

    URI getUri() {
        return this.uri;
    }

    Cluster getCluster() {
        return this.cluster;
    }

    Client getClient() {
        return this.client;
    }

    ConcurrentMap<UUID, ResultQueue> getPending() {
        return this.pending;
    }

    public synchronized CompletableFuture<Void> closeAsync() {
        if (this.isClosing()) {
            return this.closeFuture.get();
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.closeFuture.set(future);
        ScheduledFuture keepAlive = this.keepAliveFuture.get();
        if (keepAlive != null) {
            keepAlive.cancel(true);
        }
        if (this.isOkToClose()) {
            if (null == this.channel) {
                future.complete(null);
            } else {
                this.shutdown(future);
            }
        } else {
            new CheckForPending(future).runUntilDone(this.cluster.executor(), 1000L, TimeUnit.MILLISECONDS);
        }
        return future;
    }

    public void close() {
        try {
            this.closeAsync().get();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public ChannelPromise write(RequestMessage requestMessage, CompletableFuture<ResultSet> future) {
        Connection thisConnection = this;
        ChannelPromise requestPromise = this.channel.newPromise().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f2 -> {
            if (!f2.isSuccess()) {
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("Write on connection %s failed", thisConnection.getConnectionInfo()), f2.cause());
                }
                this.handleConnectionCleanupOnError(thisConnection, f2.cause());
                this.cluster.executor().submit(() -> future.completeExceptionally(f2.cause()));
            } else {
                LinkedBlockingQueue<Result> resultLinkedBlockingQueue = new LinkedBlockingQueue<Result>();
                CompletableFuture<Void> readCompleted = new CompletableFuture<Void>();
                readCompleted.thenAcceptAsync(v -> {
                    thisConnection.returnToPool();
                    this.tryShutdown();
                }, (Executor)this.cluster.executor());
                readCompleted.exceptionally(t -> {
                    this.handleConnectionCleanupOnError(thisConnection, (Throwable)t);
                    this.tryShutdown();
                    return null;
                });
                ResultQueue handler = new ResultQueue(resultLinkedBlockingQueue, readCompleted);
                this.pending.put(requestMessage.getRequestId(), handler);
                this.cluster.executor().submit(() -> future.complete(new ResultSet(handler, this.cluster.executor(), readCompleted, requestMessage, this.pool.host)));
            }
        }));
        this.channel.writeAndFlush(requestMessage, requestPromise);
        this.scheduleKeepAlive();
        return requestPromise;
    }

    private void scheduleKeepAlive() {
        ScheduledFuture<?> oldKeepAliveFuture;
        Connection thisConnection = this;
        if (this.channelizer.supportsKeepAlive() && this.keepAliveInterval > 0L && (oldKeepAliveFuture = this.keepAliveFuture.getAndSet(this.cluster.executor().scheduleAtFixedRate(() -> {
            logger.debug("Request sent to server to keep {} alive", (Object)thisConnection);
            try {
                this.channel.writeAndFlush(this.channelizer.createKeepAliveMessage());
            }
            catch (Exception ex) {
                logger.warn(String.format("Keep-alive did not succeed on %s", thisConnection), ex);
            }
        }, this.keepAliveInterval, this.keepAliveInterval, TimeUnit.MILLISECONDS))) != null) {
            oldKeepAliveFuture.cancel(true);
        }
    }

    public void returnToPool() {
        block3: {
            try {
                if (this.pool != null) {
                    this.pool.returnConnection(this);
                }
            }
            catch (ConnectionException ce) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("Returned {} connection to {} but an error occurred - {}", this.getConnectionInfo(), this.pool, ce.getMessage());
            }
        }
    }

    private void handleConnectionCleanupOnError(Connection thisConnection, Throwable t) {
        if (thisConnection.isDead()) {
            if (this.pool != null) {
                this.pool.replaceConnection(thisConnection);
            }
        } else {
            thisConnection.returnToPool();
        }
    }

    private boolean isOkToClose() {
        return this.pending.isEmpty() || this.channel != null && !this.channel.isOpen() || !this.pool.host.isAvailable();
    }

    private void tryShutdown() {
        if (this.isClosing() && this.isOkToClose()) {
            this.shutdown(this.closeFuture.get());
        }
    }

    private synchronized void shutdown(CompletableFuture<Void> future) {
        if (this.shutdownInitiated.compareAndSet(false, true)) {
            String connectionInfo = this.getConnectionInfo();
            if (this.client instanceof Client.SessionedClient) {
                boolean forceClose = this.client.getSettings().getSession().get().isForceClosed();
                RequestMessage closeMessage = this.client.buildMessage(RequestMessage.build("close").addArg("force", forceClose)).create();
                CompletableFuture<ResultSet> closed = new CompletableFuture<ResultSet>();
                this.write(closeMessage, closed);
                try {
                    closed.join().all().get(this.cluster.connectionPoolSettings().maxWaitForSessionClose, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException ex) {
                    String msg = String.format("Timeout while trying to close connection on %s - force closing - server will close session on shutdown or expiration.", ((Client.SessionedClient)this.client).getSessionId());
                    logger.warn(msg, ex);
                }
                catch (Exception ex) {
                    String msg = String.format("Encountered an error trying to close connection on %s - force closing - server will close session on shutdown or expiration.", ((Client.SessionedClient)this.client).getSessionId());
                    logger.warn(msg, ex);
                }
            }
            this.channelizer.close(this.channel);
            ChannelPromise promise = this.channel.newPromise();
            promise.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f2 -> {
                if (f2.cause() != null) {
                    future.completeExceptionally(f2.cause());
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("{} destroyed successfully.", (Object)connectionInfo);
                    }
                    future.complete(null);
                }
            }));
            this.channel.close(promise);
        }
    }

    public String getConnectionInfo() {
        return String.format("Connection{host=%s, isDead=%s, borrowed=%s, pending=%s}", this.pool.host, this.isDead(), this.borrowed, this.pending.size());
    }

    public String toString() {
        return this.connectionLabel;
    }

    private final class CheckForPending
    implements Runnable {
        private volatile ScheduledFuture<?> self;
        private final CompletableFuture<Void> future;

        CheckForPending(CompletableFuture<Void> future) {
            this.future = future;
        }

        @Override
        public void run() {
            logger.info("Checking for pending messages to complete before close on {}", (Object)this);
            if (Connection.this.isOkToClose()) {
                Connection.this.shutdown(this.future);
                boolean interrupted = false;
                try {
                    while (null == this.self) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                        }
                    }
                    this.self.cancel(false);
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        void runUntilDone(ScheduledExecutorService executor, long period, TimeUnit unit) {
            this.self = executor.scheduleAtFixedRate(this, period, period, unit);
        }
    }
}

