/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.util;

public class SystemUtil {
    public static String setSystemPropertyFrom(String nameValue) {
        String value2;
        String name2;
        if (nameValue == null) {
            throw new IllegalArgumentException("argument should not be null");
        }
        int i = nameValue.indexOf("=");
        if (i == -1) {
            name2 = nameValue;
            value2 = Boolean.TRUE.toString();
        } else {
            name2 = nameValue.substring(0, i);
            value2 = nameValue.substring(i + 1);
        }
        name2 = name2.trim();
        System.setProperty(name2, value2);
        return name2;
    }

    public static String setSystemPropertyFromSafe(String nameValue) {
        try {
            return SystemUtil.setSystemPropertyFrom(nameValue);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    public static String getSystemPropertySafe(String name2, String defaultValue2) {
        try {
            return System.getProperty(name2, defaultValue2);
        }
        catch (IllegalArgumentException | NullPointerException | SecurityException runtimeException) {
            return defaultValue2;
        }
    }

    public static String getSystemPropertySafe(String name2) {
        return SystemUtil.getSystemPropertySafe(name2, null);
    }

    public static boolean getBooleanSafe(String name2) {
        try {
            return Boolean.getBoolean(name2);
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public static Integer getIntegerSafe(String name2, Integer def) {
        try {
            return Integer.getInteger(name2, def);
        }
        catch (SecurityException securityException) {
            return def;
        }
    }
}

