/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.json.internal;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.groovy.json.internal.LazyValueMap;
import org.apache.groovy.json.internal.Value;

public class ValueList
extends AbstractList<Object> {
    List<Object> list = new ArrayList<Object>(5);
    private final boolean lazyChop;
    boolean converted = false;

    public ValueList(boolean lazyChop) {
        this.lazyChop = lazyChop;
    }

    @Override
    public Object get(int index2) {
        Object obj = this.list.get(index2);
        if (obj instanceof Value) {
            obj = ValueList.convert((Value)obj);
            this.list.set(index2, obj);
        }
        this.chopIfNeeded(obj);
        return obj;
    }

    private static Object convert(Value value2) {
        return value2.toValue();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Iterator<Object> iterator() {
        this.convertAllIfNeeded();
        return this.list.iterator();
    }

    private void convertAllIfNeeded() {
        if (!this.converted) {
            this.converted = true;
            for (int index2 = 0; index2 < this.list.size(); ++index2) {
                this.get(index2);
            }
        }
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean add(Object obj) {
        return this.list.add(obj);
    }

    public void chopList() {
        for (Object obj : this.list) {
            if (obj == null || !(obj instanceof Value)) continue;
            Value value2 = (Value)obj;
            if (value2.isContainer()) {
                ValueList.chopContainer(value2);
                continue;
            }
            value2.chop();
        }
    }

    private void chopIfNeeded(Object object) {
        if (this.lazyChop) {
            if (object instanceof LazyValueMap) {
                LazyValueMap m = (LazyValueMap)object;
                m.chopMap();
            } else if (object instanceof ValueList) {
                ValueList list2 = (ValueList)object;
                list2.chopList();
            }
        }
    }

    static void chopContainer(Value value2) {
        Object obj = value2.toValue();
        if (obj instanceof LazyValueMap) {
            LazyValueMap map2 = (LazyValueMap)obj;
            map2.chopMap();
        } else if (obj instanceof ValueList) {
            ValueList list2 = (ValueList)obj;
            list2.chopList();
        }
    }

    public List<Object> list() {
        return this.list;
    }
}

