/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.json.internal;

import org.apache.groovy.json.internal.Cache;
import org.apache.groovy.json.internal.CacheType;
import org.codehaus.groovy.runtime.memoize.CommonCache;
import org.codehaus.groovy.runtime.memoize.EvictableCache;

public class SimpleCache<K, V>
implements Cache<K, V> {
    private EvictableCache<K, V> cache;

    public SimpleCache(int limit, CacheType type) {
        this.cache = type.equals((Object)CacheType.LRU) ? new CommonCache(limit) : new CommonCache(16, limit, EvictableCache.EvictionStrategy.FIFO);
    }

    public SimpleCache(int limit) {
        this(limit, CacheType.LRU);
    }

    @Override
    public void put(K key, V value2) {
        this.cache.put(key, value2);
    }

    @Override
    public V get(K key) {
        return this.cache.get(key);
    }

    @Override
    public V getSilent(K key) {
        Object value2 = this.cache.get(key);
        if (value2 != null) {
            this.cache.remove(key);
            this.cache.put(key, value2);
        }
        return value2;
    }

    @Override
    public void remove(K key) {
        this.cache.remove(key);
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    public String toString() {
        return this.cache.toString();
    }
}

