/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.json.internal;

import java.util.AbstractList;
import java.util.ArrayList;
import org.apache.groovy.json.internal.CharSequenceValue;
import org.apache.groovy.json.internal.JsonParserCharArray;
import org.apache.groovy.json.internal.LazyValueMap;
import org.apache.groovy.json.internal.MapItemValue;
import org.apache.groovy.json.internal.NumberValue;
import org.apache.groovy.json.internal.Type;
import org.apache.groovy.json.internal.Value;
import org.apache.groovy.json.internal.ValueContainer;
import org.apache.groovy.json.internal.ValueList;
import org.apache.groovy.json.internal.ValueMap;
import org.apache.groovy.json.internal.ValueMapImpl;

public class JsonFastParser
extends JsonParserCharArray {
    private final boolean useValues;
    private final boolean chop;
    private final boolean lazyChop;
    private final boolean checkDates;

    public JsonFastParser() {
        this(true);
    }

    public JsonFastParser(boolean useValues) {
        this(useValues, false);
    }

    public JsonFastParser(boolean useValues, boolean chop) {
        this(useValues, chop, !chop);
    }

    public JsonFastParser(boolean useValues, boolean chop, boolean lazyChop) {
        this(useValues, chop, lazyChop, true);
    }

    public JsonFastParser(boolean useValues, boolean chop, boolean lazyChop, boolean checkDates) {
        this.useValues = useValues;
        this.chop = chop;
        this.lazyChop = lazyChop;
        this.checkDates = checkDates;
    }

    protected final Value decodeJsonObjectLazyFinalParse() {
        char[] array2 = this.charArray;
        if (this.__currentChar == '{') {
            ++this.__index;
        }
        ValueMap map2 = (ValueMap)((Object)(this.useValues ? new ValueMapImpl() : new LazyValueMap(this.lazyChop)));
        ValueContainer value2 = new ValueContainer(map2);
        block7: while (this.__index < array2.length) {
            this.skipWhiteSpace();
            switch (this.__currentChar) {
                case '\"': {
                    Value key = this.decodeStringOverlay();
                    this.skipWhiteSpace();
                    if (this.__currentChar != ':') {
                        this.complain("expecting current character to be " + this.charDescription(this.__currentChar) + "\n");
                    }
                    ++this.__index;
                    Value item = this.decodeValueOverlay();
                    this.skipWhiteSpace();
                    MapItemValue miv = new MapItemValue(key, item);
                    map2.add(miv);
                }
            }
            switch (this.__currentChar) {
                case '}': {
                    ++this.__index;
                    break block7;
                }
                case ',': {
                    break;
                }
                default: {
                    this.complain("expecting '}' or ',' but got current char " + this.charDescription(this.__currentChar));
                }
            }
            ++this.__index;
        }
        return value2;
    }

    @Override
    protected Value decodeValue() {
        return this.decodeValueOverlay();
    }

    private Value decodeValueOverlay() {
        this.skipWhiteSpace();
        switch (this.__currentChar) {
            case '\"': {
                return this.decodeStringOverlay();
            }
            case '{': {
                return this.decodeJsonObjectLazyFinalParse();
            }
            case 't': {
                return this.decodeTrue() ? ValueContainer.TRUE : ValueContainer.FALSE;
            }
            case 'f': {
                return !this.decodeFalse() ? ValueContainer.FALSE : ValueContainer.TRUE;
            }
            case 'n': {
                return this.decodeNull() == null ? ValueContainer.NULL : ValueContainer.NULL;
            }
            case '[': {
                return this.decodeJsonArrayOverlay();
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return this.decodeNumberOverlay(false);
            }
            case '-': {
                return this.decodeNumberOverlay(true);
            }
        }
        this.complain("Unable to determine the current character, it is not a string, number, array, or object");
        return null;
    }

    private Value decodeNumberOverlay(boolean minus2) {
        char prevChar;
        char currentChar;
        char[] array2 = this.charArray;
        int startIndex = this.__index;
        int index2 = this.__index;
        boolean doubleFloat = false;
        boolean foundDot = false;
        boolean foundSign = false;
        boolean foundExp = false;
        if (minus2 && index2 + 1 < array2.length) {
            ++index2;
        }
        do {
            if (JsonFastParser.isNumberDigit(currentChar = array2[index2])) continue;
            if (currentChar <= ' ' || JsonFastParser.isDelimiter(currentChar)) break;
            if (JsonFastParser.isDecimalChar(currentChar)) {
                switch (currentChar) {
                    case '.': {
                        if (foundDot || foundExp) {
                            this.complain("unexpected character " + currentChar);
                        }
                        foundDot = true;
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        if (foundExp) {
                            this.complain("unexpected character " + currentChar);
                        }
                        foundExp = true;
                        break;
                    }
                    case '+': 
                    case '-': {
                        if (foundSign || !foundExp) {
                            this.complain("unexpected character " + currentChar);
                        }
                        if (foundExp && array2[index2 - 1] != 'e' && array2[index2 - 1] != 'E') {
                            this.complain("unexpected character " + currentChar);
                        }
                        foundSign = true;
                    }
                }
                doubleFloat = true;
                continue;
            }
            this.complain("unexpected character " + currentChar);
        } while (++index2 < array2.length);
        if (foundExp && ((prevChar = array2[index2 - 1]) == 'e' || prevChar == 'E' || prevChar == '-' || prevChar == '+')) {
            this.complain("unexpected character " + currentChar);
        }
        this.__index = index2;
        this.__currentChar = currentChar;
        Type type = doubleFloat ? Type.DOUBLE : Type.INTEGER;
        return new NumberValue(this.chop, type, startIndex, this.__index, this.charArray);
    }

    private Value decodeStringOverlay() {
        char[] array2 = this.charArray;
        int index2 = this.__index;
        char currentChar = this.charArray[index2];
        if (index2 < array2.length && currentChar == '\"') {
            ++index2;
        }
        int startIndex = index2;
        boolean encoded = JsonFastParser.hasEscapeChar(array2, index2, this.indexHolder);
        index2 = this.indexHolder[0];
        if (encoded) {
            index2 = JsonFastParser.findEndQuote(array2, index2);
        }
        CharSequenceValue value2 = new CharSequenceValue(this.chop, Type.STRING, startIndex, index2, array2, encoded, this.checkDates);
        if (index2 < array2.length) {
            ++index2;
        }
        this.__index = index2;
        return value2;
    }

    private Value decodeJsonArrayOverlay() {
        char[] array2 = this.charArray;
        if (this.__currentChar == '[') {
            ++this.__index;
        }
        this.skipWhiteSpace();
        if (this.__currentChar == ']') {
            ++this.__index;
            return new ValueContainer(new ArrayList<Object>());
        }
        AbstractList list2 = this.useValues ? new ArrayList() : new ValueList(this.lazyChop);
        ValueContainer value2 = new ValueContainer(list2);
        boolean foundEnd = false;
        block8: while (this.__index < array2.length) {
            Value item = this.decodeValueOverlay();
            list2.add((Object)item);
            char c = this.currentChar();
            block0 : switch (c) {
                case ',': {
                    break;
                }
                case ']': {
                    ++this.__index;
                    foundEnd = true;
                    break block8;
                }
                default: {
                    int lastIndex = this.__index;
                    this.skipWhiteSpace();
                    c = this.currentChar();
                    switch (c) {
                        case ',': {
                            break block0;
                        }
                        case ']': {
                            if (this.__index == lastIndex) {
                                this.complain("missing ]");
                            }
                            foundEnd = true;
                            ++this.__index;
                            break block8;
                        }
                        default: {
                            this.complain(String.format("expecting a ',' or a ']',  but got \nthe current character of  %s  on array size of %s \n", this.charDescription(this.__currentChar), list2.size()));
                        }
                    }
                }
            }
            ++this.__index;
        }
        if (!foundEnd) {
            this.complain("Did not find end of Json Array");
        }
        return value2;
    }

    @Override
    protected final Object decodeFromChars(char[] cs) {
        Value value2 = (Value)super.decodeFromChars(cs);
        if (value2.isContainer()) {
            return value2.toValue();
        }
        return value2;
    }
}

