/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.json.internal;

import java.math.BigDecimal;
import org.apache.groovy.json.internal.ArrayUtils;
import org.apache.groovy.json.internal.CharBuf;
import org.apache.groovy.json.internal.Exceptions;

public class CharScanner {
    protected static final int COMMA = 44;
    protected static final int CLOSED_CURLY = 125;
    protected static final int CLOSED_BRACKET = 93;
    protected static final int LETTER_E = 101;
    protected static final int LETTER_BIG_E = 69;
    protected static final int DECIMAL_POINT = 46;
    protected static final int ALPHA_0 = 48;
    protected static final int ALPHA_9 = 57;
    protected static final int MINUS = 45;
    protected static final int PLUS = 43;
    static final String MIN_LONG_STR_NO_SIGN = String.valueOf(Long.MIN_VALUE);
    static final String MAX_LONG_STR = String.valueOf(Long.MAX_VALUE);
    static final String MIN_INT_STR_NO_SIGN = String.valueOf(Integer.MIN_VALUE);
    static final String MAX_INT_STR = String.valueOf(Integer.MAX_VALUE);
    private static double[] powersOf10 = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18};

    public static boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    public static boolean isDecimalDigit(int c) {
        return CharScanner.isDigit(c) || CharScanner.isDecimalChar(c);
    }

    public static boolean isDecimalChar(int currentChar) {
        switch (currentChar) {
            case 43: 
            case 45: 
            case 46: 
            case 69: 
            case 101: {
                return true;
            }
        }
        return false;
    }

    public static boolean hasDecimalChar(char[] chars, boolean negative) {
        int index2 = 0;
        if (negative) {
            ++index2;
        }
        while (index2 < chars.length) {
            switch (chars[index2]) {
                case '+': 
                case '-': 
                case '.': 
                case 'E': 
                case 'e': {
                    return true;
                }
            }
            ++index2;
        }
        return false;
    }

    public static boolean isLong(char[] digitChars) {
        return CharScanner.isLong(digitChars, 0, digitChars.length);
    }

    public static boolean isLong(char[] digitChars, int offset, int len) {
        String cmpStr = digitChars[offset] == '-' ? MIN_LONG_STR_NO_SIGN : MAX_LONG_STR;
        int cmpLen = cmpStr.length();
        if (len < cmpLen) {
            return true;
        }
        if (len > cmpLen) {
            return false;
        }
        for (int i = 0; i < cmpLen; ++i) {
            int diff2 = digitChars[offset + i] - cmpStr.charAt(i);
            if (diff2 == 0) continue;
            return diff2 < 0;
        }
        return true;
    }

    public static boolean isInteger(char[] digitChars) {
        return CharScanner.isInteger(digitChars, 0, digitChars.length);
    }

    public static boolean isInteger(char[] digitChars, int offset, int len) {
        String cmpStr = digitChars[offset] == '-' ? MIN_INT_STR_NO_SIGN : MAX_INT_STR;
        int cmpLen = cmpStr.length();
        if (len < cmpLen) {
            return true;
        }
        if (len > cmpLen) {
            return false;
        }
        for (int i = 0; i < cmpLen; ++i) {
            int diff2 = digitChars[offset + i] - cmpStr.charAt(i);
            if (diff2 == 0) continue;
            return diff2 < 0;
        }
        return true;
    }

    public static int parseInt(char[] digitChars) {
        return CharScanner.parseIntFromTo(digitChars, 0, digitChars.length);
    }

    public static int parseIntFromTo(char[] digitChars, int offset, int to2) {
        try {
            boolean negative = false;
            char c = digitChars[offset];
            if (c == '-') {
                ++offset;
                negative = true;
            }
            if (offset >= to2) {
                Exceptions.die();
            }
            int num = digitChars[offset] - 48;
            if (++offset < to2) {
                num = num * 10 + (digitChars[offset] - 48);
                if (++offset < to2) {
                    num = num * 10 + (digitChars[offset] - 48);
                    if (++offset < to2) {
                        num = num * 10 + (digitChars[offset] - 48);
                        if (++offset < to2) {
                            num = num * 10 + (digitChars[offset] - 48);
                            if (++offset < to2) {
                                num = num * 10 + (digitChars[offset] - 48);
                                if (++offset < to2) {
                                    num = num * 10 + (digitChars[offset] - 48);
                                    if (++offset < to2) {
                                        num = num * 10 + (digitChars[offset] - 48);
                                        if (++offset < to2) {
                                            num = num * 10 + (digitChars[offset] - 48);
                                            if (++offset < to2) {
                                                num = num * 10 + (digitChars[offset] - 48);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return negative ? num * -1 : num;
        }
        catch (Exception ex) {
            return Exceptions.handle(Integer.TYPE, ex);
        }
    }

    public static int parseIntFromToIgnoreDot(char[] digitChars, int offset, int to2) {
        boolean negative = false;
        char c = digitChars[offset];
        if (c == '-') {
            ++offset;
            negative = true;
        }
        if (offset >= to2) {
            Exceptions.die();
        }
        c = digitChars[offset];
        int num = c - 48;
        ++offset;
        while (offset < to2) {
            c = digitChars[offset];
            if (c != '.') {
                num = num * 10 + (c - 48);
            }
            ++offset;
        }
        return negative ? num * -1 : num;
    }

    public static long parseLongFromToIgnoreDot(char[] digitChars, int offset, int to2) {
        boolean negative = false;
        char c = digitChars[offset];
        if (c == '-') {
            ++offset;
            negative = true;
        }
        if (offset >= to2) {
            Exceptions.die();
        }
        c = digitChars[offset];
        long num = c - 48;
        ++offset;
        while (offset < to2) {
            c = digitChars[offset];
            if (c != '.') {
                num = num * 10L + (long)(c - 48);
            }
            ++offset;
        }
        return negative ? num * -1L : num;
    }

    public static long parseLongFromTo(char[] digitChars, int offset, int to2) {
        boolean negative = false;
        char c = digitChars[offset];
        if (c == '-') {
            ++offset;
            negative = true;
        }
        if (offset >= to2) {
            Exceptions.die();
        }
        c = digitChars[offset];
        long num = c - 48;
        ++offset;
        while (offset < to2) {
            c = digitChars[offset];
            long digit2 = c - 48;
            num = num * 10L + digit2;
            ++offset;
        }
        return negative ? num * -1L : num;
    }

    public static long parseLong(char[] digitChars) {
        return CharScanner.parseLongFromTo(digitChars, 0, digitChars.length);
    }

    public static Number parseJsonNumber(char[] buffer) {
        return CharScanner.parseJsonNumber(buffer, 0, buffer.length);
    }

    public static Number parseJsonNumber(char[] buffer, int from2, int to2) {
        return CharScanner.parseJsonNumber(buffer, from2, to2, null);
    }

    public static boolean isNumberDigit(int c) {
        return c >= 48 && c <= 57;
    }

    protected static boolean isDelimiter(int c) {
        return c == 44 || c == 125 || c == 93;
    }

    public static Number parseJsonNumber(char[] buffer, int from2, int max2, int[] size2) {
        Number value2 = null;
        boolean simple = true;
        int digitsPastPoint = 0;
        int index2 = from2;
        if (buffer[index2] == '-') {
            ++index2;
        }
        if (index2 >= max2) {
            Exceptions.die();
        }
        boolean foundDot = false;
        while (index2 < max2) {
            char ch = buffer[index2];
            if (CharScanner.isNumberDigit(ch)) {
                if (foundDot) {
                    ++digitsPastPoint;
                }
            } else {
                if (ch <= ' ' || CharScanner.isDelimiter(ch)) break;
                if (ch == '.') {
                    if (foundDot) {
                        Exceptions.die("unexpected character " + ch);
                    }
                    foundDot = true;
                } else if (ch == 'E' || ch == 'e' || ch == '-' || ch == '+') {
                    simple = false;
                } else {
                    Exceptions.die("unexpected character " + ch);
                }
            }
            ++index2;
        }
        if (digitsPastPoint >= powersOf10.length - 1) {
            simple = false;
        }
        int length = index2 - from2;
        value2 = !foundDot && simple ? (CharScanner.isInteger(buffer, from2, length) ? (Number)CharScanner.parseIntFromTo(buffer, from2, index2) : (Number)CharScanner.parseLongFromTo(buffer, from2, index2)) : new BigDecimal(buffer, from2, length);
        if (size2 != null) {
            size2[0] = index2;
        }
        return value2;
    }

    public static BigDecimal parseBigDecimal(char[] buffer) {
        return new BigDecimal(buffer);
    }

    public static float parseFloat(char[] buffer, int from2, int to2) {
        return (float)CharScanner.parseDouble(buffer, from2, to2);
    }

    public static double parseDouble(char[] buffer, int from2, int to2) {
        double value2;
        boolean simple = true;
        int digitsPastPoint = 0;
        int index2 = from2;
        if (buffer[index2] == '-') {
            ++index2;
        }
        boolean foundDot = false;
        while (index2 < to2) {
            char ch = buffer[index2];
            if (CharScanner.isNumberDigit(ch)) {
                if (foundDot) {
                    ++digitsPastPoint;
                }
            } else if (ch == '.') {
                if (foundDot) {
                    Exceptions.die("unexpected character " + ch);
                }
                foundDot = true;
            } else if (ch == 'E' || ch == 'e' || ch == '-' || ch == '+') {
                simple = false;
            } else {
                Exceptions.die("unexpected character " + ch);
            }
            ++index2;
        }
        if (digitsPastPoint >= powersOf10.length - 1) {
            simple = false;
        }
        int length = index2 - from2;
        if (!foundDot && simple) {
            value2 = CharScanner.isInteger(buffer, from2, length) ? (double)CharScanner.parseIntFromTo(buffer, from2, index2) : (double)CharScanner.parseLongFromTo(buffer, from2, index2);
        } else if (foundDot && simple) {
            if (length < powersOf10.length) {
                long lvalue = CharScanner.isInteger(buffer, from2, length) ? (long)CharScanner.parseIntFromToIgnoreDot(buffer, from2, index2) : CharScanner.parseLongFromToIgnoreDot(buffer, from2, index2);
                double power = powersOf10[digitsPastPoint];
                value2 = (double)lvalue / power;
            } else {
                value2 = Double.parseDouble(new String(buffer, from2, length));
            }
        } else {
            value2 = Double.parseDouble(new String(buffer, from2, index2 - from2));
        }
        return value2;
    }

    public static int skipWhiteSpace(char[] array2, int index2, int length) {
        while (index2 < length) {
            char c = array2[index2];
            if (c > ' ') {
                return index2;
            }
            ++index2;
        }
        return index2;
    }

    public static char[] readNumber(char[] array2, int idx, int len) {
        int startIndex = idx;
        while (CharScanner.isDecimalDigit(array2[idx]) && ++idx < len) {
        }
        return ArrayUtils.copyRange(array2, startIndex, idx);
    }

    public static String errorDetails(String message, char[] array2, int index2, int ch) {
        CharBuf buf = CharBuf.create(255);
        buf.addLine(message);
        buf.addLine("");
        buf.addLine("The current character read is " + CharScanner.debugCharDescription(ch));
        buf.addLine(message);
        int line = 0;
        int lastLineIndex = 0;
        for (int i = 0; i < index2 && i < array2.length; ++i) {
            if (array2[i] != '\n') continue;
            ++line;
            lastLineIndex = i + 1;
        }
        int count2 = 0;
        int i = lastLineIndex;
        while (i < array2.length && array2[i] != '\n') {
            ++i;
            ++count2;
        }
        buf.addLine("line number " + (line + 1));
        buf.addLine("index number " + index2);
        try {
            buf.addLine(new String(array2, lastLineIndex, count2));
        }
        catch (Exception ex) {
            try {
                index2 = index2 - 10 < 0 ? 0 : index2 - 10;
                int start = index2;
                buf.addLine(new String(array2, start, index2));
            }
            catch (Exception ex2) {
                buf.addLine(new String(array2, 0, array2.length));
            }
        }
        for (i = 0; i < index2 - lastLineIndex; ++i) {
            buf.add('.');
        }
        buf.add('^');
        return buf.toString();
    }

    public static String debugCharDescription(int c) {
        String charString = c == 32 ? "[SPACE]" : (c == 9 ? "[TAB]" : (c == 10 ? "[NEWLINE]" : "'" + (char)c + "'"));
        charString = charString + " with an int value of " + c;
        return charString;
    }
}

