/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.ast.tools;

import java.beans.Introspector;
import org.apache.groovy.ast.tools.ClassNodeUtils;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;

public class MethodNodeUtils {
    public static String methodDescriptorWithoutReturnType(MethodNode mNode) {
        StringBuilder sb = new StringBuilder();
        sb.append(mNode.getName()).append(':');
        for (Parameter p : mNode.getParameters()) {
            sb.append(ClassNodeUtils.formatTypeName(p.getType())).append(',');
        }
        return sb.toString();
    }

    public static String methodDescriptor(MethodNode mNode) {
        StringBuilder sb = new StringBuilder(mNode.getName().length() + mNode.getParameters().length * 10);
        sb.append(mNode.getReturnType().getName());
        sb.append(' ');
        sb.append(mNode.getName());
        sb.append('(');
        for (int i = 0; i < mNode.getParameters().length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            Parameter p = mNode.getParameters()[i];
            sb.append(ClassNodeUtils.formatTypeName(p.getType()));
        }
        sb.append(')');
        return sb.toString();
    }

    public static String getPropertyName(MethodNode mNode) {
        String pname;
        String name2 = mNode.getName();
        if ((name2.startsWith("set") || name2.startsWith("get") || name2.startsWith("is")) && !(pname = Introspector.decapitalize(name2.substring(name2.startsWith("is") ? 2 : 3))).isEmpty() && (name2.startsWith("set") ? mNode.getParameters().length == 1 : mNode.getParameters().length == 0 && !ClassHelper.VOID_TYPE.equals(mNode.getReturnType()) && (name2.startsWith("get") || ClassHelper.boolean_TYPE.equals(mNode.getReturnType())))) {
            return pname;
        }
        return null;
    }

    private MethodNodeUtils() {
    }
}

