/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.ast.tools;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.apache.groovy.ast.tools.ClassNodeUtils;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.NumberMath;

public class ExpressionUtils {
    private static ArrayList<Integer> handledTypes = new ArrayList();

    private ExpressionUtils() {
    }

    public static ConstantExpression transformBinaryConstantExpression(BinaryExpression be, ClassNode targetType) {
        int type;
        ClassNode wrapperType = ClassHelper.getWrapper(targetType);
        if (ExpressionUtils.isTypeOrArrayOfType(targetType, ClassHelper.STRING_TYPE, false)) {
            if (be.getOperation().getType() == 200) {
                Expression left = ExpressionUtils.transformInlineConstants(be.getLeftExpression(), targetType);
                Expression right = ExpressionUtils.transformInlineConstants(be.getRightExpression(), targetType);
                if (left instanceof ConstantExpression && right instanceof ConstantExpression) {
                    return ExpressionUtils.configure(be, new ConstantExpression((String)((ConstantExpression)left).getValue() + ((ConstantExpression)right).getValue()));
                }
            }
        } else if (ExpressionUtils.isNumberOrArrayOfNumber(wrapperType, false) && handledTypes.contains(type = be.getOperation().getType())) {
            Expression leftX = ExpressionUtils.transformInlineConstants(be.getLeftExpression(), targetType);
            Expression rightX = ExpressionUtils.transformInlineConstants(be.getRightExpression(), targetType);
            if (leftX instanceof ConstantExpression && rightX instanceof ConstantExpression) {
                Number left = ExpressionUtils.safeNumber((ConstantExpression)leftX);
                Number right = ExpressionUtils.safeNumber((ConstantExpression)rightX);
                if (left == null || right == null) {
                    return null;
                }
                Number result2 = null;
                switch (type) {
                    case 200: {
                        result2 = NumberMath.add(left, right);
                        break;
                    }
                    case 201: {
                        result2 = NumberMath.subtract(left, right);
                        break;
                    }
                    case 202: {
                        result2 = NumberMath.multiply(left, right);
                        break;
                    }
                    case 203: {
                        result2 = NumberMath.divide(left, right);
                        break;
                    }
                    case 280: {
                        result2 = NumberMath.leftShift(left, right);
                        break;
                    }
                    case 281: {
                        result2 = NumberMath.rightShift(left, right);
                        break;
                    }
                    case 282: {
                        result2 = NumberMath.rightShiftUnsigned(left, right);
                        break;
                    }
                    case 341: {
                        result2 = NumberMath.and(left, right);
                        break;
                    }
                    case 340: {
                        result2 = NumberMath.or(left, right);
                        break;
                    }
                    case 342: {
                        result2 = NumberMath.xor(left, right);
                        break;
                    }
                    case 206: {
                        result2 = DefaultGroovyMethods.power(left, right);
                    }
                }
                if (result2 != null) {
                    if (ClassHelper.Byte_TYPE.equals(wrapperType)) {
                        return ExpressionUtils.configure(be, new ConstantExpression(result2.byteValue(), true));
                    }
                    if (ClassHelper.Short_TYPE.equals(wrapperType)) {
                        return ExpressionUtils.configure(be, new ConstantExpression(result2.shortValue(), true));
                    }
                    if (ClassHelper.Long_TYPE.equals(wrapperType)) {
                        return ExpressionUtils.configure(be, new ConstantExpression(result2.longValue(), true));
                    }
                    if (ClassHelper.Integer_TYPE.equals(wrapperType) || ClassHelper.Character_TYPE.equals(wrapperType)) {
                        return ExpressionUtils.configure(be, new ConstantExpression(result2.intValue(), true));
                    }
                    if (ClassHelper.Float_TYPE.equals(wrapperType)) {
                        return ExpressionUtils.configure(be, new ConstantExpression(Float.valueOf(result2.floatValue()), true));
                    }
                    if (ClassHelper.Double_TYPE.equals(wrapperType)) {
                        return ExpressionUtils.configure(be, new ConstantExpression(result2.doubleValue(), true));
                    }
                    return ExpressionUtils.configure(be, new ConstantExpression(result2, true));
                }
            }
        }
        return null;
    }

    private static Number safeNumber(ConstantExpression constX) {
        Object value2 = constX.getValue();
        if (value2 instanceof Number) {
            return (Number)value2;
        }
        return null;
    }

    private static ConstantExpression configure(Expression origX, ConstantExpression newX) {
        newX.setSourcePosition(origX);
        return newX;
    }

    public static boolean isTypeOrArrayOfType(ClassNode targetType, ClassNode type, boolean recurse) {
        if (targetType == null) {
            return false;
        }
        return type.equals(targetType) || (targetType.isArray() && recurse ? ExpressionUtils.isTypeOrArrayOfType(targetType.getComponentType(), type, recurse) : type.equals(targetType.getComponentType()));
    }

    public static boolean isNumberOrArrayOfNumber(ClassNode targetType, boolean recurse) {
        if (targetType == null) {
            return false;
        }
        return targetType.isDerivedFrom(ClassHelper.Number_TYPE) || (targetType.isArray() && recurse ? ExpressionUtils.isNumberOrArrayOfNumber(targetType.getComponentType(), recurse) : targetType.isArray() && targetType.getComponentType().isDerivedFrom(ClassHelper.Number_TYPE));
    }

    public static Expression transformInlineConstants(Expression exp, ClassNode attrType) {
        if (exp instanceof PropertyExpression) {
            PropertyExpression pe = (PropertyExpression)exp;
            if (pe.getObjectExpression() instanceof ClassExpression) {
                ClassExpression ce = (ClassExpression)pe.getObjectExpression();
                ClassNode type = ce.getType();
                if (type.isEnum() || !type.isResolved() && !type.isPrimaryClassNode()) {
                    return exp;
                }
                if (type.isPrimaryClassNode()) {
                    Expression ce2;
                    FieldNode fn2 = type.redirect().getField(pe.getPropertyAsString());
                    if (fn2 != null && fn2.isStatic() && fn2.isFinal() && (ce2 = ExpressionUtils.transformInlineConstants(fn2.getInitialValueExpression(), attrType)) != null) {
                        return ce2;
                    }
                } else {
                    try {
                        Field field2 = type.redirect().getTypeClass().getField(pe.getPropertyAsString());
                        if (field2 != null && Modifier.isStatic(field2.getModifiers()) && Modifier.isFinal(field2.getModifiers())) {
                            ConstantExpression ce3 = new ConstantExpression(field2.get(null), true);
                            ce3.setSourcePosition(exp);
                            return ce3;
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        } else if (exp instanceof BinaryExpression) {
            ConstantExpression ce = ExpressionUtils.transformBinaryConstantExpression((BinaryExpression)exp, attrType);
            if (ce != null) {
                return ce;
            }
        } else if (exp instanceof VariableExpression) {
            Expression ce;
            FieldNode fn3;
            VariableExpression ve = (VariableExpression)exp;
            if (ve.getAccessedVariable() instanceof FieldNode && (fn3 = (FieldNode)ve.getAccessedVariable()).isStatic() && fn3.isFinal() && (ce = ExpressionUtils.transformInlineConstants(fn3.getInitialValueExpression(), attrType)) != null) {
                return ce;
            }
        } else if (exp instanceof ListExpression) {
            return ExpressionUtils.transformListOfConstants((ListExpression)exp, attrType);
        }
        return exp;
    }

    public static Expression transformListOfConstants(ListExpression origList, ClassNode attrType) {
        ListExpression newList = new ListExpression();
        boolean changed = false;
        for (Expression e : origList.getExpressions()) {
            try {
                Expression transformed = ExpressionUtils.transformInlineConstants(e, attrType);
                newList.addExpression(transformed);
                if (transformed == e) continue;
                changed = true;
            }
            catch (Exception ignored) {
                newList.addExpression(e);
            }
        }
        if (changed) {
            newList.setSourcePosition(origList);
            return newList;
        }
        return origList;
    }

    public static Expression transformInlineConstants(Expression exp) {
        if (exp instanceof PropertyExpression) {
            PropertyExpression pe = (PropertyExpression)exp;
            if (pe.getObjectExpression() instanceof ClassExpression) {
                ClassExpression ce = (ClassExpression)pe.getObjectExpression();
                ClassNode type = ce.getType();
                FieldNode field2 = ClassNodeUtils.getField(type, pe.getPropertyAsString());
                if (type.isEnum() && field2 != null && field2.isEnum()) {
                    return exp;
                }
                Expression constant = ExpressionUtils.findConstant(field2);
                if (constant != null) {
                    return constant;
                }
            }
        } else {
            if (exp instanceof BinaryExpression) {
                BinaryExpression be = (BinaryExpression)exp;
                be.setLeftExpression(ExpressionUtils.transformInlineConstants(be.getLeftExpression()));
                be.setRightExpression(ExpressionUtils.transformInlineConstants(be.getRightExpression()));
                return be;
            }
            if (exp instanceof ListExpression) {
                ListExpression origList = (ListExpression)exp;
                ListExpression newList = new ListExpression();
                boolean changed = false;
                for (Expression e : origList.getExpressions()) {
                    Expression transformed = ExpressionUtils.transformInlineConstants(e);
                    newList.addExpression(transformed);
                    if (transformed == e) continue;
                    changed = true;
                }
                if (changed) {
                    newList.setSourcePosition(origList);
                    return newList;
                }
                return origList;
            }
        }
        return exp;
    }

    private static Expression findConstant(FieldNode fn2) {
        if (fn2 != null && !fn2.isEnum() && fn2.isStatic() && fn2.isFinal() && fn2.getInitialValueExpression() instanceof ConstantExpression) {
            return fn2.getInitialValueExpression();
        }
        return null;
    }

    static {
        handledTypes.add(200);
        handledTypes.add(201);
        handledTypes.add(202);
        handledTypes.add(203);
        handledTypes.add(280);
        handledTypes.add(281);
        handledTypes.add(282);
        handledTypes.add(340);
        handledTypes.add(341);
        handledTypes.add(342);
        handledTypes.add(206);
    }
}

