/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.exception;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class ExceptionUtils {
    private static final int NOT_FOUND = -1;
    private static final String[] CAUSE_METHOD_NAMES = new String[]{"getCause", "getNextException", "getTargetException", "getException", "getSourceException", "getRootCause", "getCausedByException", "getNested", "getLinkedException", "getNestedException", "getLinkedCause", "getThrowable"};
    static final String WRAPPED_MARKER = " [wrapped] ";

    @Deprecated
    public static Throwable getCause(Throwable throwable2) {
        return ExceptionUtils.getCause(throwable2, null);
    }

    @Deprecated
    public static Throwable getCause(Throwable throwable2, String[] methodNames2) {
        if (throwable2 == null) {
            return null;
        }
        if (methodNames2 == null) {
            Throwable cause = throwable2.getCause();
            if (cause != null) {
                return cause;
            }
            methodNames2 = CAUSE_METHOD_NAMES;
        }
        for (String methodName : methodNames2) {
            Throwable legacyCause;
            if (methodName == null || (legacyCause = ExceptionUtils.getCauseUsingMethodName(throwable2, methodName)) == null) continue;
            return legacyCause;
        }
        return null;
    }

    private static Throwable getCauseUsingMethodName(Throwable throwable2, String methodName) {
        Method method = null;
        try {
            method = throwable2.getClass().getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        if (method != null && Throwable.class.isAssignableFrom(method.getReturnType())) {
            try {
                return (Throwable)method.invoke((Object)throwable2, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Deprecated
    public static String[] getDefaultCauseMethodNames() {
        return ArrayUtils.clone(CAUSE_METHOD_NAMES);
    }

    public static String getMessage(Throwable th) {
        if (th == null) {
            return "";
        }
        String clsName = ClassUtils.getShortClassName(th, null);
        String msg = th.getMessage();
        return clsName + ": " + StringUtils.defaultString(msg);
    }

    public static Throwable getRootCause(Throwable throwable2) {
        List<Throwable> list2 = ExceptionUtils.getThrowableList(throwable2);
        return list2.isEmpty() ? null : list2.get(list2.size() - 1);
    }

    public static String getRootCauseMessage(Throwable th) {
        Throwable root2 = ExceptionUtils.getRootCause(th);
        root2 = root2 == null ? th : root2;
        return ExceptionUtils.getMessage(root2);
    }

    public static String[] getRootCauseStackTrace(Throwable throwable2) {
        if (throwable2 == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        Throwable[] throwables = ExceptionUtils.getThrowables(throwable2);
        int count2 = throwables.length;
        ArrayList<String> frames = new ArrayList<String>();
        List<String> nextTrace = ExceptionUtils.getStackFrameList(throwables[count2 - 1]);
        int i = count2;
        while (--i >= 0) {
            List<String> trace = nextTrace;
            if (i != 0) {
                nextTrace = ExceptionUtils.getStackFrameList(throwables[i - 1]);
                ExceptionUtils.removeCommonFrames(trace, nextTrace);
            }
            if (i == count2 - 1) {
                frames.add(throwables[i].toString());
            } else {
                frames.add(WRAPPED_MARKER + throwables[i].toString());
            }
            frames.addAll(trace);
        }
        return frames.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    static List<String> getStackFrameList(Throwable t) {
        String stackTrace = ExceptionUtils.getStackTrace(t);
        String linebreak = System.lineSeparator();
        StringTokenizer frames = new StringTokenizer(stackTrace, linebreak);
        ArrayList<String> list2 = new ArrayList<String>();
        boolean traceStarted = false;
        while (frames.hasMoreTokens()) {
            String token2 = frames.nextToken();
            int at = token2.indexOf("at");
            if (at != -1 && token2.substring(0, at).trim().isEmpty()) {
                traceStarted = true;
                list2.add(token2);
                continue;
            }
            if (!traceStarted) continue;
            break;
        }
        return list2;
    }

    static String[] getStackFrames(String stackTrace) {
        String linebreak = System.lineSeparator();
        StringTokenizer frames = new StringTokenizer(stackTrace, linebreak);
        ArrayList<String> list2 = new ArrayList<String>();
        while (frames.hasMoreTokens()) {
            list2.add(frames.nextToken());
        }
        return list2.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public static String[] getStackFrames(Throwable throwable2) {
        if (throwable2 == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return ExceptionUtils.getStackFrames(ExceptionUtils.getStackTrace(throwable2));
    }

    public static String getStackTrace(Throwable throwable2) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable2.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    public static int getThrowableCount(Throwable throwable2) {
        return ExceptionUtils.getThrowableList(throwable2).size();
    }

    public static List<Throwable> getThrowableList(Throwable throwable2) {
        ArrayList<Throwable> list2 = new ArrayList<Throwable>();
        while (throwable2 != null && !list2.contains(throwable2)) {
            list2.add(throwable2);
            throwable2 = throwable2.getCause();
        }
        return list2;
    }

    public static Throwable[] getThrowables(Throwable throwable2) {
        List<Throwable> list2 = ExceptionUtils.getThrowableList(throwable2);
        return list2.toArray(ArrayUtils.EMPTY_THROWABLE_ARRAY);
    }

    public static boolean hasCause(Throwable chain2, Class<? extends Throwable> type) {
        if (chain2 instanceof UndeclaredThrowableException) {
            chain2 = chain2.getCause();
        }
        return type.isInstance(chain2);
    }

    private static int indexOf(Throwable throwable2, Class<? extends Throwable> type, int fromIndex, boolean subclass) {
        Throwable[] throwables;
        if (throwable2 == null || type == null) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (fromIndex >= (throwables = ExceptionUtils.getThrowables(throwable2)).length) {
            return -1;
        }
        if (subclass) {
            for (int i = fromIndex; i < throwables.length; ++i) {
                if (!type.isAssignableFrom(throwables[i].getClass())) continue;
                return i;
            }
        } else {
            for (int i = fromIndex; i < throwables.length; ++i) {
                if (!type.equals(throwables[i].getClass())) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOfThrowable(Throwable throwable2, Class<? extends Throwable> clazz2) {
        return ExceptionUtils.indexOf(throwable2, clazz2, 0, false);
    }

    public static int indexOfThrowable(Throwable throwable2, Class<? extends Throwable> clazz2, int fromIndex) {
        return ExceptionUtils.indexOf(throwable2, clazz2, fromIndex, false);
    }

    public static int indexOfType(Throwable throwable2, Class<? extends Throwable> type) {
        return ExceptionUtils.indexOf(throwable2, type, 0, true);
    }

    public static int indexOfType(Throwable throwable2, Class<? extends Throwable> type, int fromIndex) {
        return ExceptionUtils.indexOf(throwable2, type, fromIndex, true);
    }

    public static void printRootCauseStackTrace(Throwable throwable2) {
        ExceptionUtils.printRootCauseStackTrace(throwable2, System.err);
    }

    public static void printRootCauseStackTrace(Throwable throwable2, PrintStream stream) {
        String[] trace;
        if (throwable2 == null) {
            return;
        }
        Validate.notNull(stream, "The PrintStream must not be null", new Object[0]);
        for (String element : trace = ExceptionUtils.getRootCauseStackTrace(throwable2)) {
            stream.println(element);
        }
        stream.flush();
    }

    public static void printRootCauseStackTrace(Throwable throwable2, PrintWriter writer) {
        String[] trace;
        if (throwable2 == null) {
            return;
        }
        Validate.notNull(writer, "The PrintWriter must not be null", new Object[0]);
        for (String element : trace = ExceptionUtils.getRootCauseStackTrace(throwable2)) {
            writer.println(element);
        }
        writer.flush();
    }

    public static void removeCommonFrames(List<String> causeFrames, List<String> wrapperFrames) {
        if (causeFrames == null || wrapperFrames == null) {
            throw new IllegalArgumentException("The List must not be null");
        }
        int causeFrameIndex = causeFrames.size() - 1;
        for (int wrapperFrameIndex = wrapperFrames.size() - 1; causeFrameIndex >= 0 && wrapperFrameIndex >= 0; --causeFrameIndex, --wrapperFrameIndex) {
            String wrapperFrame;
            String causeFrame = causeFrames.get(causeFrameIndex);
            if (!causeFrame.equals(wrapperFrame = wrapperFrames.get(wrapperFrameIndex))) continue;
            causeFrames.remove(causeFrameIndex);
        }
    }

    public static <R> R rethrow(Throwable throwable2) {
        return ExceptionUtils.typeErasure(throwable2);
    }

    private static <T extends Throwable> T throwableOf(Throwable throwable2, Class<T> type, int fromIndex, boolean subclass) {
        Throwable[] throwables;
        if (throwable2 == null || type == null) {
            return null;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (fromIndex >= (throwables = ExceptionUtils.getThrowables(throwable2)).length) {
            return null;
        }
        if (subclass) {
            for (int i = fromIndex; i < throwables.length; ++i) {
                if (!type.isAssignableFrom(throwables[i].getClass())) continue;
                return (T)((Throwable)type.cast(throwables[i]));
            }
        } else {
            for (int i = fromIndex; i < throwables.length; ++i) {
                if (!type.equals(throwables[i].getClass())) continue;
                return (T)((Throwable)type.cast(throwables[i]));
            }
        }
        return null;
    }

    public static <T extends Throwable> T throwableOfThrowable(Throwable throwable2, Class<T> clazz2) {
        return ExceptionUtils.throwableOf(throwable2, clazz2, 0, false);
    }

    public static <T extends Throwable> T throwableOfThrowable(Throwable throwable2, Class<T> clazz2, int fromIndex) {
        return ExceptionUtils.throwableOf(throwable2, clazz2, fromIndex, false);
    }

    public static <T extends Throwable> T throwableOfType(Throwable throwable2, Class<T> type) {
        return ExceptionUtils.throwableOf(throwable2, type, 0, true);
    }

    public static <T extends Throwable> T throwableOfType(Throwable throwable2, Class<T> type, int fromIndex) {
        return ExceptionUtils.throwableOf(throwable2, type, fromIndex, true);
    }

    private static <R, T extends Throwable> R typeErasure(Throwable throwable2) throws T {
        throw throwable2;
    }

    public static <R> R wrapAndThrow(Throwable throwable2) {
        if (throwable2 instanceof RuntimeException) {
            throw (RuntimeException)throwable2;
        }
        if (throwable2 instanceof Error) {
            throw (Error)throwable2;
        }
        throw new UndeclaredThrowableException(throwable2);
    }
}

