/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.builder.Builder;
import org.apache.commons.lang3.builder.DiffBuilder;
import org.apache.commons.lang3.builder.DiffResult;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.reflect.FieldUtils;

public class ReflectionDiffBuilder<T>
implements Builder<DiffResult<T>> {
    private final Object left;
    private final Object right;
    private final DiffBuilder<T> diffBuilder;

    public ReflectionDiffBuilder(T lhs, T rhs, ToStringStyle style) {
        this.left = lhs;
        this.right = rhs;
        this.diffBuilder = new DiffBuilder<T>(lhs, rhs, style);
    }

    @Override
    public DiffResult<T> build() {
        if (this.left.equals(this.right)) {
            return this.diffBuilder.build();
        }
        this.appendFields(this.left.getClass());
        return this.diffBuilder.build();
    }

    private void appendFields(Class<?> clazz2) {
        for (Field field2 : FieldUtils.getAllFields(clazz2)) {
            if (!this.accept(field2)) continue;
            try {
                this.diffBuilder.append(field2.getName(), FieldUtils.readField(field2, this.left, true), FieldUtils.readField(field2, this.right, true));
            }
            catch (IllegalAccessException ex) {
                throw new InternalError("Unexpected IllegalAccessException: " + ex.getMessage());
            }
        }
    }

    private boolean accept(Field field2) {
        if (field2.getName().indexOf(36) != -1) {
            return false;
        }
        if (Modifier.isTransient(field2.getModifiers())) {
            return false;
        }
        return !Modifier.isStatic(field2.getModifiers());
    }
}

