/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.mutable.MutableInt;

public class ArrayUtils {
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    public static final Boolean[] EMPTY_BOOLEAN_OBJECT_ARRAY = new Boolean[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final Byte[] EMPTY_BYTE_OBJECT_ARRAY = new Byte[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final Character[] EMPTY_CHARACTER_OBJECT_ARRAY = new Character[0];
    public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final Double[] EMPTY_DOUBLE_OBJECT_ARRAY = new Double[0];
    public static final Field[] EMPTY_FIELD_ARRAY = new Field[0];
    public static final Method[] EMPTY_METHOD_ARRAY = new Method[0];
    public static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    public static final Float[] EMPTY_FLOAT_OBJECT_ARRAY = new Float[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final Integer[] EMPTY_INTEGER_OBJECT_ARRAY = new Integer[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final Long[] EMPTY_LONG_OBJECT_ARRAY = new Long[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final short[] EMPTY_SHORT_ARRAY = new short[0];
    public static final Short[] EMPTY_SHORT_OBJECT_ARRAY = new Short[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Throwable[] EMPTY_THROWABLE_ARRAY = new Throwable[0];
    public static final Type[] EMPTY_TYPE_ARRAY = new Type[0];
    public static final int INDEX_NOT_FOUND = -1;

    public static boolean[] add(boolean[] array2, boolean element) {
        boolean[] newArray = (boolean[])ArrayUtils.copyArrayGrow1(array2, Boolean.TYPE);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    @Deprecated
    public static boolean[] add(boolean[] array2, int index2, boolean element) {
        return (boolean[])ArrayUtils.add(array2, index2, element, Boolean.TYPE);
    }

    public static byte[] add(byte[] array2, byte element) {
        byte[] newArray = (byte[])ArrayUtils.copyArrayGrow1(array2, Byte.TYPE);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    @Deprecated
    public static byte[] add(byte[] array2, int index2, byte element) {
        return (byte[])ArrayUtils.add(array2, index2, element, Byte.TYPE);
    }

    public static char[] add(char[] array2, char element) {
        char[] newArray = (char[])ArrayUtils.copyArrayGrow1(array2, Character.TYPE);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    @Deprecated
    public static char[] add(char[] array2, int index2, char element) {
        return (char[])ArrayUtils.add(array2, index2, Character.valueOf(element), Character.TYPE);
    }

    public static double[] add(double[] array2, double element) {
        double[] newArray = (double[])ArrayUtils.copyArrayGrow1(array2, Double.TYPE);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    @Deprecated
    public static double[] add(double[] array2, int index2, double element) {
        return (double[])ArrayUtils.add(array2, index2, element, Double.TYPE);
    }

    public static float[] add(float[] array2, float element) {
        float[] newArray = (float[])ArrayUtils.copyArrayGrow1(array2, Float.TYPE);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    @Deprecated
    public static float[] add(float[] array2, int index2, float element) {
        return (float[])ArrayUtils.add(array2, index2, Float.valueOf(element), Float.TYPE);
    }

    public static int[] add(int[] array2, int element) {
        int[] newArray = (int[])ArrayUtils.copyArrayGrow1(array2, Integer.TYPE);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    @Deprecated
    public static int[] add(int[] array2, int index2, int element) {
        return (int[])ArrayUtils.add(array2, index2, element, Integer.TYPE);
    }

    @Deprecated
    public static long[] add(long[] array2, int index2, long element) {
        return (long[])ArrayUtils.add(array2, index2, element, Long.TYPE);
    }

    public static long[] add(long[] array2, long element) {
        long[] newArray = (long[])ArrayUtils.copyArrayGrow1(array2, Long.TYPE);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    private static Object add(Object array2, int index2, Object element, Class<?> clss) {
        if (array2 == null) {
            if (index2 != 0) {
                throw new IndexOutOfBoundsException("Index: " + index2 + ", Length: 0");
            }
            Object joinedArray = Array.newInstance(clss, 1);
            Array.set(joinedArray, 0, element);
            return joinedArray;
        }
        int length = Array.getLength(array2);
        if (index2 > length || index2 < 0) {
            throw new IndexOutOfBoundsException("Index: " + index2 + ", Length: " + length);
        }
        Object result2 = Array.newInstance(clss, length + 1);
        System.arraycopy(array2, 0, result2, 0, index2);
        Array.set(result2, index2, element);
        if (index2 < length) {
            System.arraycopy(array2, index2, result2, index2 + 1, length - index2);
        }
        return result2;
    }

    @Deprecated
    public static short[] add(short[] array2, int index2, short element) {
        return (short[])ArrayUtils.add(array2, index2, element, Short.TYPE);
    }

    public static short[] add(short[] array2, short element) {
        short[] newArray = (short[])ArrayUtils.copyArrayGrow1(array2, Short.TYPE);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    @Deprecated
    public static <T> T[] add(T[] array2, int index2, T element) {
        Class<?> clss = null;
        if (array2 != null) {
            clss = array2.getClass().getComponentType();
        } else if (element != null) {
            clss = element.getClass();
        } else {
            throw new IllegalArgumentException("Array and element cannot both be null");
        }
        Object[] newArray = (Object[])ArrayUtils.add(array2, index2, element, clss);
        return newArray;
    }

    public static <T> T[] add(T[] array2, T element) {
        Class<?> type;
        if (array2 != null) {
            type = array2.getClass().getComponentType();
        } else if (element != null) {
            type = element.getClass();
        } else {
            throw new IllegalArgumentException("Arguments cannot both be null");
        }
        Object[] newArray = (Object[])ArrayUtils.copyArrayGrow1(array2, type);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    public static boolean[] addAll(boolean[] array1, boolean ... array2) {
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        boolean[] joinedArray = new boolean[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public static byte[] addAll(byte[] array1, byte ... array2) {
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        byte[] joinedArray = new byte[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public static char[] addAll(char[] array1, char ... array2) {
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        char[] joinedArray = new char[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public static double[] addAll(double[] array1, double ... array2) {
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        double[] joinedArray = new double[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public static float[] addAll(float[] array1, float ... array2) {
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        float[] joinedArray = new float[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public static int[] addAll(int[] array1, int ... array2) {
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        int[] joinedArray = new int[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public static long[] addAll(long[] array1, long ... array2) {
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        long[] joinedArray = new long[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public static short[] addAll(short[] array1, short ... array2) {
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        short[] joinedArray = new short[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public static <T> T[] addAll(T[] array1, T ... array2) {
        if (array1 == null) {
            return ArrayUtils.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtils.clone(array1);
        }
        Class<?> type1 = array1.getClass().getComponentType();
        Object[] joinedArray = (Object[])Array.newInstance(type1, array1.length + array2.length);
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        try {
            System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        }
        catch (ArrayStoreException ase) {
            Class<?> type2 = array2.getClass().getComponentType();
            if (!type1.isAssignableFrom(type2)) {
                throw new IllegalArgumentException("Cannot store " + type2.getName() + " in an array of " + type1.getName(), ase);
            }
            throw ase;
        }
        return joinedArray;
    }

    public static boolean[] addFirst(boolean[] array2, boolean element) {
        return array2 == null ? ArrayUtils.add(array2, element) : ArrayUtils.insert(0, array2, element);
    }

    public static byte[] addFirst(byte[] array2, byte element) {
        return array2 == null ? ArrayUtils.add(array2, element) : ArrayUtils.insert(0, array2, element);
    }

    public static char[] addFirst(char[] array2, char element) {
        return array2 == null ? ArrayUtils.add(array2, element) : ArrayUtils.insert(0, array2, element);
    }

    public static double[] addFirst(double[] array2, double element) {
        return array2 == null ? ArrayUtils.add(array2, element) : ArrayUtils.insert(0, array2, element);
    }

    public static float[] addFirst(float[] array2, float element) {
        return array2 == null ? ArrayUtils.add(array2, element) : ArrayUtils.insert(0, array2, element);
    }

    public static int[] addFirst(int[] array2, int element) {
        return array2 == null ? ArrayUtils.add(array2, element) : ArrayUtils.insert(0, array2, element);
    }

    public static long[] addFirst(long[] array2, long element) {
        return array2 == null ? ArrayUtils.add(array2, element) : ArrayUtils.insert(0, array2, element);
    }

    public static short[] addFirst(short[] array2, short element) {
        return array2 == null ? ArrayUtils.add(array2, element) : ArrayUtils.insert(0, array2, element);
    }

    public static <T> T[] addFirst(T[] array2, T element) {
        return array2 == null ? ArrayUtils.add(array2, element) : ArrayUtils.insert(0, array2, element);
    }

    public static boolean[] clone(boolean[] array2) {
        if (array2 == null) {
            return null;
        }
        return (boolean[])array2.clone();
    }

    public static byte[] clone(byte[] array2) {
        if (array2 == null) {
            return null;
        }
        return (byte[])array2.clone();
    }

    public static char[] clone(char[] array2) {
        if (array2 == null) {
            return null;
        }
        return (char[])array2.clone();
    }

    public static double[] clone(double[] array2) {
        if (array2 == null) {
            return null;
        }
        return (double[])array2.clone();
    }

    public static float[] clone(float[] array2) {
        if (array2 == null) {
            return null;
        }
        return (float[])array2.clone();
    }

    public static int[] clone(int[] array2) {
        if (array2 == null) {
            return null;
        }
        return (int[])array2.clone();
    }

    public static long[] clone(long[] array2) {
        if (array2 == null) {
            return null;
        }
        return (long[])array2.clone();
    }

    public static short[] clone(short[] array2) {
        if (array2 == null) {
            return null;
        }
        return (short[])array2.clone();
    }

    public static <T> T[] clone(T[] array2) {
        if (array2 == null) {
            return null;
        }
        return (Object[])array2.clone();
    }

    public static boolean contains(boolean[] array2, boolean valueToFind) {
        return ArrayUtils.indexOf(array2, valueToFind) != -1;
    }

    public static boolean contains(byte[] array2, byte valueToFind) {
        return ArrayUtils.indexOf(array2, valueToFind) != -1;
    }

    public static boolean contains(char[] array2, char valueToFind) {
        return ArrayUtils.indexOf(array2, valueToFind) != -1;
    }

    public static boolean contains(double[] array2, double valueToFind) {
        return ArrayUtils.indexOf(array2, valueToFind) != -1;
    }

    public static boolean contains(double[] array2, double valueToFind, double tolerance) {
        return ArrayUtils.indexOf(array2, valueToFind, 0, tolerance) != -1;
    }

    public static boolean contains(float[] array2, float valueToFind) {
        return ArrayUtils.indexOf(array2, valueToFind) != -1;
    }

    public static boolean contains(int[] array2, int valueToFind) {
        return ArrayUtils.indexOf(array2, valueToFind) != -1;
    }

    public static boolean contains(long[] array2, long valueToFind) {
        return ArrayUtils.indexOf(array2, valueToFind) != -1;
    }

    public static boolean contains(Object[] array2, Object objectToFind) {
        return ArrayUtils.indexOf(array2, objectToFind) != -1;
    }

    public static boolean contains(short[] array2, short valueToFind) {
        return ArrayUtils.indexOf(array2, valueToFind) != -1;
    }

    private static Object copyArrayGrow1(Object array2, Class<?> newArrayComponentType) {
        if (array2 != null) {
            int arrayLength = Array.getLength(array2);
            Object newArray = Array.newInstance(array2.getClass().getComponentType(), arrayLength + 1);
            System.arraycopy(array2, 0, newArray, 0, arrayLength);
            return newArray;
        }
        return Array.newInstance(newArrayComponentType, 1);
    }

    public static int getLength(Object array2) {
        if (array2 == null) {
            return 0;
        }
        return Array.getLength(array2);
    }

    public static int hashCode(Object array2) {
        return new HashCodeBuilder().append(array2).toHashCode();
    }

    public static BitSet indexesOf(boolean[] array2, boolean valueToFind) {
        return ArrayUtils.indexesOf(array2, valueToFind, 0);
    }

    public static BitSet indexesOf(boolean[] array2, boolean valueToFind, int startIndex) {
        BitSet bitSet = new BitSet();
        if (array2 == null) {
            return bitSet;
        }
        while (startIndex < array2.length && (startIndex = ArrayUtils.indexOf(array2, valueToFind, startIndex)) != -1) {
            bitSet.set(startIndex);
            ++startIndex;
        }
        return bitSet;
    }

    public static BitSet indexesOf(byte[] array2, byte valueToFind) {
        return ArrayUtils.indexesOf(array2, valueToFind, 0);
    }

    public static BitSet indexesOf(byte[] array2, byte valueToFind, int startIndex) {
        BitSet bitSet = new BitSet();
        if (array2 == null) {
            return bitSet;
        }
        while (startIndex < array2.length && (startIndex = ArrayUtils.indexOf(array2, valueToFind, startIndex)) != -1) {
            bitSet.set(startIndex);
            ++startIndex;
        }
        return bitSet;
    }

    public static BitSet indexesOf(char[] array2, char valueToFind) {
        return ArrayUtils.indexesOf(array2, valueToFind, 0);
    }

    public static BitSet indexesOf(char[] array2, char valueToFind, int startIndex) {
        BitSet bitSet = new BitSet();
        if (array2 == null) {
            return bitSet;
        }
        while (startIndex < array2.length && (startIndex = ArrayUtils.indexOf(array2, valueToFind, startIndex)) != -1) {
            bitSet.set(startIndex);
            ++startIndex;
        }
        return bitSet;
    }

    public static BitSet indexesOf(double[] array2, double valueToFind) {
        return ArrayUtils.indexesOf(array2, valueToFind, 0);
    }

    public static BitSet indexesOf(double[] array2, double valueToFind, double tolerance) {
        return ArrayUtils.indexesOf(array2, valueToFind, 0, tolerance);
    }

    public static BitSet indexesOf(double[] array2, double valueToFind, int startIndex) {
        BitSet bitSet = new BitSet();
        if (array2 == null) {
            return bitSet;
        }
        while (startIndex < array2.length && (startIndex = ArrayUtils.indexOf(array2, valueToFind, startIndex)) != -1) {
            bitSet.set(startIndex);
            ++startIndex;
        }
        return bitSet;
    }

    public static BitSet indexesOf(double[] array2, double valueToFind, int startIndex, double tolerance) {
        BitSet bitSet = new BitSet();
        if (array2 == null) {
            return bitSet;
        }
        while (startIndex < array2.length && (startIndex = ArrayUtils.indexOf(array2, valueToFind, startIndex, tolerance)) != -1) {
            bitSet.set(startIndex);
            ++startIndex;
        }
        return bitSet;
    }

    public static BitSet indexesOf(float[] array2, float valueToFind) {
        return ArrayUtils.indexesOf(array2, valueToFind, 0);
    }

    public static BitSet indexesOf(float[] array2, float valueToFind, int startIndex) {
        BitSet bitSet = new BitSet();
        if (array2 == null) {
            return bitSet;
        }
        while (startIndex < array2.length && (startIndex = ArrayUtils.indexOf(array2, valueToFind, startIndex)) != -1) {
            bitSet.set(startIndex);
            ++startIndex;
        }
        return bitSet;
    }

    public static BitSet indexesOf(int[] array2, int valueToFind) {
        return ArrayUtils.indexesOf(array2, valueToFind, 0);
    }

    public static BitSet indexesOf(int[] array2, int valueToFind, int startIndex) {
        BitSet bitSet = new BitSet();
        if (array2 == null) {
            return bitSet;
        }
        while (startIndex < array2.length && (startIndex = ArrayUtils.indexOf(array2, valueToFind, startIndex)) != -1) {
            bitSet.set(startIndex);
            ++startIndex;
        }
        return bitSet;
    }

    public static BitSet indexesOf(long[] array2, long valueToFind) {
        return ArrayUtils.indexesOf(array2, valueToFind, 0);
    }

    public static BitSet indexesOf(long[] array2, long valueToFind, int startIndex) {
        BitSet bitSet = new BitSet();
        if (array2 == null) {
            return bitSet;
        }
        while (startIndex < array2.length && (startIndex = ArrayUtils.indexOf(array2, valueToFind, startIndex)) != -1) {
            bitSet.set(startIndex);
            ++startIndex;
        }
        return bitSet;
    }

    public static BitSet indexesOf(Object[] array2, Object objectToFind) {
        return ArrayUtils.indexesOf(array2, objectToFind, 0);
    }

    public static BitSet indexesOf(Object[] array2, Object objectToFind, int startIndex) {
        BitSet bitSet = new BitSet();
        if (array2 == null) {
            return bitSet;
        }
        while (startIndex < array2.length && (startIndex = ArrayUtils.indexOf(array2, objectToFind, startIndex)) != -1) {
            bitSet.set(startIndex);
            ++startIndex;
        }
        return bitSet;
    }

    public static BitSet indexesOf(short[] array2, short valueToFind) {
        return ArrayUtils.indexesOf(array2, valueToFind, 0);
    }

    public static BitSet indexesOf(short[] array2, short valueToFind, int startIndex) {
        BitSet bitSet = new BitSet();
        if (array2 == null) {
            return bitSet;
        }
        while (startIndex < array2.length && (startIndex = ArrayUtils.indexOf(array2, valueToFind, startIndex)) != -1) {
            bitSet.set(startIndex);
            ++startIndex;
        }
        return bitSet;
    }

    public static int indexOf(boolean[] array2, boolean valueToFind) {
        return ArrayUtils.indexOf(array2, valueToFind, 0);
    }

    public static int indexOf(boolean[] array2, boolean valueToFind, int startIndex) {
        if (ArrayUtils.isEmpty(array2)) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array2.length; ++i) {
            if (valueToFind != array2[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(byte[] array2, byte valueToFind) {
        return ArrayUtils.indexOf(array2, valueToFind, 0);
    }

    public static int indexOf(byte[] array2, byte valueToFind, int startIndex) {
        if (array2 == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array2.length; ++i) {
            if (valueToFind != array2[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(char[] array2, char valueToFind) {
        return ArrayUtils.indexOf(array2, valueToFind, 0);
    }

    public static int indexOf(char[] array2, char valueToFind, int startIndex) {
        if (array2 == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array2.length; ++i) {
            if (valueToFind != array2[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(double[] array2, double valueToFind) {
        return ArrayUtils.indexOf(array2, valueToFind, 0);
    }

    public static int indexOf(double[] array2, double valueToFind, double tolerance) {
        return ArrayUtils.indexOf(array2, valueToFind, 0, tolerance);
    }

    public static int indexOf(double[] array2, double valueToFind, int startIndex) {
        if (ArrayUtils.isEmpty(array2)) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array2.length; ++i) {
            if (valueToFind != array2[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(double[] array2, double valueToFind, int startIndex, double tolerance) {
        if (ArrayUtils.isEmpty(array2)) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        double min2 = valueToFind - tolerance;
        double max2 = valueToFind + tolerance;
        for (int i = startIndex; i < array2.length; ++i) {
            if (!(array2[i] >= min2) || !(array2[i] <= max2)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(float[] array2, float valueToFind) {
        return ArrayUtils.indexOf(array2, valueToFind, 0);
    }

    public static int indexOf(float[] array2, float valueToFind, int startIndex) {
        if (ArrayUtils.isEmpty(array2)) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array2.length; ++i) {
            if (valueToFind != array2[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int[] array2, int valueToFind) {
        return ArrayUtils.indexOf(array2, valueToFind, 0);
    }

    public static int indexOf(int[] array2, int valueToFind, int startIndex) {
        if (array2 == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array2.length; ++i) {
            if (valueToFind != array2[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(long[] array2, long valueToFind) {
        return ArrayUtils.indexOf(array2, valueToFind, 0);
    }

    public static int indexOf(long[] array2, long valueToFind, int startIndex) {
        if (array2 == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array2.length; ++i) {
            if (valueToFind != array2[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(Object[] array2, Object objectToFind) {
        return ArrayUtils.indexOf(array2, objectToFind, 0);
    }

    public static int indexOf(Object[] array2, Object objectToFind, int startIndex) {
        if (array2 == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (objectToFind == null) {
            for (int i = startIndex; i < array2.length; ++i) {
                if (array2[i] != null) continue;
                return i;
            }
        } else {
            for (int i = startIndex; i < array2.length; ++i) {
                if (!objectToFind.equals(array2[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(short[] array2, short valueToFind) {
        return ArrayUtils.indexOf(array2, valueToFind, 0);
    }

    public static int indexOf(short[] array2, short valueToFind, int startIndex) {
        if (array2 == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array2.length; ++i) {
            if (valueToFind != array2[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean[] insert(int index2, boolean[] array2, boolean ... values2) {
        if (array2 == null) {
            return null;
        }
        if (ArrayUtils.isEmpty(values2)) {
            return ArrayUtils.clone(array2);
        }
        if (index2 < 0 || index2 > array2.length) {
            throw new IndexOutOfBoundsException("Index: " + index2 + ", Length: " + array2.length);
        }
        boolean[] result2 = new boolean[array2.length + values2.length];
        System.arraycopy(values2, 0, result2, index2, values2.length);
        if (index2 > 0) {
            System.arraycopy(array2, 0, result2, 0, index2);
        }
        if (index2 < array2.length) {
            System.arraycopy(array2, index2, result2, index2 + values2.length, array2.length - index2);
        }
        return result2;
    }

    public static byte[] insert(int index2, byte[] array2, byte ... values2) {
        if (array2 == null) {
            return null;
        }
        if (ArrayUtils.isEmpty(values2)) {
            return ArrayUtils.clone(array2);
        }
        if (index2 < 0 || index2 > array2.length) {
            throw new IndexOutOfBoundsException("Index: " + index2 + ", Length: " + array2.length);
        }
        byte[] result2 = new byte[array2.length + values2.length];
        System.arraycopy(values2, 0, result2, index2, values2.length);
        if (index2 > 0) {
            System.arraycopy(array2, 0, result2, 0, index2);
        }
        if (index2 < array2.length) {
            System.arraycopy(array2, index2, result2, index2 + values2.length, array2.length - index2);
        }
        return result2;
    }

    public static char[] insert(int index2, char[] array2, char ... values2) {
        if (array2 == null) {
            return null;
        }
        if (ArrayUtils.isEmpty(values2)) {
            return ArrayUtils.clone(array2);
        }
        if (index2 < 0 || index2 > array2.length) {
            throw new IndexOutOfBoundsException("Index: " + index2 + ", Length: " + array2.length);
        }
        char[] result2 = new char[array2.length + values2.length];
        System.arraycopy(values2, 0, result2, index2, values2.length);
        if (index2 > 0) {
            System.arraycopy(array2, 0, result2, 0, index2);
        }
        if (index2 < array2.length) {
            System.arraycopy(array2, index2, result2, index2 + values2.length, array2.length - index2);
        }
        return result2;
    }

    public static double[] insert(int index2, double[] array2, double ... values2) {
        if (array2 == null) {
            return null;
        }
        if (ArrayUtils.isEmpty(values2)) {
            return ArrayUtils.clone(array2);
        }
        if (index2 < 0 || index2 > array2.length) {
            throw new IndexOutOfBoundsException("Index: " + index2 + ", Length: " + array2.length);
        }
        double[] result2 = new double[array2.length + values2.length];
        System.arraycopy(values2, 0, result2, index2, values2.length);
        if (index2 > 0) {
            System.arraycopy(array2, 0, result2, 0, index2);
        }
        if (index2 < array2.length) {
            System.arraycopy(array2, index2, result2, index2 + values2.length, array2.length - index2);
        }
        return result2;
    }

    public static float[] insert(int index2, float[] array2, float ... values2) {
        if (array2 == null) {
            return null;
        }
        if (ArrayUtils.isEmpty(values2)) {
            return ArrayUtils.clone(array2);
        }
        if (index2 < 0 || index2 > array2.length) {
            throw new IndexOutOfBoundsException("Index: " + index2 + ", Length: " + array2.length);
        }
        float[] result2 = new float[array2.length + values2.length];
        System.arraycopy(values2, 0, result2, index2, values2.length);
        if (index2 > 0) {
            System.arraycopy(array2, 0, result2, 0, index2);
        }
        if (index2 < array2.length) {
            System.arraycopy(array2, index2, result2, index2 + values2.length, array2.length - index2);
        }
        return result2;
    }

    public static int[] insert(int index2, int[] array2, int ... values2) {
        if (array2 == null) {
            return null;
        }
        if (ArrayUtils.isEmpty(values2)) {
            return ArrayUtils.clone(array2);
        }
        if (index2 < 0 || index2 > array2.length) {
            throw new IndexOutOfBoundsException("Index: " + index2 + ", Length: " + array2.length);
        }
        int[] result2 = new int[array2.length + values2.length];
        System.arraycopy(values2, 0, result2, index2, values2.length);
        if (index2 > 0) {
            System.arraycopy(array2, 0, result2, 0, index2);
        }
        if (index2 < array2.length) {
            System.arraycopy(array2, index2, result2, index2 + values2.length, array2.length - index2);
        }
        return result2;
    }

    public static long[] insert(int index2, long[] array2, long ... values2) {
        if (array2 == null) {
            return null;
        }
        if (ArrayUtils.isEmpty(values2)) {
            return ArrayUtils.clone(array2);
        }
        if (index2 < 0 || index2 > array2.length) {
            throw new IndexOutOfBoundsException("Index: " + index2 + ", Length: " + array2.length);
        }
        long[] result2 = new long[array2.length + values2.length];
        System.arraycopy(values2, 0, result2, index2, values2.length);
        if (index2 > 0) {
            System.arraycopy(array2, 0, result2, 0, index2);
        }
        if (index2 < array2.length) {
            System.arraycopy(array2, index2, result2, index2 + values2.length, array2.length - index2);
        }
        return result2;
    }

    public static short[] insert(int index2, short[] array2, short ... values2) {
        if (array2 == null) {
            return null;
        }
        if (ArrayUtils.isEmpty(values2)) {
            return ArrayUtils.clone(array2);
        }
        if (index2 < 0 || index2 > array2.length) {
            throw new IndexOutOfBoundsException("Index: " + index2 + ", Length: " + array2.length);
        }
        short[] result2 = new short[array2.length + values2.length];
        System.arraycopy(values2, 0, result2, index2, values2.length);
        if (index2 > 0) {
            System.arraycopy(array2, 0, result2, 0, index2);
        }
        if (index2 < array2.length) {
            System.arraycopy(array2, index2, result2, index2 + values2.length, array2.length - index2);
        }
        return result2;
    }

    @SafeVarargs
    public static <T> T[] insert(int index2, T[] array2, T ... values2) {
        if (array2 == null) {
            return null;
        }
        if (ArrayUtils.isEmpty(values2)) {
            return ArrayUtils.clone(array2);
        }
        if (index2 < 0 || index2 > array2.length) {
            throw new IndexOutOfBoundsException("Index: " + index2 + ", Length: " + array2.length);
        }
        Class<?> type = array2.getClass().getComponentType();
        Object[] result2 = (Object[])Array.newInstance(type, array2.length + values2.length);
        System.arraycopy(values2, 0, result2, index2, values2.length);
        if (index2 > 0) {
            System.arraycopy(array2, 0, result2, 0, index2);
        }
        if (index2 < array2.length) {
            System.arraycopy(array2, index2, result2, index2 + values2.length, array2.length - index2);
        }
        return result2;
    }

    public static <T> boolean isArrayIndexValid(T[] array2, int index2) {
        if (ArrayUtils.getLength(array2) == 0 || array2.length <= index2) {
            return false;
        }
        return index2 >= 0;
    }

    public static boolean isEmpty(boolean[] array2) {
        return ArrayUtils.getLength(array2) == 0;
    }

    public static boolean isEmpty(byte[] array2) {
        return ArrayUtils.getLength(array2) == 0;
    }

    public static boolean isEmpty(char[] array2) {
        return ArrayUtils.getLength(array2) == 0;
    }

    public static boolean isEmpty(double[] array2) {
        return ArrayUtils.getLength(array2) == 0;
    }

    public static boolean isEmpty(float[] array2) {
        return ArrayUtils.getLength(array2) == 0;
    }

    public static boolean isEmpty(int[] array2) {
        return ArrayUtils.getLength(array2) == 0;
    }

    public static boolean isEmpty(long[] array2) {
        return ArrayUtils.getLength(array2) == 0;
    }

    public static boolean isEmpty(Object[] array2) {
        return ArrayUtils.getLength(array2) == 0;
    }

    public static boolean isEmpty(short[] array2) {
        return ArrayUtils.getLength(array2) == 0;
    }

    @Deprecated
    public static boolean isEquals(Object array1, Object array2) {
        return new EqualsBuilder().append(array1, array2).isEquals();
    }

    public static boolean isNotEmpty(boolean[] array2) {
        return !ArrayUtils.isEmpty(array2);
    }

    public static boolean isNotEmpty(byte[] array2) {
        return !ArrayUtils.isEmpty(array2);
    }

    public static boolean isNotEmpty(char[] array2) {
        return !ArrayUtils.isEmpty(array2);
    }

    public static boolean isNotEmpty(double[] array2) {
        return !ArrayUtils.isEmpty(array2);
    }

    public static boolean isNotEmpty(float[] array2) {
        return !ArrayUtils.isEmpty(array2);
    }

    public static boolean isNotEmpty(int[] array2) {
        return !ArrayUtils.isEmpty(array2);
    }

    public static boolean isNotEmpty(long[] array2) {
        return !ArrayUtils.isEmpty(array2);
    }

    public static boolean isNotEmpty(short[] array2) {
        return !ArrayUtils.isEmpty(array2);
    }

    public static <T> boolean isNotEmpty(T[] array2) {
        return !ArrayUtils.isEmpty(array2);
    }

    public static boolean isSameLength(boolean[] array1, boolean[] array2) {
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(array2);
    }

    public static boolean isSameLength(byte[] array1, byte[] array2) {
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(array2);
    }

    public static boolean isSameLength(char[] array1, char[] array2) {
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(array2);
    }

    public static boolean isSameLength(double[] array1, double[] array2) {
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(array2);
    }

    public static boolean isSameLength(float[] array1, float[] array2) {
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(array2);
    }

    public static boolean isSameLength(int[] array1, int[] array2) {
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(array2);
    }

    public static boolean isSameLength(long[] array1, long[] array2) {
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(array2);
    }

    public static boolean isSameLength(Object[] array1, Object[] array2) {
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(array2);
    }

    public static boolean isSameLength(short[] array1, short[] array2) {
        return ArrayUtils.getLength(array1) == ArrayUtils.getLength(array2);
    }

    public static boolean isSameType(Object array1, Object array2) {
        if (array1 == null || array2 == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        return array1.getClass().getName().equals(array2.getClass().getName());
    }

    public static boolean isSorted(boolean[] array2) {
        if (array2 == null || array2.length < 2) {
            return true;
        }
        boolean previous = array2[0];
        int n = array2.length;
        for (int i = 1; i < n; ++i) {
            boolean current = array2[i];
            if (BooleanUtils.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static boolean isSorted(byte[] array2) {
        if (array2 == null || array2.length < 2) {
            return true;
        }
        byte previous = array2[0];
        int n = array2.length;
        for (int i = 1; i < n; ++i) {
            byte current = array2[i];
            if (NumberUtils.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static boolean isSorted(char[] array2) {
        if (array2 == null || array2.length < 2) {
            return true;
        }
        char previous = array2[0];
        int n = array2.length;
        for (int i = 1; i < n; ++i) {
            char current = array2[i];
            if (CharUtils.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static boolean isSorted(double[] array2) {
        if (array2 == null || array2.length < 2) {
            return true;
        }
        double previous = array2[0];
        int n = array2.length;
        for (int i = 1; i < n; ++i) {
            double current = array2[i];
            if (Double.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static boolean isSorted(float[] array2) {
        if (array2 == null || array2.length < 2) {
            return true;
        }
        float previous = array2[0];
        int n = array2.length;
        for (int i = 1; i < n; ++i) {
            float current = array2[i];
            if (Float.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static boolean isSorted(int[] array2) {
        if (array2 == null || array2.length < 2) {
            return true;
        }
        int previous = array2[0];
        int n = array2.length;
        for (int i = 1; i < n; ++i) {
            int current = array2[i];
            if (NumberUtils.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static boolean isSorted(long[] array2) {
        if (array2 == null || array2.length < 2) {
            return true;
        }
        long previous = array2[0];
        int n = array2.length;
        for (int i = 1; i < n; ++i) {
            long current = array2[i];
            if (NumberUtils.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static boolean isSorted(short[] array2) {
        if (array2 == null || array2.length < 2) {
            return true;
        }
        short previous = array2[0];
        int n = array2.length;
        for (int i = 1; i < n; ++i) {
            short current = array2[i];
            if (NumberUtils.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static <T extends Comparable<? super T>> boolean isSorted(T[] array2) {
        return ArrayUtils.isSorted(array2, (o1, o2) -> o1.compareTo(o2));
    }

    public static <T> boolean isSorted(T[] array2, Comparator<T> comparator) {
        if (comparator == null) {
            throw new IllegalArgumentException("Comparator should not be null.");
        }
        if (array2 == null || array2.length < 2) {
            return true;
        }
        T previous = array2[0];
        int n = array2.length;
        for (int i = 1; i < n; ++i) {
            T current = array2[i];
            if (comparator.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static int lastIndexOf(boolean[] array2, boolean valueToFind) {
        return ArrayUtils.lastIndexOf(array2, valueToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(boolean[] array2, boolean valueToFind, int startIndex) {
        if (ArrayUtils.isEmpty(array2)) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array2.length) {
            startIndex = array2.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (valueToFind != array2[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(byte[] array2, byte valueToFind) {
        return ArrayUtils.lastIndexOf(array2, valueToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(byte[] array2, byte valueToFind, int startIndex) {
        if (array2 == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array2.length) {
            startIndex = array2.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (valueToFind != array2[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(char[] array2, char valueToFind) {
        return ArrayUtils.lastIndexOf(array2, valueToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(char[] array2, char valueToFind, int startIndex) {
        if (array2 == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array2.length) {
            startIndex = array2.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (valueToFind != array2[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(double[] array2, double valueToFind) {
        return ArrayUtils.lastIndexOf(array2, valueToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(double[] array2, double valueToFind, double tolerance) {
        return ArrayUtils.lastIndexOf(array2, valueToFind, Integer.MAX_VALUE, tolerance);
    }

    public static int lastIndexOf(double[] array2, double valueToFind, int startIndex) {
        if (ArrayUtils.isEmpty(array2)) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array2.length) {
            startIndex = array2.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (valueToFind != array2[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(double[] array2, double valueToFind, int startIndex, double tolerance) {
        if (ArrayUtils.isEmpty(array2)) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array2.length) {
            startIndex = array2.length - 1;
        }
        double min2 = valueToFind - tolerance;
        double max2 = valueToFind + tolerance;
        for (int i = startIndex; i >= 0; --i) {
            if (!(array2[i] >= min2) || !(array2[i] <= max2)) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(float[] array2, float valueToFind) {
        return ArrayUtils.lastIndexOf(array2, valueToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(float[] array2, float valueToFind, int startIndex) {
        if (ArrayUtils.isEmpty(array2)) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array2.length) {
            startIndex = array2.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (valueToFind != array2[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(int[] array2, int valueToFind) {
        return ArrayUtils.lastIndexOf(array2, valueToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(int[] array2, int valueToFind, int startIndex) {
        if (array2 == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array2.length) {
            startIndex = array2.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (valueToFind != array2[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(long[] array2, long valueToFind) {
        return ArrayUtils.lastIndexOf(array2, valueToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(long[] array2, long valueToFind, int startIndex) {
        if (array2 == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array2.length) {
            startIndex = array2.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (valueToFind != array2[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(Object[] array2, Object objectToFind) {
        return ArrayUtils.lastIndexOf(array2, objectToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(Object[] array2, Object objectToFind, int startIndex) {
        block6: {
            block5: {
                if (array2 == null) {
                    return -1;
                }
                if (startIndex < 0) {
                    return -1;
                }
                if (startIndex >= array2.length) {
                    startIndex = array2.length - 1;
                }
                if (objectToFind != null) break block5;
                for (int i = startIndex; i >= 0; --i) {
                    if (array2[i] != null) continue;
                    return i;
                }
                break block6;
            }
            if (!array2.getClass().getComponentType().isInstance(objectToFind)) break block6;
            for (int i = startIndex; i >= 0; --i) {
                if (!objectToFind.equals(array2[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(short[] array2, short valueToFind) {
        return ArrayUtils.lastIndexOf(array2, valueToFind, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(short[] array2, short valueToFind, int startIndex) {
        if (array2 == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array2.length) {
            startIndex = array2.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (valueToFind != array2[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean[] nullToEmpty(boolean[] array2) {
        if (ArrayUtils.isEmpty(array2)) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        return array2;
    }

    public static Boolean[] nullToEmpty(Boolean[] array2) {
        if (ArrayUtils.isEmpty((Object[])array2)) {
            return EMPTY_BOOLEAN_OBJECT_ARRAY;
        }
        return array2;
    }

    public static byte[] nullToEmpty(byte[] array2) {
        if (ArrayUtils.isEmpty(array2)) {
            return EMPTY_BYTE_ARRAY;
        }
        return array2;
    }

    public static Byte[] nullToEmpty(Byte[] array2) {
        if (ArrayUtils.isEmpty((Object[])array2)) {
            return EMPTY_BYTE_OBJECT_ARRAY;
        }
        return array2;
    }

    public static char[] nullToEmpty(char[] array2) {
        if (ArrayUtils.isEmpty(array2)) {
            return EMPTY_CHAR_ARRAY;
        }
        return array2;
    }

    public static Character[] nullToEmpty(Character[] array2) {
        if (ArrayUtils.isEmpty((Object[])array2)) {
            return EMPTY_CHARACTER_OBJECT_ARRAY;
        }
        return array2;
    }

    public static Class<?>[] nullToEmpty(Class<?>[] array2) {
        if (ArrayUtils.isEmpty(array2)) {
            return EMPTY_CLASS_ARRAY;
        }
        return array2;
    }

    public static double[] nullToEmpty(double[] array2) {
        if (ArrayUtils.isEmpty(array2)) {
            return EMPTY_DOUBLE_ARRAY;
        }
        return array2;
    }

    public static Double[] nullToEmpty(Double[] array2) {
        if (ArrayUtils.isEmpty((Object[])array2)) {
            return EMPTY_DOUBLE_OBJECT_ARRAY;
        }
        return array2;
    }

    public static float[] nullToEmpty(float[] array2) {
        if (ArrayUtils.isEmpty(array2)) {
            return EMPTY_FLOAT_ARRAY;
        }
        return array2;
    }

    public static Float[] nullToEmpty(Float[] array2) {
        if (ArrayUtils.isEmpty((Object[])array2)) {
            return EMPTY_FLOAT_OBJECT_ARRAY;
        }
        return array2;
    }

    public static int[] nullToEmpty(int[] array2) {
        if (ArrayUtils.isEmpty(array2)) {
            return EMPTY_INT_ARRAY;
        }
        return array2;
    }

    public static Integer[] nullToEmpty(Integer[] array2) {
        if (ArrayUtils.isEmpty((Object[])array2)) {
            return EMPTY_INTEGER_OBJECT_ARRAY;
        }
        return array2;
    }

    public static long[] nullToEmpty(long[] array2) {
        if (ArrayUtils.isEmpty(array2)) {
            return EMPTY_LONG_ARRAY;
        }
        return array2;
    }

    public static Long[] nullToEmpty(Long[] array2) {
        if (ArrayUtils.isEmpty((Object[])array2)) {
            return EMPTY_LONG_OBJECT_ARRAY;
        }
        return array2;
    }

    public static Object[] nullToEmpty(Object[] array2) {
        if (ArrayUtils.isEmpty(array2)) {
            return EMPTY_OBJECT_ARRAY;
        }
        return array2;
    }

    public static short[] nullToEmpty(short[] array2) {
        if (ArrayUtils.isEmpty(array2)) {
            return EMPTY_SHORT_ARRAY;
        }
        return array2;
    }

    public static Short[] nullToEmpty(Short[] array2) {
        if (ArrayUtils.isEmpty((Object[])array2)) {
            return EMPTY_SHORT_OBJECT_ARRAY;
        }
        return array2;
    }

    public static String[] nullToEmpty(String[] array2) {
        if (ArrayUtils.isEmpty(array2)) {
            return EMPTY_STRING_ARRAY;
        }
        return array2;
    }

    public static <T> T[] nullToEmpty(T[] array2, Class<T[]> type) {
        if (type == null) {
            throw new IllegalArgumentException("The type must not be null");
        }
        if (array2 == null) {
            return type.cast(Array.newInstance(type.getComponentType(), 0));
        }
        return array2;
    }

    public static boolean[] remove(boolean[] array2, int index2) {
        return (boolean[])ArrayUtils.remove((Object)array2, index2);
    }

    public static byte[] remove(byte[] array2, int index2) {
        return (byte[])ArrayUtils.remove((Object)array2, index2);
    }

    public static char[] remove(char[] array2, int index2) {
        return (char[])ArrayUtils.remove((Object)array2, index2);
    }

    public static double[] remove(double[] array2, int index2) {
        return (double[])ArrayUtils.remove((Object)array2, index2);
    }

    public static float[] remove(float[] array2, int index2) {
        return (float[])ArrayUtils.remove((Object)array2, index2);
    }

    public static int[] remove(int[] array2, int index2) {
        return (int[])ArrayUtils.remove((Object)array2, index2);
    }

    public static long[] remove(long[] array2, int index2) {
        return (long[])ArrayUtils.remove((Object)array2, index2);
    }

    private static Object remove(Object array2, int index2) {
        int length = ArrayUtils.getLength(array2);
        if (index2 < 0 || index2 >= length) {
            throw new IndexOutOfBoundsException("Index: " + index2 + ", Length: " + length);
        }
        Object result2 = Array.newInstance(array2.getClass().getComponentType(), length - 1);
        System.arraycopy(array2, 0, result2, 0, index2);
        if (index2 < length - 1) {
            System.arraycopy(array2, index2 + 1, result2, index2, length - index2 - 1);
        }
        return result2;
    }

    public static short[] remove(short[] array2, int index2) {
        return (short[])ArrayUtils.remove((Object)array2, index2);
    }

    public static <T> T[] remove(T[] array2, int index2) {
        return (Object[])ArrayUtils.remove(array2, index2);
    }

    public static boolean[] removeAll(boolean[] array2, int ... indices) {
        return (boolean[])ArrayUtils.removeAll((Object)array2, indices);
    }

    public static byte[] removeAll(byte[] array2, int ... indices) {
        return (byte[])ArrayUtils.removeAll((Object)array2, indices);
    }

    public static char[] removeAll(char[] array2, int ... indices) {
        return (char[])ArrayUtils.removeAll((Object)array2, indices);
    }

    public static double[] removeAll(double[] array2, int ... indices) {
        return (double[])ArrayUtils.removeAll((Object)array2, indices);
    }

    public static float[] removeAll(float[] array2, int ... indices) {
        return (float[])ArrayUtils.removeAll((Object)array2, indices);
    }

    public static int[] removeAll(int[] array2, int ... indices) {
        return (int[])ArrayUtils.removeAll((Object)array2, indices);
    }

    public static long[] removeAll(long[] array2, int ... indices) {
        return (long[])ArrayUtils.removeAll((Object)array2, indices);
    }

    static Object removeAll(Object array2, BitSet indices) {
        int count2;
        int set2;
        if (array2 == null) {
            return null;
        }
        int srcLength = ArrayUtils.getLength(array2);
        int removals = indices.cardinality();
        Object result2 = Array.newInstance(array2.getClass().getComponentType(), srcLength - removals);
        int srcIndex = 0;
        int destIndex = 0;
        while ((set2 = indices.nextSetBit(srcIndex)) != -1) {
            count2 = set2 - srcIndex;
            if (count2 > 0) {
                System.arraycopy(array2, srcIndex, result2, destIndex, count2);
                destIndex += count2;
            }
            srcIndex = indices.nextClearBit(set2);
        }
        count2 = srcLength - srcIndex;
        if (count2 > 0) {
            System.arraycopy(array2, srcIndex, result2, destIndex, count2);
        }
        return result2;
    }

    static Object removeAll(Object array2, int ... indices) {
        int length = ArrayUtils.getLength(array2);
        int diff2 = 0;
        int[] clonedIndices = ArrayUtils.clone(indices);
        Arrays.sort(clonedIndices);
        if (ArrayUtils.isNotEmpty(clonedIndices)) {
            int i = clonedIndices.length;
            int prevIndex = length;
            while (--i >= 0) {
                int index2 = clonedIndices[i];
                if (index2 < 0 || index2 >= length) {
                    throw new IndexOutOfBoundsException("Index: " + index2 + ", Length: " + length);
                }
                if (index2 >= prevIndex) continue;
                ++diff2;
                prevIndex = index2;
            }
        }
        Object result2 = Array.newInstance(array2.getClass().getComponentType(), length - diff2);
        if (diff2 < length) {
            int end = length;
            int dest = length - diff2;
            for (int i = clonedIndices.length - 1; i >= 0; --i) {
                int index3 = clonedIndices[i];
                if (end - index3 > 1) {
                    int cp = end - index3 - 1;
                    System.arraycopy(array2, index3 + 1, result2, dest -= cp, cp);
                }
                end = index3;
            }
            if (end > 0) {
                System.arraycopy(array2, 0, result2, 0, end);
            }
        }
        return result2;
    }

    public static short[] removeAll(short[] array2, int ... indices) {
        return (short[])ArrayUtils.removeAll((Object)array2, indices);
    }

    public static <T> T[] removeAll(T[] array2, int ... indices) {
        return (Object[])ArrayUtils.removeAll(array2, indices);
    }

    public static boolean[] removeAllOccurences(boolean[] array2, boolean element) {
        return (boolean[])ArrayUtils.removeAll((Object)array2, ArrayUtils.indexesOf(array2, element));
    }

    public static byte[] removeAllOccurences(byte[] array2, byte element) {
        return (byte[])ArrayUtils.removeAll((Object)array2, ArrayUtils.indexesOf(array2, element));
    }

    public static char[] removeAllOccurences(char[] array2, char element) {
        return (char[])ArrayUtils.removeAll((Object)array2, ArrayUtils.indexesOf(array2, element));
    }

    public static double[] removeAllOccurences(double[] array2, double element) {
        return (double[])ArrayUtils.removeAll((Object)array2, ArrayUtils.indexesOf(array2, element));
    }

    public static float[] removeAllOccurences(float[] array2, float element) {
        return (float[])ArrayUtils.removeAll((Object)array2, ArrayUtils.indexesOf(array2, element));
    }

    public static int[] removeAllOccurences(int[] array2, int element) {
        return (int[])ArrayUtils.removeAll((Object)array2, ArrayUtils.indexesOf(array2, element));
    }

    public static long[] removeAllOccurences(long[] array2, long element) {
        return (long[])ArrayUtils.removeAll((Object)array2, ArrayUtils.indexesOf(array2, element));
    }

    public static short[] removeAllOccurences(short[] array2, short element) {
        return (short[])ArrayUtils.removeAll((Object)array2, ArrayUtils.indexesOf(array2, element));
    }

    public static <T> T[] removeAllOccurences(T[] array2, T element) {
        return (Object[])ArrayUtils.removeAll(array2, ArrayUtils.indexesOf(array2, element));
    }

    public static boolean[] removeAllOccurrences(boolean[] array2, boolean element) {
        return (boolean[])ArrayUtils.removeAll((Object)array2, ArrayUtils.indexesOf(array2, element));
    }

    public static byte[] removeAllOccurrences(byte[] array2, byte element) {
        return (byte[])ArrayUtils.removeAll((Object)array2, ArrayUtils.indexesOf(array2, element));
    }

    public static char[] removeAllOccurrences(char[] array2, char element) {
        return (char[])ArrayUtils.removeAll((Object)array2, ArrayUtils.indexesOf(array2, element));
    }

    public static double[] removeAllOccurrences(double[] array2, double element) {
        return (double[])ArrayUtils.removeAll((Object)array2, ArrayUtils.indexesOf(array2, element));
    }

    public static float[] removeAllOccurrences(float[] array2, float element) {
        return (float[])ArrayUtils.removeAll((Object)array2, ArrayUtils.indexesOf(array2, element));
    }

    public static int[] removeAllOccurrences(int[] array2, int element) {
        return (int[])ArrayUtils.removeAll((Object)array2, ArrayUtils.indexesOf(array2, element));
    }

    public static long[] removeAllOccurrences(long[] array2, long element) {
        return (long[])ArrayUtils.removeAll((Object)array2, ArrayUtils.indexesOf(array2, element));
    }

    public static short[] removeAllOccurrences(short[] array2, short element) {
        return (short[])ArrayUtils.removeAll((Object)array2, ArrayUtils.indexesOf(array2, element));
    }

    public static <T> T[] removeAllOccurrences(T[] array2, T element) {
        return (Object[])ArrayUtils.removeAll(array2, ArrayUtils.indexesOf(array2, element));
    }

    public static boolean[] removeElement(boolean[] array2, boolean element) {
        int index2 = ArrayUtils.indexOf(array2, element);
        if (index2 == -1) {
            return ArrayUtils.clone(array2);
        }
        return ArrayUtils.remove(array2, index2);
    }

    public static byte[] removeElement(byte[] array2, byte element) {
        int index2 = ArrayUtils.indexOf(array2, element);
        if (index2 == -1) {
            return ArrayUtils.clone(array2);
        }
        return ArrayUtils.remove(array2, index2);
    }

    public static char[] removeElement(char[] array2, char element) {
        int index2 = ArrayUtils.indexOf(array2, element);
        if (index2 == -1) {
            return ArrayUtils.clone(array2);
        }
        return ArrayUtils.remove(array2, index2);
    }

    public static double[] removeElement(double[] array2, double element) {
        int index2 = ArrayUtils.indexOf(array2, element);
        if (index2 == -1) {
            return ArrayUtils.clone(array2);
        }
        return ArrayUtils.remove(array2, index2);
    }

    public static float[] removeElement(float[] array2, float element) {
        int index2 = ArrayUtils.indexOf(array2, element);
        if (index2 == -1) {
            return ArrayUtils.clone(array2);
        }
        return ArrayUtils.remove(array2, index2);
    }

    public static int[] removeElement(int[] array2, int element) {
        int index2 = ArrayUtils.indexOf(array2, element);
        if (index2 == -1) {
            return ArrayUtils.clone(array2);
        }
        return ArrayUtils.remove(array2, index2);
    }

    public static long[] removeElement(long[] array2, long element) {
        int index2 = ArrayUtils.indexOf(array2, element);
        if (index2 == -1) {
            return ArrayUtils.clone(array2);
        }
        return ArrayUtils.remove(array2, index2);
    }

    public static short[] removeElement(short[] array2, short element) {
        int index2 = ArrayUtils.indexOf(array2, element);
        if (index2 == -1) {
            return ArrayUtils.clone(array2);
        }
        return ArrayUtils.remove(array2, index2);
    }

    public static <T> T[] removeElement(T[] array2, Object element) {
        int index2 = ArrayUtils.indexOf(array2, element);
        if (index2 == -1) {
            return ArrayUtils.clone(array2);
        }
        return ArrayUtils.remove(array2, index2);
    }

    public static boolean[] removeElements(boolean[] array2, boolean ... values2) {
        if (ArrayUtils.isEmpty(array2) || ArrayUtils.isEmpty(values2)) {
            return ArrayUtils.clone(array2);
        }
        HashMap<Boolean, MutableInt> occurrences = new HashMap<Boolean, MutableInt>(2);
        for (boolean v : values2) {
            Boolean boxed = v;
            MutableInt count2 = (MutableInt)occurrences.get(boxed);
            if (count2 == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count2.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i = 0; i < array2.length; ++i) {
            boolean key = array2[i];
            MutableInt count3 = (MutableInt)occurrences.get(key);
            if (count3 == null) continue;
            if (count3.decrementAndGet() == 0) {
                occurrences.remove(key);
            }
            toRemove.set(i);
        }
        return (boolean[])ArrayUtils.removeAll((Object)array2, toRemove);
    }

    public static byte[] removeElements(byte[] array2, byte ... values2) {
        if (ArrayUtils.isEmpty(array2) || ArrayUtils.isEmpty(values2)) {
            return ArrayUtils.clone(array2);
        }
        HashMap<Byte, MutableInt> occurrences = new HashMap<Byte, MutableInt>(values2.length);
        for (byte v : values2) {
            Byte boxed = v;
            MutableInt count2 = (MutableInt)occurrences.get(boxed);
            if (count2 == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count2.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i = 0; i < array2.length; ++i) {
            byte key = array2[i];
            MutableInt count3 = (MutableInt)occurrences.get(key);
            if (count3 == null) continue;
            if (count3.decrementAndGet() == 0) {
                occurrences.remove(key);
            }
            toRemove.set(i);
        }
        return (byte[])ArrayUtils.removeAll((Object)array2, toRemove);
    }

    public static char[] removeElements(char[] array2, char ... values2) {
        if (ArrayUtils.isEmpty(array2) || ArrayUtils.isEmpty(values2)) {
            return ArrayUtils.clone(array2);
        }
        HashMap<Character, MutableInt> occurrences = new HashMap<Character, MutableInt>(values2.length);
        for (char v : values2) {
            Character boxed = Character.valueOf(v);
            MutableInt count2 = (MutableInt)occurrences.get(boxed);
            if (count2 == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count2.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i = 0; i < array2.length; ++i) {
            char key = array2[i];
            MutableInt count3 = (MutableInt)occurrences.get(Character.valueOf(key));
            if (count3 == null) continue;
            if (count3.decrementAndGet() == 0) {
                occurrences.remove(Character.valueOf(key));
            }
            toRemove.set(i);
        }
        return (char[])ArrayUtils.removeAll((Object)array2, toRemove);
    }

    public static double[] removeElements(double[] array2, double ... values2) {
        if (ArrayUtils.isEmpty(array2) || ArrayUtils.isEmpty(values2)) {
            return ArrayUtils.clone(array2);
        }
        HashMap<Double, MutableInt> occurrences = new HashMap<Double, MutableInt>(values2.length);
        for (double v : values2) {
            Double boxed = v;
            MutableInt count2 = (MutableInt)occurrences.get(boxed);
            if (count2 == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count2.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i = 0; i < array2.length; ++i) {
            double key = array2[i];
            MutableInt count3 = (MutableInt)occurrences.get(key);
            if (count3 == null) continue;
            if (count3.decrementAndGet() == 0) {
                occurrences.remove(key);
            }
            toRemove.set(i);
        }
        return (double[])ArrayUtils.removeAll((Object)array2, toRemove);
    }

    public static float[] removeElements(float[] array2, float ... values2) {
        if (ArrayUtils.isEmpty(array2) || ArrayUtils.isEmpty(values2)) {
            return ArrayUtils.clone(array2);
        }
        HashMap<Float, MutableInt> occurrences = new HashMap<Float, MutableInt>(values2.length);
        for (float v : values2) {
            Float boxed = Float.valueOf(v);
            MutableInt count2 = (MutableInt)occurrences.get(boxed);
            if (count2 == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count2.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i = 0; i < array2.length; ++i) {
            float key = array2[i];
            MutableInt count3 = (MutableInt)occurrences.get(Float.valueOf(key));
            if (count3 == null) continue;
            if (count3.decrementAndGet() == 0) {
                occurrences.remove(Float.valueOf(key));
            }
            toRemove.set(i);
        }
        return (float[])ArrayUtils.removeAll((Object)array2, toRemove);
    }

    public static int[] removeElements(int[] array2, int ... values2) {
        if (ArrayUtils.isEmpty(array2) || ArrayUtils.isEmpty(values2)) {
            return ArrayUtils.clone(array2);
        }
        HashMap<Integer, MutableInt> occurrences = new HashMap<Integer, MutableInt>(values2.length);
        for (int v : values2) {
            Integer boxed = v;
            MutableInt count2 = (MutableInt)occurrences.get(boxed);
            if (count2 == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count2.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i = 0; i < array2.length; ++i) {
            int key = array2[i];
            MutableInt count3 = (MutableInt)occurrences.get(key);
            if (count3 == null) continue;
            if (count3.decrementAndGet() == 0) {
                occurrences.remove(key);
            }
            toRemove.set(i);
        }
        return (int[])ArrayUtils.removeAll((Object)array2, toRemove);
    }

    public static long[] removeElements(long[] array2, long ... values2) {
        if (ArrayUtils.isEmpty(array2) || ArrayUtils.isEmpty(values2)) {
            return ArrayUtils.clone(array2);
        }
        HashMap<Long, MutableInt> occurrences = new HashMap<Long, MutableInt>(values2.length);
        for (long v : values2) {
            Long boxed = v;
            MutableInt count2 = (MutableInt)occurrences.get(boxed);
            if (count2 == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count2.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i = 0; i < array2.length; ++i) {
            long key = array2[i];
            MutableInt count3 = (MutableInt)occurrences.get(key);
            if (count3 == null) continue;
            if (count3.decrementAndGet() == 0) {
                occurrences.remove(key);
            }
            toRemove.set(i);
        }
        return (long[])ArrayUtils.removeAll((Object)array2, toRemove);
    }

    public static short[] removeElements(short[] array2, short ... values2) {
        if (ArrayUtils.isEmpty(array2) || ArrayUtils.isEmpty(values2)) {
            return ArrayUtils.clone(array2);
        }
        HashMap<Short, MutableInt> occurrences = new HashMap<Short, MutableInt>(values2.length);
        for (short v : values2) {
            Short boxed = v;
            MutableInt count2 = (MutableInt)occurrences.get(boxed);
            if (count2 == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count2.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i = 0; i < array2.length; ++i) {
            short key = array2[i];
            MutableInt count3 = (MutableInt)occurrences.get(key);
            if (count3 == null) continue;
            if (count3.decrementAndGet() == 0) {
                occurrences.remove(key);
            }
            toRemove.set(i);
        }
        return (short[])ArrayUtils.removeAll((Object)array2, toRemove);
    }

    @SafeVarargs
    public static <T> T[] removeElements(T[] array2, T ... values2) {
        if (ArrayUtils.isEmpty(array2) || ArrayUtils.isEmpty(values2)) {
            return ArrayUtils.clone(array2);
        }
        HashMap<T, MutableInt> occurrences = new HashMap<T, MutableInt>(values2.length);
        for (T v : values2) {
            MutableInt count2 = (MutableInt)occurrences.get(v);
            if (count2 == null) {
                occurrences.put(v, new MutableInt(1));
                continue;
            }
            count2.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i = 0; i < array2.length; ++i) {
            T key = array2[i];
            MutableInt count3 = (MutableInt)occurrences.get(key);
            if (count3 == null) continue;
            if (count3.decrementAndGet() == 0) {
                occurrences.remove(key);
            }
            toRemove.set(i);
        }
        Object[] result2 = (Object[])ArrayUtils.removeAll(array2, toRemove);
        return result2;
    }

    public static void reverse(boolean[] array2) {
        if (array2 == null) {
            return;
        }
        ArrayUtils.reverse(array2, 0, array2.length);
    }

    public static void reverse(boolean[] array2, int startIndexInclusive, int endIndexExclusive) {
        if (array2 == null) {
            return;
        }
        int i = startIndexInclusive < 0 ? 0 : startIndexInclusive;
        for (int j = Math.min(array2.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            boolean tmp = array2[j];
            array2[j] = array2[i];
            array2[i] = tmp;
        }
    }

    public static void reverse(byte[] array2) {
        if (array2 == null) {
            return;
        }
        ArrayUtils.reverse(array2, 0, array2.length);
    }

    public static void reverse(byte[] array2, int startIndexInclusive, int endIndexExclusive) {
        if (array2 == null) {
            return;
        }
        int i = startIndexInclusive < 0 ? 0 : startIndexInclusive;
        for (int j = Math.min(array2.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            byte tmp = array2[j];
            array2[j] = array2[i];
            array2[i] = tmp;
        }
    }

    public static void reverse(char[] array2) {
        if (array2 == null) {
            return;
        }
        ArrayUtils.reverse(array2, 0, array2.length);
    }

    public static void reverse(char[] array2, int startIndexInclusive, int endIndexExclusive) {
        if (array2 == null) {
            return;
        }
        int i = startIndexInclusive < 0 ? 0 : startIndexInclusive;
        for (int j = Math.min(array2.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            char tmp = array2[j];
            array2[j] = array2[i];
            array2[i] = tmp;
        }
    }

    public static void reverse(double[] array2) {
        if (array2 == null) {
            return;
        }
        ArrayUtils.reverse(array2, 0, array2.length);
    }

    public static void reverse(double[] array2, int startIndexInclusive, int endIndexExclusive) {
        if (array2 == null) {
            return;
        }
        int i = startIndexInclusive < 0 ? 0 : startIndexInclusive;
        for (int j = Math.min(array2.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            double tmp = array2[j];
            array2[j] = array2[i];
            array2[i] = tmp;
        }
    }

    public static void reverse(float[] array2) {
        if (array2 == null) {
            return;
        }
        ArrayUtils.reverse(array2, 0, array2.length);
    }

    public static void reverse(float[] array2, int startIndexInclusive, int endIndexExclusive) {
        if (array2 == null) {
            return;
        }
        int i = startIndexInclusive < 0 ? 0 : startIndexInclusive;
        for (int j = Math.min(array2.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            float tmp = array2[j];
            array2[j] = array2[i];
            array2[i] = tmp;
        }
    }

    public static void reverse(int[] array2) {
        if (array2 == null) {
            return;
        }
        ArrayUtils.reverse(array2, 0, array2.length);
    }

    public static void reverse(int[] array2, int startIndexInclusive, int endIndexExclusive) {
        if (array2 == null) {
            return;
        }
        int i = startIndexInclusive < 0 ? 0 : startIndexInclusive;
        for (int j = Math.min(array2.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            int tmp = array2[j];
            array2[j] = array2[i];
            array2[i] = tmp;
        }
    }

    public static void reverse(long[] array2) {
        if (array2 == null) {
            return;
        }
        ArrayUtils.reverse(array2, 0, array2.length);
    }

    public static void reverse(long[] array2, int startIndexInclusive, int endIndexExclusive) {
        if (array2 == null) {
            return;
        }
        int i = startIndexInclusive < 0 ? 0 : startIndexInclusive;
        for (int j = Math.min(array2.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            long tmp = array2[j];
            array2[j] = array2[i];
            array2[i] = tmp;
        }
    }

    public static void reverse(Object[] array2) {
        if (array2 == null) {
            return;
        }
        ArrayUtils.reverse(array2, 0, array2.length);
    }

    public static void reverse(Object[] array2, int startIndexInclusive, int endIndexExclusive) {
        if (array2 == null) {
            return;
        }
        int i = startIndexInclusive < 0 ? 0 : startIndexInclusive;
        for (int j = Math.min(array2.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            Object tmp = array2[j];
            array2[j] = array2[i];
            array2[i] = tmp;
        }
    }

    public static void reverse(short[] array2) {
        if (array2 == null) {
            return;
        }
        ArrayUtils.reverse(array2, 0, array2.length);
    }

    public static void reverse(short[] array2, int startIndexInclusive, int endIndexExclusive) {
        if (array2 == null) {
            return;
        }
        int i = startIndexInclusive < 0 ? 0 : startIndexInclusive;
        for (int j = Math.min(array2.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            short tmp = array2[j];
            array2[j] = array2[i];
            array2[i] = tmp;
        }
    }

    public static void shift(boolean[] array2, int offset) {
        if (array2 == null) {
            return;
        }
        ArrayUtils.shift(array2, 0, array2.length, offset);
    }

    public static void shift(boolean[] array2, int startIndexInclusive, int endIndexExclusive, int offset) {
        int n;
        if (array2 == null) {
            return;
        }
        if (startIndexInclusive >= array2.length - 1 || endIndexExclusive <= 0) {
            return;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive >= array2.length) {
            endIndexExclusive = array2.length;
        }
        if ((n = endIndexExclusive - startIndexInclusive) <= 1) {
            return;
        }
        if ((offset %= n) < 0) {
            offset += n;
        }
        while (n > 1 && offset > 0) {
            int n_offset = n - offset;
            if (offset > n_offset) {
                ArrayUtils.swap(array2, startIndexInclusive, startIndexInclusive + n - n_offset, n_offset);
                n = offset;
                offset -= n_offset;
                continue;
            }
            if (offset < n_offset) {
                ArrayUtils.swap(array2, startIndexInclusive, startIndexInclusive + n_offset, offset);
                startIndexInclusive += offset;
                n = n_offset;
                continue;
            }
            ArrayUtils.swap(array2, startIndexInclusive, startIndexInclusive + n_offset, offset);
            break;
        }
    }

    public static void shift(byte[] array2, int offset) {
        if (array2 == null) {
            return;
        }
        ArrayUtils.shift(array2, 0, array2.length, offset);
    }

    public static void shift(byte[] array2, int startIndexInclusive, int endIndexExclusive, int offset) {
        int n;
        if (array2 == null) {
            return;
        }
        if (startIndexInclusive >= array2.length - 1 || endIndexExclusive <= 0) {
            return;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive >= array2.length) {
            endIndexExclusive = array2.length;
        }
        if ((n = endIndexExclusive - startIndexInclusive) <= 1) {
            return;
        }
        if ((offset %= n) < 0) {
            offset += n;
        }
        while (n > 1 && offset > 0) {
            int n_offset = n - offset;
            if (offset > n_offset) {
                ArrayUtils.swap(array2, startIndexInclusive, startIndexInclusive + n - n_offset, n_offset);
                n = offset;
                offset -= n_offset;
                continue;
            }
            if (offset < n_offset) {
                ArrayUtils.swap(array2, startIndexInclusive, startIndexInclusive + n_offset, offset);
                startIndexInclusive += offset;
                n = n_offset;
                continue;
            }
            ArrayUtils.swap(array2, startIndexInclusive, startIndexInclusive + n_offset, offset);
            break;
        }
    }

    public static void shift(char[] array2, int offset) {
        if (array2 == null) {
            return;
        }
        ArrayUtils.shift(array2, 0, array2.length, offset);
    }

    public static void shift(char[] array2, int startIndexInclusive, int endIndexExclusive, int offset) {
        int n;
        if (array2 == null) {
            return;
        }
        if (startIndexInclusive >= array2.length - 1 || endIndexExclusive <= 0) {
            return;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive >= array2.length) {
            endIndexExclusive = array2.length;
        }
        if ((n = endIndexExclusive - startIndexInclusive) <= 1) {
            return;
        }
        if ((offset %= n) < 0) {
            offset += n;
        }
        while (n > 1 && offset > 0) {
            int n_offset = n - offset;
            if (offset > n_offset) {
                ArrayUtils.swap(array2, startIndexInclusive, startIndexInclusive + n - n_offset, n_offset);
                n = offset;
                offset -= n_offset;
                continue;
            }
            if (offset < n_offset) {
                ArrayUtils.swap(array2, startIndexInclusive, startIndexInclusive + n_offset, offset);
                startIndexInclusive += offset;
                n = n_offset;
                continue;
            }
            ArrayUtils.swap(array2, startIndexInclusive, startIndexInclusive + n_offset, offset);
            break;
        }
    }

    public static void shift(double[] array2, int offset) {
        if (array2 == null) {
            return;
        }
        ArrayUtils.shift(array2, 0, array2.length, offset);
    }

    public static void shift(double[] array2, int startIndexInclusive, int endIndexExclusive, int offset) {
        int n;
        if (array2 == null) {
            return;
        }
        if (startIndexInclusive >= array2.length - 1 || endIndexExclusive <= 0) {
            return;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive >= array2.length) {
            endIndexExclusive = array2.length;
        }
        if ((n = endIndexExclusive - startIndexInclusive) <= 1) {
            return;
        }
        if ((offset %= n) < 0) {
            offset += n;
        }
        while (n > 1 && offset > 0) {
            int n_offset = n - offset;
            if (offset > n_offset) {
                ArrayUtils.swap(array2, startIndexInclusive, startIndexInclusive + n - n_offset, n_offset);
                n = offset;
                offset -= n_offset;
                continue;
            }
            if (offset < n_offset) {
                ArrayUtils.swap(array2, startIndexInclusive, startIndexInclusive + n_offset, offset);
                startIndexInclusive += offset;
                n = n_offset;
                continue;
            }
            ArrayUtils.swap(array2, startIndexInclusive, startIndexInclusive + n_offset, offset);
            break;
        }
    }

    public static void shift(float[] array2, int offset) {
        if (array2 == null) {
            return;
        }
        ArrayUtils.shift(array2, 0, array2.length, offset);
    }

    public static void shift(float[] array2, int startIndexInclusive, int endIndexExclusive, int offset) {
        int n;
        if (array2 == null) {
            return;
        }
        if (startIndexInclusive >= array2.length - 1 || endIndexExclusive <= 0) {
            return;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive >= array2.length) {
            endIndexExclusive = array2.length;
        }
        if ((n = endIndexExclusive - startIndexInclusive) <= 1) {
            return;
        }
        if ((offset %= n) < 0) {
            offset += n;
        }
        while (n > 1 && offset > 0) {
            int n_offset = n - offset;
            if (offset > n_offset) {
                ArrayUtils.swap(array2, startIndexInclusive, startIndexInclusive + n - n_offset, n_offset);
                n = offset;
                offset -= n_offset;
                continue;
            }
            if (offset < n_offset) {
                ArrayUtils.swap(array2, startIndexInclusive, startIndexInclusive + n_offset, offset);
                startIndexInclusive += offset;
                n = n_offset;
                continue;
            }
            ArrayUtils.swap(array2, startIndexInclusive, startIndexInclusive + n_offset, offset);
            break;
        }
    }

    public static void shift(int[] array2, int offset) {
        if (array2 == null) {
            return;
        }
        ArrayUtils.shift(array2, 0, array2.length, offset);
    }

    public static void shift(int[] array2, int startIndexInclusive, int endIndexExclusive, int offset) {
        int n;
        if (array2 == null) {
            return;
        }
        if (startIndexInclusive >= array2.length - 1 || endIndexExclusive <= 0) {
            return;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive >= array2.length) {
            endIndexExclusive = array2.length;
        }
        if ((n = endIndexExclusive - startIndexInclusive) <= 1) {
            return;
        }
        if ((offset %= n) < 0) {
            offset += n;
        }
        while (n > 1 && offset > 0) {
            int n_offset = n - offset;
            if (offset > n_offset) {
                ArrayUtils.swap(array2, startIndexInclusive, startIndexInclusive + n - n_offset, n_offset);
                n = offset;
                offset -= n_offset;
                continue;
            }
            if (offset < n_offset) {
                ArrayUtils.swap(array2, startIndexInclusive, startIndexInclusive + n_offset, offset);
                startIndexInclusive += offset;
                n = n_offset;
                continue;
            }
            ArrayUtils.swap(array2, startIndexInclusive, startIndexInclusive + n_offset, offset);
            break;
        }
    }

    public static void shift(long[] array2, int offset) {
        if (array2 == null) {
            return;
        }
        ArrayUtils.shift(array2, 0, array2.length, offset);
    }

    public static void shift(long[] array2, int startIndexInclusive, int endIndexExclusive, int offset) {
        int n;
        if (array2 == null) {
            return;
        }
        if (startIndexInclusive >= array2.length - 1 || endIndexExclusive <= 0) {
            return;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive >= array2.length) {
            endIndexExclusive = array2.length;
        }
        if ((n = endIndexExclusive - startIndexInclusive) <= 1) {
            return;
        }
        if ((offset %= n) < 0) {
            offset += n;
        }
        while (n > 1 && offset > 0) {
            int n_offset = n - offset;
            if (offset > n_offset) {
                ArrayUtils.swap(array2, startIndexInclusive, startIndexInclusive + n - n_offset, n_offset);
                n = offset;
                offset -= n_offset;
                continue;
            }
            if (offset < n_offset) {
                ArrayUtils.swap(array2, startIndexInclusive, startIndexInclusive + n_offset, offset);
                startIndexInclusive += offset;
                n = n_offset;
                continue;
            }
            ArrayUtils.swap(array2, startIndexInclusive, startIndexInclusive + n_offset, offset);
            break;
        }
    }

    public static void shift(Object[] array2, int offset) {
        if (array2 == null) {
            return;
        }
        ArrayUtils.shift(array2, 0, array2.length, offset);
    }

    public static void shift(Object[] array2, int startIndexInclusive, int endIndexExclusive, int offset) {
        int n;
        if (array2 == null) {
            return;
        }
        if (startIndexInclusive >= array2.length - 1 || endIndexExclusive <= 0) {
            return;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive >= array2.length) {
            endIndexExclusive = array2.length;
        }
        if ((n = endIndexExclusive - startIndexInclusive) <= 1) {
            return;
        }
        if ((offset %= n) < 0) {
            offset += n;
        }
        while (n > 1 && offset > 0) {
            int n_offset = n - offset;
            if (offset > n_offset) {
                ArrayUtils.swap(array2, startIndexInclusive, startIndexInclusive + n - n_offset, n_offset);
                n = offset;
                offset -= n_offset;
                continue;
            }
            if (offset < n_offset) {
                ArrayUtils.swap(array2, startIndexInclusive, startIndexInclusive + n_offset, offset);
                startIndexInclusive += offset;
                n = n_offset;
                continue;
            }
            ArrayUtils.swap(array2, startIndexInclusive, startIndexInclusive + n_offset, offset);
            break;
        }
    }

    public static void shift(short[] array2, int offset) {
        if (array2 == null) {
            return;
        }
        ArrayUtils.shift(array2, 0, array2.length, offset);
    }

    public static void shift(short[] array2, int startIndexInclusive, int endIndexExclusive, int offset) {
        int n;
        if (array2 == null) {
            return;
        }
        if (startIndexInclusive >= array2.length - 1 || endIndexExclusive <= 0) {
            return;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive >= array2.length) {
            endIndexExclusive = array2.length;
        }
        if ((n = endIndexExclusive - startIndexInclusive) <= 1) {
            return;
        }
        if ((offset %= n) < 0) {
            offset += n;
        }
        while (n > 1 && offset > 0) {
            int n_offset = n - offset;
            if (offset > n_offset) {
                ArrayUtils.swap(array2, startIndexInclusive, startIndexInclusive + n - n_offset, n_offset);
                n = offset;
                offset -= n_offset;
                continue;
            }
            if (offset < n_offset) {
                ArrayUtils.swap(array2, startIndexInclusive, startIndexInclusive + n_offset, offset);
                startIndexInclusive += offset;
                n = n_offset;
                continue;
            }
            ArrayUtils.swap(array2, startIndexInclusive, startIndexInclusive + n_offset, offset);
            break;
        }
    }

    public static void shuffle(boolean[] array2) {
        ArrayUtils.shuffle(array2, new Random());
    }

    public static void shuffle(boolean[] array2, Random random) {
        for (int i = array2.length; i > 1; --i) {
            ArrayUtils.swap(array2, i - 1, random.nextInt(i), 1);
        }
    }

    public static void shuffle(byte[] array2) {
        ArrayUtils.shuffle(array2, new Random());
    }

    public static void shuffle(byte[] array2, Random random) {
        for (int i = array2.length; i > 1; --i) {
            ArrayUtils.swap(array2, i - 1, random.nextInt(i), 1);
        }
    }

    public static void shuffle(char[] array2) {
        ArrayUtils.shuffle(array2, new Random());
    }

    public static void shuffle(char[] array2, Random random) {
        for (int i = array2.length; i > 1; --i) {
            ArrayUtils.swap(array2, i - 1, random.nextInt(i), 1);
        }
    }

    public static void shuffle(double[] array2) {
        ArrayUtils.shuffle(array2, new Random());
    }

    public static void shuffle(double[] array2, Random random) {
        for (int i = array2.length; i > 1; --i) {
            ArrayUtils.swap(array2, i - 1, random.nextInt(i), 1);
        }
    }

    public static void shuffle(float[] array2) {
        ArrayUtils.shuffle(array2, new Random());
    }

    public static void shuffle(float[] array2, Random random) {
        for (int i = array2.length; i > 1; --i) {
            ArrayUtils.swap(array2, i - 1, random.nextInt(i), 1);
        }
    }

    public static void shuffle(int[] array2) {
        ArrayUtils.shuffle(array2, new Random());
    }

    public static void shuffle(int[] array2, Random random) {
        for (int i = array2.length; i > 1; --i) {
            ArrayUtils.swap(array2, i - 1, random.nextInt(i), 1);
        }
    }

    public static void shuffle(long[] array2) {
        ArrayUtils.shuffle(array2, new Random());
    }

    public static void shuffle(long[] array2, Random random) {
        for (int i = array2.length; i > 1; --i) {
            ArrayUtils.swap(array2, i - 1, random.nextInt(i), 1);
        }
    }

    public static void shuffle(Object[] array2) {
        ArrayUtils.shuffle(array2, new Random());
    }

    public static void shuffle(Object[] array2, Random random) {
        for (int i = array2.length; i > 1; --i) {
            ArrayUtils.swap(array2, i - 1, random.nextInt(i), 1);
        }
    }

    public static void shuffle(short[] array2) {
        ArrayUtils.shuffle(array2, new Random());
    }

    public static void shuffle(short[] array2, Random random) {
        for (int i = array2.length; i > 1; --i) {
            ArrayUtils.swap(array2, i - 1, random.nextInt(i), 1);
        }
    }

    public static boolean[] subarray(boolean[] array2, int startIndexInclusive, int endIndexExclusive) {
        int newSize;
        if (array2 == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array2.length) {
            endIndexExclusive = array2.length;
        }
        if ((newSize = endIndexExclusive - startIndexInclusive) <= 0) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] subarray = new boolean[newSize];
        System.arraycopy(array2, startIndexInclusive, subarray, 0, newSize);
        return subarray;
    }

    public static byte[] subarray(byte[] array2, int startIndexInclusive, int endIndexExclusive) {
        int newSize;
        if (array2 == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array2.length) {
            endIndexExclusive = array2.length;
        }
        if ((newSize = endIndexExclusive - startIndexInclusive) <= 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] subarray = new byte[newSize];
        System.arraycopy(array2, startIndexInclusive, subarray, 0, newSize);
        return subarray;
    }

    public static char[] subarray(char[] array2, int startIndexInclusive, int endIndexExclusive) {
        int newSize;
        if (array2 == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array2.length) {
            endIndexExclusive = array2.length;
        }
        if ((newSize = endIndexExclusive - startIndexInclusive) <= 0) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] subarray = new char[newSize];
        System.arraycopy(array2, startIndexInclusive, subarray, 0, newSize);
        return subarray;
    }

    public static double[] subarray(double[] array2, int startIndexInclusive, int endIndexExclusive) {
        int newSize;
        if (array2 == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array2.length) {
            endIndexExclusive = array2.length;
        }
        if ((newSize = endIndexExclusive - startIndexInclusive) <= 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] subarray = new double[newSize];
        System.arraycopy(array2, startIndexInclusive, subarray, 0, newSize);
        return subarray;
    }

    public static float[] subarray(float[] array2, int startIndexInclusive, int endIndexExclusive) {
        int newSize;
        if (array2 == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array2.length) {
            endIndexExclusive = array2.length;
        }
        if ((newSize = endIndexExclusive - startIndexInclusive) <= 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        float[] subarray = new float[newSize];
        System.arraycopy(array2, startIndexInclusive, subarray, 0, newSize);
        return subarray;
    }

    public static int[] subarray(int[] array2, int startIndexInclusive, int endIndexExclusive) {
        int newSize;
        if (array2 == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array2.length) {
            endIndexExclusive = array2.length;
        }
        if ((newSize = endIndexExclusive - startIndexInclusive) <= 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] subarray = new int[newSize];
        System.arraycopy(array2, startIndexInclusive, subarray, 0, newSize);
        return subarray;
    }

    public static long[] subarray(long[] array2, int startIndexInclusive, int endIndexExclusive) {
        int newSize;
        if (array2 == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array2.length) {
            endIndexExclusive = array2.length;
        }
        if ((newSize = endIndexExclusive - startIndexInclusive) <= 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] subarray = new long[newSize];
        System.arraycopy(array2, startIndexInclusive, subarray, 0, newSize);
        return subarray;
    }

    public static short[] subarray(short[] array2, int startIndexInclusive, int endIndexExclusive) {
        int newSize;
        if (array2 == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array2.length) {
            endIndexExclusive = array2.length;
        }
        if ((newSize = endIndexExclusive - startIndexInclusive) <= 0) {
            return EMPTY_SHORT_ARRAY;
        }
        short[] subarray = new short[newSize];
        System.arraycopy(array2, startIndexInclusive, subarray, 0, newSize);
        return subarray;
    }

    public static <T> T[] subarray(T[] array2, int startIndexInclusive, int endIndexExclusive) {
        if (array2 == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array2.length) {
            endIndexExclusive = array2.length;
        }
        int newSize = endIndexExclusive - startIndexInclusive;
        Class<?> type = array2.getClass().getComponentType();
        if (newSize <= 0) {
            Object[] emptyArray = (Object[])Array.newInstance(type, 0);
            return emptyArray;
        }
        Object[] subarray = (Object[])Array.newInstance(type, newSize);
        System.arraycopy(array2, startIndexInclusive, subarray, 0, newSize);
        return subarray;
    }

    public static void swap(boolean[] array2, int offset1, int offset2) {
        if (ArrayUtils.isEmpty(array2)) {
            return;
        }
        ArrayUtils.swap(array2, offset1, offset2, 1);
    }

    public static void swap(boolean[] array2, int offset1, int offset2, int len) {
        if (ArrayUtils.isEmpty(array2) || offset1 >= array2.length || offset2 >= array2.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array2.length - offset1), array2.length - offset2);
        int i = 0;
        while (i < len) {
            boolean aux = array2[offset1];
            array2[offset1] = array2[offset2];
            array2[offset2] = aux;
            ++i;
            ++offset1;
            ++offset2;
        }
    }

    public static void swap(byte[] array2, int offset1, int offset2) {
        if (ArrayUtils.isEmpty(array2)) {
            return;
        }
        ArrayUtils.swap(array2, offset1, offset2, 1);
    }

    public static void swap(byte[] array2, int offset1, int offset2, int len) {
        if (ArrayUtils.isEmpty(array2) || offset1 >= array2.length || offset2 >= array2.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array2.length - offset1), array2.length - offset2);
        int i = 0;
        while (i < len) {
            byte aux = array2[offset1];
            array2[offset1] = array2[offset2];
            array2[offset2] = aux;
            ++i;
            ++offset1;
            ++offset2;
        }
    }

    public static void swap(char[] array2, int offset1, int offset2) {
        if (ArrayUtils.isEmpty(array2)) {
            return;
        }
        ArrayUtils.swap(array2, offset1, offset2, 1);
    }

    public static void swap(char[] array2, int offset1, int offset2, int len) {
        if (ArrayUtils.isEmpty(array2) || offset1 >= array2.length || offset2 >= array2.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array2.length - offset1), array2.length - offset2);
        int i = 0;
        while (i < len) {
            char aux = array2[offset1];
            array2[offset1] = array2[offset2];
            array2[offset2] = aux;
            ++i;
            ++offset1;
            ++offset2;
        }
    }

    public static void swap(double[] array2, int offset1, int offset2) {
        if (ArrayUtils.isEmpty(array2)) {
            return;
        }
        ArrayUtils.swap(array2, offset1, offset2, 1);
    }

    public static void swap(double[] array2, int offset1, int offset2, int len) {
        if (ArrayUtils.isEmpty(array2) || offset1 >= array2.length || offset2 >= array2.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array2.length - offset1), array2.length - offset2);
        int i = 0;
        while (i < len) {
            double aux = array2[offset1];
            array2[offset1] = array2[offset2];
            array2[offset2] = aux;
            ++i;
            ++offset1;
            ++offset2;
        }
    }

    public static void swap(float[] array2, int offset1, int offset2) {
        if (ArrayUtils.isEmpty(array2)) {
            return;
        }
        ArrayUtils.swap(array2, offset1, offset2, 1);
    }

    public static void swap(float[] array2, int offset1, int offset2, int len) {
        if (ArrayUtils.isEmpty(array2) || offset1 >= array2.length || offset2 >= array2.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array2.length - offset1), array2.length - offset2);
        int i = 0;
        while (i < len) {
            float aux = array2[offset1];
            array2[offset1] = array2[offset2];
            array2[offset2] = aux;
            ++i;
            ++offset1;
            ++offset2;
        }
    }

    public static void swap(int[] array2, int offset1, int offset2) {
        if (ArrayUtils.isEmpty(array2)) {
            return;
        }
        ArrayUtils.swap(array2, offset1, offset2, 1);
    }

    public static void swap(int[] array2, int offset1, int offset2, int len) {
        if (ArrayUtils.isEmpty(array2) || offset1 >= array2.length || offset2 >= array2.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array2.length - offset1), array2.length - offset2);
        int i = 0;
        while (i < len) {
            int aux = array2[offset1];
            array2[offset1] = array2[offset2];
            array2[offset2] = aux;
            ++i;
            ++offset1;
            ++offset2;
        }
    }

    public static void swap(long[] array2, int offset1, int offset2) {
        if (ArrayUtils.isEmpty(array2)) {
            return;
        }
        ArrayUtils.swap(array2, offset1, offset2, 1);
    }

    public static void swap(long[] array2, int offset1, int offset2, int len) {
        if (ArrayUtils.isEmpty(array2) || offset1 >= array2.length || offset2 >= array2.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array2.length - offset1), array2.length - offset2);
        int i = 0;
        while (i < len) {
            long aux = array2[offset1];
            array2[offset1] = array2[offset2];
            array2[offset2] = aux;
            ++i;
            ++offset1;
            ++offset2;
        }
    }

    public static void swap(Object[] array2, int offset1, int offset2) {
        if (ArrayUtils.isEmpty(array2)) {
            return;
        }
        ArrayUtils.swap(array2, offset1, offset2, 1);
    }

    public static void swap(Object[] array2, int offset1, int offset2, int len) {
        if (ArrayUtils.isEmpty(array2) || offset1 >= array2.length || offset2 >= array2.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array2.length - offset1), array2.length - offset2);
        int i = 0;
        while (i < len) {
            Object aux = array2[offset1];
            array2[offset1] = array2[offset2];
            array2[offset2] = aux;
            ++i;
            ++offset1;
            ++offset2;
        }
    }

    public static void swap(short[] array2, int offset1, int offset2) {
        if (ArrayUtils.isEmpty(array2)) {
            return;
        }
        ArrayUtils.swap(array2, offset1, offset2, 1);
    }

    public static void swap(short[] array2, int offset1, int offset2, int len) {
        if (ArrayUtils.isEmpty(array2) || offset1 >= array2.length || offset2 >= array2.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        if (offset1 == offset2) {
            return;
        }
        len = Math.min(Math.min(len, array2.length - offset1), array2.length - offset2);
        int i = 0;
        while (i < len) {
            short aux = array2[offset1];
            array2[offset1] = array2[offset2];
            array2[offset2] = aux;
            ++i;
            ++offset1;
            ++offset2;
        }
    }

    public static <T> T[] toArray(T ... items) {
        return items;
    }

    public static Map<Object, Object> toMap(Object[] array2) {
        if (array2 == null) {
            return null;
        }
        HashMap<Object, Object> map2 = new HashMap<Object, Object>((int)((double)array2.length * 1.5));
        for (int i = 0; i < array2.length; ++i) {
            Object[] entry2;
            Object object = array2[i];
            if (object instanceof Map.Entry) {
                entry2 = (Object[])object;
                map2.put(entry2.getKey(), entry2.getValue());
                continue;
            }
            if (object instanceof Object[]) {
                entry2 = (Object[])object;
                if (entry2.length < 2) {
                    throw new IllegalArgumentException("Array element " + i + ", '" + object + "', has a length less than 2");
                }
                map2.put(entry2[0], entry2[1]);
                continue;
            }
            throw new IllegalArgumentException("Array element " + i + ", '" + object + "', is neither of type Map.Entry nor an Array");
        }
        return map2;
    }

    public static Boolean[] toObject(boolean[] array2) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_BOOLEAN_OBJECT_ARRAY;
        }
        Boolean[] result2 = new Boolean[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            result2[i] = array2[i] ? Boolean.TRUE : Boolean.FALSE;
        }
        return result2;
    }

    public static Byte[] toObject(byte[] array2) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_BYTE_OBJECT_ARRAY;
        }
        Byte[] result2 = new Byte[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            result2[i] = array2[i];
        }
        return result2;
    }

    public static Character[] toObject(char[] array2) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_CHARACTER_OBJECT_ARRAY;
        }
        Character[] result2 = new Character[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            result2[i] = Character.valueOf(array2[i]);
        }
        return result2;
    }

    public static Double[] toObject(double[] array2) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_DOUBLE_OBJECT_ARRAY;
        }
        Double[] result2 = new Double[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            result2[i] = array2[i];
        }
        return result2;
    }

    public static Float[] toObject(float[] array2) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_FLOAT_OBJECT_ARRAY;
        }
        Float[] result2 = new Float[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            result2[i] = Float.valueOf(array2[i]);
        }
        return result2;
    }

    public static Integer[] toObject(int[] array2) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_INTEGER_OBJECT_ARRAY;
        }
        Integer[] result2 = new Integer[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            result2[i] = array2[i];
        }
        return result2;
    }

    public static Long[] toObject(long[] array2) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_LONG_OBJECT_ARRAY;
        }
        Long[] result2 = new Long[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            result2[i] = array2[i];
        }
        return result2;
    }

    public static Short[] toObject(short[] array2) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_SHORT_OBJECT_ARRAY;
        }
        Short[] result2 = new Short[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            result2[i] = array2[i];
        }
        return result2;
    }

    public static boolean[] toPrimitive(Boolean[] array2) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] result2 = new boolean[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            result2[i] = array2[i];
        }
        return result2;
    }

    public static boolean[] toPrimitive(Boolean[] array2, boolean valueForNull) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] result2 = new boolean[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            Boolean b = array2[i];
            result2[i] = b == null ? valueForNull : b;
        }
        return result2;
    }

    public static byte[] toPrimitive(Byte[] array2) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] result2 = new byte[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            result2[i] = array2[i];
        }
        return result2;
    }

    public static byte[] toPrimitive(Byte[] array2, byte valueForNull) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] result2 = new byte[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            Byte b = array2[i];
            result2[i] = b == null ? valueForNull : b;
        }
        return result2;
    }

    public static char[] toPrimitive(Character[] array2) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] result2 = new char[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            result2[i] = array2[i].charValue();
        }
        return result2;
    }

    public static char[] toPrimitive(Character[] array2, char valueForNull) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] result2 = new char[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            Character b = array2[i];
            result2[i] = b == null ? valueForNull : b.charValue();
        }
        return result2;
    }

    public static double[] toPrimitive(Double[] array2) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] result2 = new double[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            result2[i] = array2[i];
        }
        return result2;
    }

    public static double[] toPrimitive(Double[] array2, double valueForNull) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] result2 = new double[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            Double b = array2[i];
            result2[i] = b == null ? valueForNull : b;
        }
        return result2;
    }

    public static float[] toPrimitive(Float[] array2) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        float[] result2 = new float[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            result2[i] = array2[i].floatValue();
        }
        return result2;
    }

    public static float[] toPrimitive(Float[] array2, float valueForNull) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        float[] result2 = new float[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            Float b = array2[i];
            result2[i] = b == null ? valueForNull : b.floatValue();
        }
        return result2;
    }

    public static int[] toPrimitive(Integer[] array2) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] result2 = new int[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            result2[i] = array2[i];
        }
        return result2;
    }

    public static int[] toPrimitive(Integer[] array2, int valueForNull) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] result2 = new int[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            Integer b = array2[i];
            result2[i] = b == null ? valueForNull : b;
        }
        return result2;
    }

    public static long[] toPrimitive(Long[] array2) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] result2 = new long[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            result2[i] = array2[i];
        }
        return result2;
    }

    public static long[] toPrimitive(Long[] array2, long valueForNull) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] result2 = new long[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            Long b = array2[i];
            result2[i] = b == null ? valueForNull : b;
        }
        return result2;
    }

    public static Object toPrimitive(Object array2) {
        if (array2 == null) {
            return null;
        }
        Class<?> ct = array2.getClass().getComponentType();
        Class<?> pt = ClassUtils.wrapperToPrimitive(ct);
        if (Integer.TYPE.equals(pt)) {
            return ArrayUtils.toPrimitive((Integer[])array2);
        }
        if (Long.TYPE.equals(pt)) {
            return ArrayUtils.toPrimitive((Long[])array2);
        }
        if (Short.TYPE.equals(pt)) {
            return ArrayUtils.toPrimitive((Short[])array2);
        }
        if (Double.TYPE.equals(pt)) {
            return ArrayUtils.toPrimitive((Double[])array2);
        }
        if (Float.TYPE.equals(pt)) {
            return ArrayUtils.toPrimitive((Float[])array2);
        }
        return array2;
    }

    public static short[] toPrimitive(Short[] array2) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_SHORT_ARRAY;
        }
        short[] result2 = new short[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            result2[i] = array2[i];
        }
        return result2;
    }

    public static short[] toPrimitive(Short[] array2, short valueForNull) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_SHORT_ARRAY;
        }
        short[] result2 = new short[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            Short b = array2[i];
            result2[i] = b == null ? valueForNull : b;
        }
        return result2;
    }

    public static String toString(Object array2) {
        return ArrayUtils.toString(array2, "{}");
    }

    public static String toString(Object array2, String stringIfNull) {
        if (array2 == null) {
            return stringIfNull;
        }
        return new ToStringBuilder(array2, ToStringStyle.SIMPLE_STYLE).append(array2).toString();
    }

    public static String[] toStringArray(Object[] array2) {
        if (array2 == null) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] result2 = new String[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            result2[i] = array2[i].toString();
        }
        return result2;
    }

    public static String[] toStringArray(Object[] array2, String valueForNullElements) {
        if (null == array2) {
            return null;
        }
        if (array2.length == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] result2 = new String[array2.length];
        for (int i = 0; i < array2.length; ++i) {
            Object object = array2[i];
            result2[i] = object == null ? valueForNullElements : object.toString();
        }
        return result2;
    }
}

