/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.exception;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.exception.Nestable;

public class ExceptionUtils {
    static final String WRAPPED_MARKER = " [wrapped] ";
    private static final Object CAUSE_METHOD_NAMES_LOCK;
    private static String[] CAUSE_METHOD_NAMES;
    private static final Method THROWABLE_CAUSE_METHOD;
    private static final Method THROWABLE_INITCAUSE_METHOD;
    static /* synthetic */ Class class$java$lang$Throwable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCauseMethodName(String methodName) {
        ArrayList list2;
        if (StringUtils.isNotEmpty(methodName) && !ExceptionUtils.isCauseMethodName(methodName) && (list2 = ExceptionUtils.getCauseMethodNameList()).add(methodName)) {
            Object object = CAUSE_METHOD_NAMES_LOCK;
            synchronized (object) {
                CAUSE_METHOD_NAMES = ExceptionUtils.toArray(list2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCauseMethodName(String methodName) {
        ArrayList list2;
        if (StringUtils.isNotEmpty(methodName) && (list2 = ExceptionUtils.getCauseMethodNameList()).remove(methodName)) {
            Object object = CAUSE_METHOD_NAMES_LOCK;
            synchronized (object) {
                CAUSE_METHOD_NAMES = ExceptionUtils.toArray(list2);
            }
        }
    }

    public static boolean setCause(Throwable target, Throwable cause) {
        if (target == null) {
            throw new NullArgumentException("target");
        }
        Object[] causeArgs = new Object[]{cause};
        boolean modifiedTarget = false;
        if (THROWABLE_INITCAUSE_METHOD != null) {
            try {
                THROWABLE_INITCAUSE_METHOD.invoke((Object)target, causeArgs);
                modifiedTarget = true;
            }
            catch (IllegalAccessException ignored) {
            }
            catch (InvocationTargetException ignored) {
                // empty catch block
            }
        }
        try {
            Method setCauseMethod = target.getClass().getMethod("setCause", class$java$lang$Throwable == null ? (class$java$lang$Throwable = ExceptionUtils.class$("java.lang.Throwable")) : class$java$lang$Throwable);
            setCauseMethod.invoke((Object)target, causeArgs);
            modifiedTarget = true;
        }
        catch (NoSuchMethodException ignored) {
        }
        catch (IllegalAccessException ignored) {
        }
        catch (InvocationTargetException ignored) {
            // empty catch block
        }
        return modifiedTarget;
    }

    private static String[] toArray(List list2) {
        return list2.toArray(new String[list2.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList getCauseMethodNameList() {
        Object object = CAUSE_METHOD_NAMES_LOCK;
        synchronized (object) {
            return new ArrayList<String>(Arrays.asList(CAUSE_METHOD_NAMES));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCauseMethodName(String methodName) {
        Object object = CAUSE_METHOD_NAMES_LOCK;
        synchronized (object) {
            return ArrayUtils.indexOf(CAUSE_METHOD_NAMES, methodName) >= 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Throwable getCause(Throwable throwable2) {
        Object object = CAUSE_METHOD_NAMES_LOCK;
        synchronized (object) {
            return ExceptionUtils.getCause(throwable2, CAUSE_METHOD_NAMES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Throwable getCause(Throwable throwable2, String[] methodNames2) {
        if (throwable2 == null) {
            return null;
        }
        Throwable cause = ExceptionUtils.getCauseUsingWellKnownTypes(throwable2);
        if (cause == null) {
            String methodName;
            if (methodNames2 == null) {
                Object object = CAUSE_METHOD_NAMES_LOCK;
                synchronized (object) {
                    methodNames2 = CAUSE_METHOD_NAMES;
                }
            }
            for (int i = 0; i < methodNames2.length && ((methodName = methodNames2[i]) == null || (cause = ExceptionUtils.getCauseUsingMethodName(throwable2, methodName)) == null); ++i) {
            }
            if (cause == null) {
                cause = ExceptionUtils.getCauseUsingFieldName(throwable2, "detail");
            }
        }
        return cause;
    }

    public static Throwable getRootCause(Throwable throwable2) {
        List list2 = ExceptionUtils.getThrowableList(throwable2);
        return list2.size() < 2 ? null : (Throwable)list2.get(list2.size() - 1);
    }

    private static Throwable getCauseUsingWellKnownTypes(Throwable throwable2) {
        if (throwable2 instanceof Nestable) {
            return ((Nestable)((Object)throwable2)).getCause();
        }
        if (throwable2 instanceof SQLException) {
            return ((SQLException)throwable2).getNextException();
        }
        if (throwable2 instanceof InvocationTargetException) {
            return ((InvocationTargetException)throwable2).getTargetException();
        }
        return null;
    }

    private static Throwable getCauseUsingMethodName(Throwable throwable2, String methodName) {
        Method method = null;
        try {
            method = throwable2.getClass().getMethod(methodName, null);
        }
        catch (NoSuchMethodException ignored) {
        }
        catch (SecurityException ignored) {
            // empty catch block
        }
        if (method != null && (class$java$lang$Throwable == null ? (class$java$lang$Throwable = ExceptionUtils.class$("java.lang.Throwable")) : class$java$lang$Throwable).isAssignableFrom(method.getReturnType())) {
            try {
                return (Throwable)method.invoke((Object)throwable2, ArrayUtils.EMPTY_OBJECT_ARRAY);
            }
            catch (IllegalAccessException ignored) {
            }
            catch (IllegalArgumentException ignored) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Throwable getCauseUsingFieldName(Throwable throwable2, String fieldName) {
        Field field2 = null;
        try {
            field2 = throwable2.getClass().getField(fieldName);
        }
        catch (NoSuchFieldException ignored) {
        }
        catch (SecurityException ignored) {
            // empty catch block
        }
        if (field2 != null && (class$java$lang$Throwable == null ? (class$java$lang$Throwable = ExceptionUtils.class$("java.lang.Throwable")) : class$java$lang$Throwable).isAssignableFrom(field2.getType())) {
            try {
                return (Throwable)field2.get(throwable2);
            }
            catch (IllegalAccessException ignored) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isThrowableNested() {
        return THROWABLE_CAUSE_METHOD != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isNestedThrowable(Throwable throwable2) {
        if (throwable2 == null) {
            return false;
        }
        if (throwable2 instanceof Nestable) {
            return true;
        }
        if (throwable2 instanceof SQLException) {
            return true;
        }
        if (throwable2 instanceof InvocationTargetException) {
            return true;
        }
        if (ExceptionUtils.isThrowableNested()) {
            return true;
        }
        Class<?> cls = throwable2.getClass();
        Object object = CAUSE_METHOD_NAMES_LOCK;
        synchronized (object) {
            int isize = CAUSE_METHOD_NAMES.length;
            for (int i = 0; i < isize; ++i) {
                try {
                    Method method = cls.getMethod(CAUSE_METHOD_NAMES[i], null);
                    if (method == null || !(class$java$lang$Throwable == null ? ExceptionUtils.class$("java.lang.Throwable") : class$java$lang$Throwable).isAssignableFrom(method.getReturnType())) continue;
                    return true;
                }
                catch (NoSuchMethodException ignored) {
                    continue;
                }
                catch (SecurityException ignored) {
                    // empty catch block
                }
            }
        }
        try {
            Field field2 = cls.getField("detail");
            if (field2 != null) {
                return true;
            }
        }
        catch (NoSuchFieldException ignored) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return false;
    }

    public static int getThrowableCount(Throwable throwable2) {
        return ExceptionUtils.getThrowableList(throwable2).size();
    }

    public static Throwable[] getThrowables(Throwable throwable2) {
        List list2 = ExceptionUtils.getThrowableList(throwable2);
        return list2.toArray(new Throwable[list2.size()]);
    }

    public static List getThrowableList(Throwable throwable2) {
        ArrayList<Throwable> list2 = new ArrayList<Throwable>();
        while (throwable2 != null && !list2.contains(throwable2)) {
            list2.add(throwable2);
            throwable2 = ExceptionUtils.getCause(throwable2);
        }
        return list2;
    }

    public static int indexOfThrowable(Throwable throwable2, Class clazz2) {
        return ExceptionUtils.indexOf(throwable2, clazz2, 0, false);
    }

    public static int indexOfThrowable(Throwable throwable2, Class clazz2, int fromIndex) {
        return ExceptionUtils.indexOf(throwable2, clazz2, fromIndex, false);
    }

    public static int indexOfType(Throwable throwable2, Class type) {
        return ExceptionUtils.indexOf(throwable2, type, 0, true);
    }

    public static int indexOfType(Throwable throwable2, Class type, int fromIndex) {
        return ExceptionUtils.indexOf(throwable2, type, fromIndex, true);
    }

    private static int indexOf(Throwable throwable2, Class type, int fromIndex, boolean subclass) {
        Throwable[] throwables;
        if (throwable2 == null || type == null) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (fromIndex >= (throwables = ExceptionUtils.getThrowables(throwable2)).length) {
            return -1;
        }
        if (subclass) {
            for (int i = fromIndex; i < throwables.length; ++i) {
                if (!type.isAssignableFrom(throwables[i].getClass())) continue;
                return i;
            }
        } else {
            for (int i = fromIndex; i < throwables.length; ++i) {
                if (!type.equals(throwables[i].getClass())) continue;
                return i;
            }
        }
        return -1;
    }

    public static void printRootCauseStackTrace(Throwable throwable2) {
        ExceptionUtils.printRootCauseStackTrace(throwable2, System.err);
    }

    public static void printRootCauseStackTrace(Throwable throwable2, PrintStream stream) {
        if (throwable2 == null) {
            return;
        }
        if (stream == null) {
            throw new IllegalArgumentException("The PrintStream must not be null");
        }
        String[] trace = ExceptionUtils.getRootCauseStackTrace(throwable2);
        for (int i = 0; i < trace.length; ++i) {
            stream.println(trace[i]);
        }
        stream.flush();
    }

    public static void printRootCauseStackTrace(Throwable throwable2, PrintWriter writer) {
        if (throwable2 == null) {
            return;
        }
        if (writer == null) {
            throw new IllegalArgumentException("The PrintWriter must not be null");
        }
        String[] trace = ExceptionUtils.getRootCauseStackTrace(throwable2);
        for (int i = 0; i < trace.length; ++i) {
            writer.println(trace[i]);
        }
        writer.flush();
    }

    public static String[] getRootCauseStackTrace(Throwable throwable2) {
        if (throwable2 == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        Throwable[] throwables = ExceptionUtils.getThrowables(throwable2);
        int count2 = throwables.length;
        ArrayList<String> frames = new ArrayList<String>();
        List nextTrace = ExceptionUtils.getStackFrameList(throwables[count2 - 1]);
        int i = count2;
        while (--i >= 0) {
            List trace = nextTrace;
            if (i != 0) {
                nextTrace = ExceptionUtils.getStackFrameList(throwables[i - 1]);
                ExceptionUtils.removeCommonFrames(trace, nextTrace);
            }
            if (i == count2 - 1) {
                frames.add(throwables[i].toString());
            } else {
                frames.add(WRAPPED_MARKER + throwables[i].toString());
            }
            for (int j = 0; j < trace.size(); ++j) {
                frames.add((String)trace.get(j));
            }
        }
        return frames.toArray(new String[0]);
    }

    public static void removeCommonFrames(List causeFrames, List wrapperFrames) {
        if (causeFrames == null || wrapperFrames == null) {
            throw new IllegalArgumentException("The List must not be null");
        }
        int causeFrameIndex = causeFrames.size() - 1;
        for (int wrapperFrameIndex = wrapperFrames.size() - 1; causeFrameIndex >= 0 && wrapperFrameIndex >= 0; --causeFrameIndex, --wrapperFrameIndex) {
            String wrapperFrame;
            String causeFrame = (String)causeFrames.get(causeFrameIndex);
            if (!causeFrame.equals(wrapperFrame = (String)wrapperFrames.get(wrapperFrameIndex))) continue;
            causeFrames.remove(causeFrameIndex);
        }
    }

    public static String getFullStackTrace(Throwable throwable2) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        Throwable[] ts = ExceptionUtils.getThrowables(throwable2);
        for (int i = 0; i < ts.length; ++i) {
            ts[i].printStackTrace(pw);
            if (ExceptionUtils.isNestedThrowable(ts[i])) break;
        }
        return sw.getBuffer().toString();
    }

    public static String getStackTrace(Throwable throwable2) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable2.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    public static String[] getStackFrames(Throwable throwable2) {
        if (throwable2 == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return ExceptionUtils.getStackFrames(ExceptionUtils.getStackTrace(throwable2));
    }

    static String[] getStackFrames(String stackTrace) {
        String linebreak = SystemUtils.LINE_SEPARATOR;
        StringTokenizer frames = new StringTokenizer(stackTrace, linebreak);
        ArrayList<String> list2 = new ArrayList<String>();
        while (frames.hasMoreTokens()) {
            list2.add(frames.nextToken());
        }
        return ExceptionUtils.toArray(list2);
    }

    static List getStackFrameList(Throwable t) {
        String stackTrace = ExceptionUtils.getStackTrace(t);
        String linebreak = SystemUtils.LINE_SEPARATOR;
        StringTokenizer frames = new StringTokenizer(stackTrace, linebreak);
        ArrayList<String> list2 = new ArrayList<String>();
        boolean traceStarted = false;
        while (frames.hasMoreTokens()) {
            String token2 = frames.nextToken();
            int at = token2.indexOf("at");
            if (at != -1 && token2.substring(0, at).trim().length() == 0) {
                traceStarted = true;
                list2.add(token2);
                continue;
            }
            if (!traceStarted) continue;
            break;
        }
        return list2;
    }

    public static String getMessage(Throwable th) {
        if (th == null) {
            return "";
        }
        String clsName = ClassUtils.getShortClassName(th, null);
        String msg = th.getMessage();
        return clsName + ": " + StringUtils.defaultString(msg);
    }

    public static String getRootCauseMessage(Throwable th) {
        Throwable root2 = ExceptionUtils.getRootCause(th);
        root2 = root2 == null ? th : root2;
        return ExceptionUtils.getMessage(root2);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Method causeMethod;
        CAUSE_METHOD_NAMES_LOCK = new Object();
        CAUSE_METHOD_NAMES = new String[]{"getCause", "getNextException", "getTargetException", "getException", "getSourceException", "getRootCause", "getCausedByException", "getNested", "getLinkedException", "getNestedException", "getLinkedCause", "getThrowable"};
        try {
            causeMethod = (class$java$lang$Throwable == null ? (class$java$lang$Throwable = ExceptionUtils.class$("java.lang.Throwable")) : class$java$lang$Throwable).getMethod("getCause", null);
        }
        catch (Exception e) {
            causeMethod = null;
        }
        THROWABLE_CAUSE_METHOD = causeMethod;
        try {
            causeMethod = (class$java$lang$Throwable == null ? (class$java$lang$Throwable = ExceptionUtils.class$("java.lang.Throwable")) : class$java$lang$Throwable).getMethod("initCause", class$java$lang$Throwable == null ? (class$java$lang$Throwable = ExceptionUtils.class$("java.lang.Throwable")) : class$java$lang$Throwable);
        }
        catch (Exception e) {
            causeMethod = null;
        }
        THROWABLE_INITCAUSE_METHOD = causeMethod;
    }
}

