/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.tree.xpath;

import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.ExpressionEngine;
import org.apache.commons.configuration.tree.NodeAddData;
import org.apache.commons.configuration.tree.xpath.ConfigurationNodePointerFactory;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.ri.JXPathContextReferenceImpl;
import org.apache.commons.jxpath.ri.model.NodePointerFactory;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathExpressionEngine
implements ExpressionEngine {
    static final String PATH_DELIMITER = "/";
    static final String ATTR_DELIMITER = "@";
    private static final String NODE_PATH_DELIMITERS = "/@";
    private static final String SPACE = " ";

    @Override
    public List<ConfigurationNode> query(ConfigurationNode root2, String key) {
        if (StringUtils.isEmpty(key)) {
            return Collections.singletonList(root2);
        }
        JXPathContext context = this.createContext(root2, key);
        List<ConfigurationNode> result2 = context.selectNodes(key);
        if (result2 == null) {
            result2 = Collections.emptyList();
        }
        return result2;
    }

    @Override
    public String nodeKey(ConfigurationNode node, String parentKey) {
        if (parentKey == null) {
            return "";
        }
        if (node.getName() == null) {
            return parentKey;
        }
        StringBuilder buf = new StringBuilder(parentKey.length() + node.getName().length() + PATH_DELIMITER.length());
        if (parentKey.length() > 0) {
            buf.append(parentKey);
            buf.append(PATH_DELIMITER);
        }
        if (node.isAttribute()) {
            buf.append(ATTR_DELIMITER);
        }
        buf.append(node.getName());
        return buf.toString();
    }

    @Override
    public NodeAddData prepareAdd(ConfigurationNode root2, String key) {
        List<ConfigurationNode> nodes2;
        if (key == null) {
            throw new IllegalArgumentException("prepareAdd: key must not be null!");
        }
        String addKey = key;
        int index2 = XPathExpressionEngine.findKeySeparator(addKey);
        if (index2 < 0) {
            addKey = this.generateKeyForAdd(root2, addKey);
            index2 = XPathExpressionEngine.findKeySeparator(addKey);
        }
        if ((nodes2 = this.query(root2, addKey.substring(0, index2).trim())).size() != 1) {
            throw new IllegalArgumentException("prepareAdd: key must select exactly one target node!");
        }
        NodeAddData data2 = new NodeAddData();
        data2.setParent(nodes2.get(0));
        this.initNodeAddData(data2, addKey.substring(index2).trim());
        return data2;
    }

    protected JXPathContext createContext(ConfigurationNode root2, String key) {
        JXPathContext context = JXPathContext.newContext((Object)root2);
        context.setLenient(true);
        return context;
    }

    protected void initNodeAddData(NodeAddData data2, String path) {
        String lastComponent = null;
        boolean attr = false;
        boolean first = true;
        StringTokenizer tok = new StringTokenizer(path, NODE_PATH_DELIMITERS, true);
        while (tok.hasMoreTokens()) {
            String token2 = tok.nextToken();
            if (PATH_DELIMITER.equals(token2)) {
                if (attr) {
                    this.invalidPath(path, " contains an attribute delimiter at an unallowed position.");
                }
                if (lastComponent == null) {
                    this.invalidPath(path, " contains a '/' at an unallowed position.");
                }
                data2.addPathNode(lastComponent);
                lastComponent = null;
            } else if (ATTR_DELIMITER.equals(token2)) {
                if (attr) {
                    this.invalidPath(path, " contains multiple attribute delimiters.");
                }
                if (lastComponent == null && !first) {
                    this.invalidPath(path, " contains an attribute delimiter at an unallowed position.");
                }
                if (lastComponent != null) {
                    data2.addPathNode(lastComponent);
                }
                attr = true;
                lastComponent = null;
            } else {
                lastComponent = token2;
            }
            first = false;
        }
        if (lastComponent == null) {
            this.invalidPath(path, "contains no components.");
        }
        data2.setNewNodeName(lastComponent);
        data2.setAttribute(attr);
    }

    private String generateKeyForAdd(ConfigurationNode root2, String key) {
        int pos = key.lastIndexOf(PATH_DELIMITER, key.length());
        while (pos >= 0) {
            String keyExisting = key.substring(0, pos);
            if (!this.query(root2, keyExisting).isEmpty()) {
                StringBuilder buf = new StringBuilder(key.length() + 1);
                buf.append(keyExisting).append(SPACE);
                buf.append(key.substring(pos + 1));
                return buf.toString();
            }
            pos = key.lastIndexOf(PATH_DELIMITER, pos - 1);
        }
        return SPACE + key;
    }

    private void invalidPath(String path, String msg) {
        throw new IllegalArgumentException("Invalid node path: \"" + path + "\" " + msg);
    }

    private static int findKeySeparator(String key) {
        int index2;
        for (index2 = key.length() - 1; index2 >= 0 && !Character.isWhitespace(key.charAt(index2)); --index2) {
        }
        return index2;
    }

    static {
        JXPathContextReferenceImpl.addNodePointerFactory((NodePointerFactory)new ConfigurationNodePointerFactory());
    }
}

