/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.tree.xpath;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.xpath.ConfigurationNodeIteratorBase;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConfigurationNodeIteratorChildren
extends ConfigurationNodeIteratorBase {
    public ConfigurationNodeIteratorChildren(NodePointer parent, NodeTest nodeTest, boolean reverse2, NodePointer startsWith2) {
        super(parent, reverse2);
        ConfigurationNode root2 = (ConfigurationNode)parent.getNode();
        List<ConfigurationNode> childNodes = this.createSubNodeList(root2, nodeTest);
        this.initSubNodeList(childNodes);
        if (startsWith2 != null) {
            this.setStartOffset(this.findStartIndex(root2, (ConfigurationNode)startsWith2.getNode()));
        }
    }

    protected List<ConfigurationNode> createSubNodeList(ConfigurationNode node, NodeTest test) {
        NodeTypeTest typeTest;
        List<ConfigurationNode> children2 = node.getChildren();
        if (test == null) {
            return children2;
        }
        if (test instanceof NodeNameTest) {
            NodeNameTest nameTest = (NodeNameTest)test;
            QName name2 = nameTest.getNodeName();
            if (name2.getPrefix() == null) {
                if (nameTest.isWildcard()) {
                    return children2;
                }
                ArrayList<ConfigurationNode> result2 = new ArrayList<ConfigurationNode>();
                for (ConfigurationNode child : children2) {
                    if (!StringUtils.equals(name2.getName(), child.getName())) continue;
                    result2.add(child);
                }
                return result2;
            }
        } else if (test instanceof NodeTypeTest && ((typeTest = (NodeTypeTest)test).getNodeType() == 1 || typeTest.getNodeType() == 2)) {
            return children2;
        }
        return Collections.emptyList();
    }

    protected int findStartIndex(ConfigurationNode node, ConfigurationNode startNode) {
        for (int index2 = 0; index2 < node.getChildrenCount(); ++index2) {
            if (node.getChild(index2) != startNode) continue;
            return index2;
        }
        return -1;
    }
}

