/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.resolver;

import java.io.IOException;
import java.io.InputStream;
import java.net.FileNameMap;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.configuration.FileSystem;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.resolver.CatalogException;
import org.apache.xml.resolver.readers.CatalogReader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CatalogResolver
implements EntityResolver {
    private static final int DEBUG_ALL = 9;
    private static final int DEBUG_NORMAL = 4;
    private static final int DEBUG_NONE = 0;
    protected CatalogManager manager = new CatalogManager();
    protected FileSystem fs = FileSystem.getDefaultFileSystem();
    private org.apache.xml.resolver.tools.CatalogResolver resolver;
    private Log log;

    public CatalogResolver() {
        this.manager.setIgnoreMissingProperties(true);
        this.manager.setUseStaticCatalog(false);
        this.manager.setFileSystem(this.fs);
        this.setLogger(null);
    }

    public void setCatalogFiles(String catalogs) {
        this.manager.setCatalogFiles(catalogs);
    }

    public void setFileSystem(FileSystem fileSystem) {
        this.fs = fileSystem;
        this.manager.setFileSystem(fileSystem);
    }

    public void setBaseDir(String baseDir) {
        this.manager.setBaseDir(baseDir);
    }

    public void setSubstitutor(StrSubstitutor substitutor) {
        this.manager.setSubstitutor(substitutor);
    }

    public void setDebug(boolean debug) {
        if (debug) {
            this.manager.setVerbosity(9);
        } else {
            this.manager.setVerbosity(0);
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        String resolved = this.getResolver().getResolvedEntity(publicId, systemId);
        if (resolved != null) {
            String badFilePrefix = "file://";
            String correctFilePrefix = "file:///";
            if (resolved.startsWith(badFilePrefix) && !resolved.startsWith(correctFilePrefix)) {
                resolved = correctFilePrefix + resolved.substring(badFilePrefix.length());
            }
            try {
                InputStream is = this.fs.getInputStream(null, resolved);
                InputSource iSource = new InputSource(resolved);
                iSource.setPublicId(publicId);
                iSource.setByteStream(is);
                return iSource;
            }
            catch (Exception e) {
                this.log.warn("Failed to create InputSource for " + resolved + " (" + e.toString() + ")");
                return null;
            }
        }
        return null;
    }

    public Log getLogger() {
        return this.log;
    }

    public void setLogger(Log log2) {
        this.log = log2 != null ? log2 : LogFactory.getLog(CatalogResolver.class);
    }

    private synchronized org.apache.xml.resolver.tools.CatalogResolver getResolver() {
        if (this.resolver == null) {
            this.resolver = new org.apache.xml.resolver.tools.CatalogResolver((org.apache.xml.resolver.CatalogManager)this.manager);
        }
        return this.resolver;
    }

    public static class Catalog
    extends org.apache.xml.resolver.Catalog {
        private FileSystem fs;
        private FileNameMap fileNameMap = URLConnection.getFileNameMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void loadSystemCatalogs() throws IOException {
            this.fs = ((CatalogManager)this.catalogManager).getFileSystem();
            String base = ((CatalogManager)this.catalogManager).getBaseDir();
            Vector catalogs = this.catalogManager.getCatalogFiles();
            if (catalogs != null) {
                for (int count2 = 0; count2 < catalogs.size(); ++count2) {
                    String fileName = (String)catalogs.elementAt(count2);
                    URL url = null;
                    InputStream is = null;
                    try {
                        url = ConfigurationUtils.locate(this.fs, base, fileName);
                        if (url != null) {
                            is = this.fs.getInputStream(url);
                        }
                    }
                    catch (ConfigurationException ce) {
                        String name2 = url == null ? fileName : url.toString();
                        this.catalogManager.debug.message(9, "Unable to get input stream for " + name2 + ". " + ce.getMessage());
                    }
                    if (is != null) {
                        String mimeType = this.fileNameMap.getContentTypeFor(fileName);
                        try {
                            if (mimeType != null) {
                                this.parseCatalog(mimeType, is);
                                continue;
                            }
                        }
                        catch (Exception ex) {
                            this.catalogManager.debug.message(9, "Exception caught parsing input stream for " + fileName + ". " + ex.getMessage());
                        }
                        finally {
                            is.close();
                        }
                    }
                    this.parseCatalog(base, fileName);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void parseCatalog(String baseDir, String fileName) throws IOException {
            this.catalogCwd = this.base = ConfigurationUtils.locate(this.fs, baseDir, fileName);
            this.default_override = this.catalogManager.getPreferPublic();
            this.catalogManager.debug.message(4, "Parse catalog: " + fileName);
            boolean parsed = false;
            for (int count2 = 0; !parsed && count2 < this.readerArr.size(); ++count2) {
                InputStream inStream;
                CatalogReader reader = (CatalogReader)this.readerArr.get(count2);
                try {
                    inStream = this.fs.getInputStream(this.base);
                }
                catch (Exception ex) {
                    this.catalogManager.debug.message(4, "Unable to access " + this.base + ex.getMessage());
                    break;
                }
                try {
                    reader.readCatalog((org.apache.xml.resolver.Catalog)this, inStream);
                    parsed = true;
                    continue;
                }
                catch (CatalogException ce) {
                    this.catalogManager.debug.message(4, "Parse failed for " + fileName + ce.getMessage());
                    if (ce.getExceptionType() != 7) continue;
                    break;
                }
                finally {
                    try {
                        inStream.close();
                    }
                    catch (IOException ioe) {
                        inStream = null;
                    }
                }
            }
            if (parsed) {
                this.parsePendingCatalogs();
            }
        }

        protected String normalizeURI(String uriref) {
            StrSubstitutor substitutor = ((CatalogManager)this.catalogManager).getStrSubstitutor();
            String resolved = substitutor != null ? substitutor.replace(uriref) : uriref;
            return super.normalizeURI(resolved);
        }
    }

    public static class CatalogManager
    extends org.apache.xml.resolver.CatalogManager {
        private static org.apache.xml.resolver.Catalog staticCatalog;
        private FileSystem fs;
        private String baseDir = System.getProperty("user.dir");
        private StrSubstitutor substitutor;

        public void setFileSystem(FileSystem fileSystem) {
            this.fs = fileSystem;
        }

        public FileSystem getFileSystem() {
            return this.fs;
        }

        public void setBaseDir(String baseDir) {
            if (baseDir != null) {
                this.baseDir = baseDir;
            }
        }

        public String getBaseDir() {
            return this.baseDir;
        }

        public void setSubstitutor(StrSubstitutor substitutor) {
            this.substitutor = substitutor;
        }

        public StrSubstitutor getStrSubstitutor() {
            return this.substitutor;
        }

        public org.apache.xml.resolver.Catalog getPrivateCatalog() {
            org.apache.xml.resolver.Catalog catalog = staticCatalog;
            if (catalog == null || !this.getUseStaticCatalog()) {
                try {
                    catalog = new Catalog();
                    catalog.setCatalogManager((org.apache.xml.resolver.CatalogManager)this);
                    catalog.setupReaders();
                    catalog.loadSystemCatalogs();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (this.getUseStaticCatalog()) {
                    staticCatalog = catalog;
                }
            }
            return catalog;
        }

        public org.apache.xml.resolver.Catalog getCatalog() {
            return this.getPrivateCatalog();
        }
    }
}

