/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.reloading;

import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.FileSystem;
import org.apache.commons.configuration.FileSystemBased;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;

public class VFSFileChangedReloadingStrategy
implements ReloadingStrategy {
    private static final int DEFAULT_REFRESH_DELAY = 5000;
    protected FileConfiguration configuration;
    protected long lastModified;
    protected long lastChecked;
    protected long refreshDelay = 5000L;
    private boolean reloading;
    private Log log = LogFactory.getLog(this.getClass());

    public void setConfiguration(FileConfiguration configuration) {
        this.configuration = configuration;
    }

    public void init() {
        if (this.configuration.getURL() == null && this.configuration.getFileName() == null) {
            return;
        }
        if (this.configuration == null) {
            throw new IllegalStateException("No configuration has been set for this strategy");
        }
        this.updateLastModified();
    }

    public boolean reloadingRequired() {
        long now;
        if (!this.reloading && (now = System.currentTimeMillis()) > this.lastChecked + this.refreshDelay) {
            this.lastChecked = now;
            if (this.hasChanged()) {
                this.reloading = true;
            }
        }
        return this.reloading;
    }

    public void reloadingPerformed() {
        this.updateLastModified();
    }

    public long getRefreshDelay() {
        return this.refreshDelay;
    }

    public void setRefreshDelay(long refreshDelay) {
        this.refreshDelay = refreshDelay;
    }

    protected void updateLastModified() {
        FileObject file = this.getFile();
        if (file != null) {
            try {
                this.lastModified = file.getContent().getLastModifiedTime();
            }
            catch (FileSystemException fse) {
                this.log.error("Unable to get last modified time for" + file.getName().getURI());
            }
        }
        this.reloading = false;
    }

    protected boolean hasChanged() {
        FileObject file = this.getFile();
        try {
            if (file == null || !file.exists()) {
                return false;
            }
            return file.getContent().getLastModifiedTime() > this.lastModified;
        }
        catch (FileSystemException ex) {
            this.log.error("Unable to get last modified time for" + file.getName().getURI());
            return false;
        }
    }

    protected FileObject getFile() {
        try {
            FileSystemManager fsManager = VFS.getManager();
            FileSystem fs = ((FileSystemBased)((Object)this.configuration)).getFileSystem();
            String uri2 = fs.getPath(null, this.configuration.getURL(), this.configuration.getBasePath(), this.configuration.getFileName());
            if (uri2 == null) {
                throw new ConfigurationRuntimeException("Unable to determine file to monitor");
            }
            return fsManager.resolveFile(uri2);
        }
        catch (FileSystemException fse) {
            String msg = "Unable to monitor " + this.configuration.getURL().toString();
            this.log.error(msg);
            throw new ConfigurationRuntimeException(msg, fse);
        }
    }
}

