/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.plist;

import java.io.File;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.configuration.AbstractHierarchicalFileConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLPropertyListConfiguration
extends AbstractHierarchicalFileConfiguration {
    private static final long serialVersionUID = -3162063751042475985L;
    private static final int INDENT_SIZE = 4;

    public XMLPropertyListConfiguration() {
        this.initRoot();
    }

    public XMLPropertyListConfiguration(HierarchicalConfiguration configuration) {
        super(configuration);
    }

    public XMLPropertyListConfiguration(String fileName) throws ConfigurationException {
        super(fileName);
    }

    public XMLPropertyListConfiguration(File file) throws ConfigurationException {
        super(file);
    }

    public XMLPropertyListConfiguration(URL url) throws ConfigurationException {
        super(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperty(String key, Object value2) {
        if (value2 instanceof byte[]) {
            this.fireEvent(3, key, value2, true);
            this.setDetailEvents(false);
            try {
                this.clearProperty(key);
                this.addPropertyDirect(key, value2);
            }
            finally {
                this.setDetailEvents(true);
            }
            this.fireEvent(3, key, value2, false);
        } else {
            super.setProperty(key, value2);
        }
    }

    @Override
    public void addProperty(String key, Object value2) {
        if (value2 instanceof byte[]) {
            this.fireEvent(1, key, value2, true);
            this.addPropertyDirect(key, value2);
            this.fireEvent(1, key, value2, false);
        } else {
            super.addProperty(key, value2);
        }
    }

    @Override
    public void load(Reader in) throws ConfigurationException {
        if (!(this.getRootNode() instanceof PListNode)) {
            this.initRoot();
        }
        EntityResolver resolver = new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) {
                return new InputSource(this.getClass().getClassLoader().getResourceAsStream("PropertyList-1.0.dtd"));
            }
        };
        XMLPropertyListHandler handler = new XMLPropertyListHandler(this.getRoot());
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            SAXParser parser2 = factory.newSAXParser();
            parser2.getXMLReader().setEntityResolver(resolver);
            parser2.getXMLReader().setContentHandler(handler);
            parser2.getXMLReader().parse(new InputSource(in));
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to parse the configuration file", e);
        }
    }

    @Override
    public void save(Writer out) throws ConfigurationException {
        PrintWriter writer = new PrintWriter(out);
        if (this.getEncoding() != null) {
            writer.println("<?xml version=\"1.0\" encoding=\"" + this.getEncoding() + "\"?>");
        } else {
            writer.println("<?xml version=\"1.0\"?>");
        }
        writer.println("<!DOCTYPE plist SYSTEM \"file://localhost/System/Library/DTDs/PropertyList.dtd\">");
        writer.println("<plist version=\"1.0\">");
        this.printNode(writer, 1, this.getRoot());
        writer.println("</plist>");
        writer.flush();
    }

    private void printNode(PrintWriter out, int indentLevel, ConfigurationNode node) {
        List<ConfigurationNode> children2;
        String padding2 = StringUtils.repeat(" ", indentLevel * 4);
        if (node.getName() != null) {
            out.println(padding2 + "<key>" + StringEscapeUtils.escapeXml(node.getName()) + "</key>");
        }
        if (!(children2 = node.getChildren()).isEmpty()) {
            out.println(padding2 + "<dict>");
            Iterator<ConfigurationNode> it = children2.iterator();
            while (it.hasNext()) {
                ConfigurationNode child = it.next();
                this.printNode(out, indentLevel + 1, child);
                if (!it.hasNext()) continue;
                out.println();
            }
            out.println(padding2 + "</dict>");
        } else if (node.getValue() == null) {
            out.println(padding2 + "<dict/>");
        } else {
            Object value2 = node.getValue();
            this.printValue(out, indentLevel, value2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printValue(PrintWriter out, int indentLevel, Object value2) {
        String padding2 = StringUtils.repeat(" ", indentLevel * 4);
        if (value2 instanceof Date) {
            DateFormat dateFormat = PListNode.FORMAT;
            synchronized (dateFormat) {
                out.println(padding2 + "<date>" + PListNode.FORMAT.format((Date)value2) + "</date>");
            }
        } else if (value2 instanceof Calendar) {
            this.printValue(out, indentLevel, ((Calendar)value2).getTime());
        } else if (value2 instanceof Number) {
            if (value2 instanceof Double || value2 instanceof Float || value2 instanceof BigDecimal) {
                out.println(padding2 + "<real>" + value2.toString() + "</real>");
            } else {
                out.println(padding2 + "<integer>" + value2.toString() + "</integer>");
            }
        } else if (value2 instanceof Boolean) {
            if (((Boolean)value2).booleanValue()) {
                out.println(padding2 + "<true/>");
            } else {
                out.println(padding2 + "<false/>");
            }
        } else if (value2 instanceof List) {
            out.println(padding2 + "<array>");
            Iterator it = ((List)value2).iterator();
            while (it.hasNext()) {
                this.printValue(out, indentLevel + 1, it.next());
            }
            out.println(padding2 + "</array>");
        } else if (value2 instanceof HierarchicalConfiguration) {
            this.printNode(out, indentLevel, ((HierarchicalConfiguration)value2).getRoot());
        } else if (value2 instanceof Configuration) {
            out.println(padding2 + "<dict>");
            Configuration config = (Configuration)value2;
            Iterator<String> it = config.getKeys();
            while (it.hasNext()) {
                String key = it.next();
                HierarchicalConfiguration.Node node = new HierarchicalConfiguration.Node(key);
                node.setValue(config.getProperty(key));
                this.printNode(out, indentLevel + 1, node);
                if (!it.hasNext()) continue;
                out.println();
            }
            out.println(padding2 + "</dict>");
        } else if (value2 instanceof Map) {
            Map<String, Object> map2 = XMLPropertyListConfiguration.transformMap((Map)value2);
            this.printValue(out, indentLevel, new MapConfiguration(map2));
        } else if (value2 instanceof byte[]) {
            String base64 = new String(Base64.encodeBase64((byte[])((byte[])value2)));
            out.println(padding2 + "<data>" + StringEscapeUtils.escapeXml(base64) + "</data>");
        } else if (value2 != null) {
            out.println(padding2 + "<string>" + StringEscapeUtils.escapeXml(String.valueOf(value2)) + "</string>");
        } else {
            out.println(padding2 + "<string/>");
        }
    }

    private void initRoot() {
        this.setRootNode(new PListNode());
    }

    private static Map<String, Object> transformMap(Map<?, ?> src) {
        HashMap<String, Object> dest = new HashMap<String, Object>();
        for (Map.Entry<?, ?> e : src.entrySet()) {
            if (!(e.getKey() instanceof String)) continue;
            dest.put((String)e.getKey(), e.getValue());
        }
        return dest;
    }

    public static class ArrayNode
    extends PListNode {
        private static final long serialVersionUID = 5586544306664205835L;
        private List<Object> list = new ArrayList<Object>();

        public void addValue(Object value2) {
            this.list.add(value2);
        }

        public Object getValue() {
            return this.list;
        }
    }

    public static class PListNode
    extends HierarchicalConfiguration.Node {
        private static final long serialVersionUID = -7614060264754798317L;
        private static final DateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        private static final DateFormat GNUSTEP_FORMAT;

        public void addValue(Object value2) {
            if (this.getValue() == null) {
                this.setValue(value2);
            } else if (this.getValue() instanceof Collection) {
                Collection collection2 = (Collection)this.getValue();
                collection2.add(value2);
            } else {
                ArrayList<Object> list2 = new ArrayList<Object>();
                list2.add(this.getValue());
                list2.add(value2);
                this.setValue(list2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addDateValue(String value2) {
            block9: {
                try {
                    if (value2.indexOf(32) != -1) {
                        DateFormat dateFormat = GNUSTEP_FORMAT;
                        synchronized (dateFormat) {
                            this.addValue(GNUSTEP_FORMAT.parse(value2));
                            break block9;
                        }
                    }
                    DateFormat dateFormat = FORMAT;
                    synchronized (dateFormat) {
                        this.addValue(FORMAT.parse(value2));
                    }
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(String.format("'%s' cannot be parsed to a date!", value2), e);
                }
            }
        }

        public void addDataValue(String value2) {
            this.addValue(Base64.decodeBase64((byte[])value2.getBytes()));
        }

        public void addIntegerValue(String value2) {
            this.addValue(new BigInteger(value2));
        }

        public void addRealValue(String value2) {
            this.addValue(new BigDecimal(value2));
        }

        public void addTrueValue() {
            this.addValue(Boolean.TRUE);
        }

        public void addFalseValue() {
            this.addValue(Boolean.FALSE);
        }

        public void addList(ArrayNode node) {
            this.addValue(node.getValue());
        }

        static {
            FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
            GNUSTEP_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
        }
    }

    private class XMLPropertyListHandler
    extends DefaultHandler {
        private StringBuilder buffer = new StringBuilder();
        private List<HierarchicalConfiguration.Node> stack = new ArrayList<HierarchicalConfiguration.Node>();

        public XMLPropertyListHandler(HierarchicalConfiguration.Node root2) {
            this.push(root2);
        }

        private HierarchicalConfiguration.Node peek() {
            if (!this.stack.isEmpty()) {
                return this.stack.get(this.stack.size() - 1);
            }
            return null;
        }

        private HierarchicalConfiguration.Node pop() {
            if (!this.stack.isEmpty()) {
                return this.stack.remove(this.stack.size() - 1);
            }
            return null;
        }

        private void push(HierarchicalConfiguration.Node node) {
            this.stack.add(node);
        }

        public void startElement(String uri2, String localName, String qName, Attributes attributes2) throws SAXException {
            if ("array".equals(qName)) {
                this.push(new ArrayNode());
            } else if ("dict".equals(qName) && this.peek() instanceof ArrayNode) {
                XMLPropertyListConfiguration config = new XMLPropertyListConfiguration();
                ArrayNode node = (ArrayNode)this.peek();
                node.addValue(config);
                this.push(config.getRoot());
            }
        }

        public void endElement(String uri2, String localName, String qName) throws SAXException {
            if ("key".equals(qName)) {
                PListNode node = new PListNode();
                node.setName(this.buffer.toString());
                this.peek().addChild(node);
                this.push(node);
            } else if ("dict".equals(qName)) {
                this.pop();
            } else {
                if ("string".equals(qName)) {
                    ((PListNode)this.peek()).addValue(this.buffer.toString());
                } else if ("integer".equals(qName)) {
                    ((PListNode)this.peek()).addIntegerValue(this.buffer.toString());
                } else if ("real".equals(qName)) {
                    ((PListNode)this.peek()).addRealValue(this.buffer.toString());
                } else if ("true".equals(qName)) {
                    ((PListNode)this.peek()).addTrueValue();
                } else if ("false".equals(qName)) {
                    ((PListNode)this.peek()).addFalseValue();
                } else if ("data".equals(qName)) {
                    ((PListNode)this.peek()).addDataValue(this.buffer.toString());
                } else if ("date".equals(qName)) {
                    try {
                        ((PListNode)this.peek()).addDateValue(this.buffer.toString());
                    }
                    catch (IllegalArgumentException iex) {
                        XMLPropertyListConfiguration.this.getLogger().warn("Ignoring invalid date property " + this.buffer);
                    }
                } else if ("array".equals(qName)) {
                    ArrayNode array2 = (ArrayNode)this.pop();
                    ((PListNode)this.peek()).addList(array2);
                }
                if (!(this.peek() instanceof ArrayNode)) {
                    this.pop();
                }
            }
            this.buffer.setLength(0);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.buffer.append(ch, start, length);
        }
    }
}

