/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.beanutils;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationMap;
import org.apache.commons.configuration.SubsetConfiguration;
import org.apache.commons.configuration.beanutils.ConfigurationDynaClass;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationDynaBean
extends ConfigurationMap
implements DynaBean {
    private static final String PROPERTY_DELIMITER = ".";
    private static final Log LOG = LogFactory.getLog(ConfigurationDynaBean.class);

    public ConfigurationDynaBean(Configuration configuration) {
        super(configuration);
        if (LOG.isTraceEnabled()) {
            LOG.trace("ConfigurationDynaBean(" + configuration + ")");
        }
    }

    public void set(String name2, Object value2) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("set(" + name2 + "," + value2 + ")");
        }
        if (value2 == null) {
            throw new NullPointerException("Error trying to set property to null.");
        }
        if (value2 instanceof Collection) {
            Collection collection2 = (Collection)value2;
            for (Object v : collection2) {
                this.getConfiguration().addProperty(name2, v);
            }
        } else if (value2.getClass().isArray()) {
            int length = Array.getLength(value2);
            for (int i = 0; i < length; ++i) {
                this.getConfiguration().addProperty(name2, Array.get(value2, i));
            }
        } else {
            this.getConfiguration().setProperty(name2, value2);
        }
    }

    public Object get(String name2) {
        SubsetConfiguration subset;
        Object result2;
        if (LOG.isTraceEnabled()) {
            LOG.trace("get(" + name2 + ")");
        }
        if ((result2 = this.getConfiguration().getProperty(name2)) == null && !(subset = new SubsetConfiguration(this.getConfiguration(), name2, PROPERTY_DELIMITER)).isEmpty()) {
            result2 = new ConfigurationDynaBean(subset);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(name2 + "=[" + result2 + "]");
        }
        if (result2 == null) {
            throw new IllegalArgumentException("Property '" + name2 + "' does not exist.");
        }
        return result2;
    }

    public boolean contains(String name2, String key) {
        Configuration subset = this.getConfiguration().subset(name2);
        if (subset == null) {
            throw new IllegalArgumentException("Mapped property '" + name2 + "' does not exist.");
        }
        return subset.containsKey(key);
    }

    public Object get(String name2, int index2) {
        if (!this.checkIndexedProperty(name2)) {
            throw new IllegalArgumentException("Property '" + name2 + "' is not indexed.");
        }
        List<Object> list2 = this.getConfiguration().getList(name2);
        return list2.get(index2);
    }

    public Object get(String name2, String key) {
        Configuration subset = this.getConfiguration().subset(name2);
        if (subset == null) {
            throw new IllegalArgumentException("Mapped property '" + name2 + "' does not exist.");
        }
        return subset.getProperty(key);
    }

    public DynaClass getDynaClass() {
        return new ConfigurationDynaClass(this.getConfiguration());
    }

    public void remove(String name2, String key) {
        SubsetConfiguration subset = new SubsetConfiguration(this.getConfiguration(), name2, PROPERTY_DELIMITER);
        subset.setProperty(key, null);
    }

    public void set(String name2, int index2, Object value2) {
        if (!this.checkIndexedProperty(name2) && index2 > 0) {
            throw new IllegalArgumentException("Property '" + name2 + "' is not indexed.");
        }
        Object property = this.getConfiguration().getProperty(name2);
        if (property instanceof List) {
            List list2 = (List)property;
            list2.set(index2, value2);
            this.getConfiguration().setProperty(name2, list2);
        } else if (property.getClass().isArray()) {
            Array.set(property, index2, value2);
        } else if (index2 == 0) {
            this.getConfiguration().setProperty(name2, value2);
        }
    }

    public void set(String name2, String key, Object value2) {
        this.getConfiguration().setProperty(name2 + PROPERTY_DELIMITER + key, value2);
    }

    private boolean checkIndexedProperty(String name2) {
        Object property = this.getConfiguration().getProperty(name2);
        if (property == null) {
            throw new IllegalArgumentException("Property '" + name2 + "' does not exist.");
        }
        return property instanceof List || property.getClass().isArray();
    }
}

