/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.HierarchicalReloadableConfiguration;
import org.apache.commons.configuration.interpol.ConfigurationInterpolator;
import org.apache.commons.configuration.reloading.Reloadable;
import org.apache.commons.configuration.tree.ConfigurationNode;

public class SubnodeConfiguration
extends HierarchicalReloadableConfiguration {
    private static final long serialVersionUID = 3105734147019386480L;
    private HierarchicalConfiguration parent;
    private String subnodeKey;

    public SubnodeConfiguration(HierarchicalConfiguration parent, ConfigurationNode root2) {
        super(parent instanceof Reloadable ? ((Reloadable)((Object)parent)).getReloadLock() : null);
        if (parent == null) {
            throw new IllegalArgumentException("Parent configuration must not be null!");
        }
        if (root2 == null) {
            throw new IllegalArgumentException("Root node must not be null!");
        }
        this.setRootNode(root2);
        this.parent = parent;
        this.initFromParent(parent);
    }

    public HierarchicalConfiguration getParent() {
        return this.parent;
    }

    public String getSubnodeKey() {
        return this.subnodeKey;
    }

    public void setSubnodeKey(String subnodeKey) {
        this.subnodeKey = subnodeKey;
    }

    public ConfigurationNode getRootNode() {
        if (this.getSubnodeKey() != null) {
            try {
                List<ConfigurationNode> nodes2 = this.getParent().fetchNodeList(this.getSubnodeKey());
                if (nodes2.size() == 1) {
                    ConfigurationNode currentRoot = nodes2.get(0);
                    if (currentRoot != super.getRootNode()) {
                        this.fireEvent(12, null, null, true);
                        this.setRootNode(currentRoot);
                        this.fireEvent(12, null, null, false);
                    }
                    return currentRoot;
                }
                this.setSubnodeKey(null);
            }
            catch (Exception ex) {
                this.setSubnodeKey(null);
            }
        }
        return super.getRootNode();
    }

    protected SubnodeConfiguration createSubnodeConfiguration(ConfigurationNode node) {
        SubnodeConfiguration result2 = new SubnodeConfiguration(this.getParent(), node);
        this.getParent().registerSubnodeConfiguration(result2);
        return result2;
    }

    protected SubnodeConfiguration createSubnodeConfiguration(ConfigurationNode node, String subnodeKey) {
        SubnodeConfiguration result2 = this.createSubnodeConfiguration(node);
        if (this.getSubnodeKey() != null) {
            ArrayList<ConfigurationNode> lstPathToRoot = new ArrayList<ConfigurationNode>();
            ConfigurationNode top = super.getRootNode();
            for (ConfigurationNode nd = node; nd != top; nd = nd.getParentNode()) {
                lstPathToRoot.add(nd);
            }
            Collections.reverse(lstPathToRoot);
            String key = this.getSubnodeKey();
            for (ConfigurationNode pathNode : lstPathToRoot) {
                key = this.getParent().getExpressionEngine().nodeKey(pathNode, key);
            }
            result2.setSubnodeKey(key);
        }
        return result2;
    }

    protected HierarchicalConfiguration.Node createNode(String name2) {
        return this.getParent().createNode(name2);
    }

    protected void initFromParent(HierarchicalConfiguration parentConfig) {
        this.setExpressionEngine(parentConfig.getExpressionEngine());
        this.setListDelimiter(parentConfig.getListDelimiter());
        this.setDelimiterParsingDisabled(parentConfig.isDelimiterParsingDisabled());
        this.setThrowExceptionOnMissing(parentConfig.isThrowExceptionOnMissing());
    }

    protected ConfigurationInterpolator createInterpolator() {
        ConfigurationInterpolator interpolator = super.createInterpolator();
        interpolator.setParentInterpolator(this.getParent().getInterpolator());
        return interpolator;
    }
}

