/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class HierarchicalConfigurationConverter {
    HierarchicalConfigurationConverter() {
    }

    public void process(Configuration config) {
        if (config != null) {
            ConfigurationKey keyEmpty;
            ConfigurationKey keyLast = keyEmpty = new ConfigurationKey();
            HashSet<String> keySet2 = new HashSet<String>();
            Iterator<String> it = config.getKeys();
            while (it.hasNext()) {
                String key = it.next();
                if (keySet2.contains(key)) continue;
                ConfigurationKey keyAct = new ConfigurationKey(key);
                this.closeElements(keyLast, keyAct);
                String elem2 = this.openElements(keyLast, keyAct, config, keySet2);
                this.fireValue(elem2, config.getProperty(key));
                keyLast = keyAct;
            }
            this.closeElements(keyLast, keyEmpty);
        }
    }

    protected abstract void elementStart(String var1, Object var2);

    protected abstract void elementEnd(String var1);

    protected void closeElements(ConfigurationKey keyLast, ConfigurationKey keyAct) {
        ConfigurationKey keyDiff = keyAct.differenceKey(keyLast);
        Iterator<String> it = this.reverseIterator(keyDiff);
        if (it.hasNext()) {
            it.next();
        }
        while (it.hasNext()) {
            this.elementEnd(it.next());
        }
    }

    protected Iterator<String> reverseIterator(ConfigurationKey key) {
        ArrayList<String> list2 = new ArrayList<String>();
        ConfigurationKey.KeyIterator it = key.iterator();
        while (it.hasNext()) {
            list2.add(it.nextKey());
        }
        Collections.reverse(list2);
        return list2.iterator();
    }

    protected String openElements(ConfigurationKey keyLast, ConfigurationKey keyAct, Configuration config, Set<String> keySet2) {
        ConfigurationKey.KeyIterator it = keyLast.differenceKey(keyAct).iterator();
        ConfigurationKey k = keyLast.commonKey(keyAct);
        it.nextKey();
        while (it.hasNext()) {
            k.append(it.currentKey(true));
            this.elementStart(it.currentKey(true), config.getProperty(k.toString()));
            keySet2.add(k.toString());
            it.nextKey();
        }
        return it.currentKey(true);
    }

    protected void fireValue(String name2, Object value2) {
        if (value2 instanceof Collection) {
            Collection valueCol = (Collection)value2;
            for (Object v : valueCol) {
                this.fireValue(name2, v);
            }
        } else {
            this.elementStart(name2, value2);
            this.elementEnd(name2);
        }
    }
}

