/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.CombinedConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.configuration.event.ConfigurationErrorListener;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.apache.commons.configuration.interpol.ConfigurationInterpolator;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.ExpressionEngine;
import org.apache.commons.configuration.tree.NodeCombiner;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicCombinedConfiguration
extends CombinedConfiguration {
    private static ThreadLocal<Boolean> recursive = new ThreadLocal<Boolean>(){

        @Override
        protected synchronized Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private final ConcurrentMap<String, CombinedConfiguration> configs = new ConcurrentHashMap<String, CombinedConfiguration>();
    private List<ConfigData> configurations = new ArrayList<ConfigData>();
    private Map<String, AbstractConfiguration> namedConfigurations = new HashMap<String, AbstractConfiguration>();
    private String keyPattern;
    private NodeCombiner nodeCombiner;
    private String loggerName = DynamicCombinedConfiguration.class.getName();
    private StrSubstitutor localSubst = new StrSubstitutor(new ConfigurationInterpolator());

    public DynamicCombinedConfiguration(NodeCombiner comb) {
        this.setNodeCombiner(comb);
        this.setIgnoreReloadExceptions(false);
        this.setLogger(LogFactory.getLog(DynamicCombinedConfiguration.class));
    }

    public DynamicCombinedConfiguration() {
        this.setIgnoreReloadExceptions(false);
        this.setLogger(LogFactory.getLog(DynamicCombinedConfiguration.class));
    }

    public void setKeyPattern(String pattern) {
        this.keyPattern = pattern;
    }

    public String getKeyPattern() {
        return this.keyPattern;
    }

    public void setLoggerName(String name2) {
        this.loggerName = name2;
    }

    @Override
    public NodeCombiner getNodeCombiner() {
        return this.nodeCombiner;
    }

    @Override
    public void setNodeCombiner(NodeCombiner nodeCombiner) {
        if (nodeCombiner == null) {
            throw new IllegalArgumentException("Node combiner must not be null!");
        }
        this.nodeCombiner = nodeCombiner;
        this.invalidateAll();
    }

    @Override
    public void addConfiguration(AbstractConfiguration config, String name2, String at) {
        ConfigData cd = new ConfigData(config, name2, at);
        this.configurations.add(cd);
        if (name2 != null) {
            this.namedConfigurations.put(name2, config);
        }
    }

    @Override
    public int getNumberOfConfigurations() {
        return this.configurations.size();
    }

    @Override
    public Configuration getConfiguration(int index2) {
        ConfigData cd = this.configurations.get(index2);
        return cd.getConfiguration();
    }

    @Override
    public Configuration getConfiguration(String name2) {
        return this.namedConfigurations.get(name2);
    }

    @Override
    public Set<String> getConfigurationNames() {
        return this.namedConfigurations.keySet();
    }

    @Override
    public Configuration removeConfiguration(String name2) {
        Configuration conf = this.getConfiguration(name2);
        if (conf != null) {
            this.removeConfiguration(conf);
        }
        return conf;
    }

    @Override
    public boolean removeConfiguration(Configuration config) {
        for (int index2 = 0; index2 < this.getNumberOfConfigurations(); ++index2) {
            if (this.configurations.get(index2).getConfiguration() != config) continue;
            this.removeConfigurationAt(index2);
        }
        return super.removeConfiguration(config);
    }

    @Override
    public Configuration removeConfigurationAt(int index2) {
        ConfigData cd = this.configurations.remove(index2);
        if (cd.getName() != null) {
            this.namedConfigurations.remove(cd.getName());
        }
        return super.removeConfigurationAt(index2);
    }

    @Override
    public ConfigurationNode getRootNode() {
        return this.getCurrentConfig().getRootNode();
    }

    @Override
    public void setRootNode(ConfigurationNode rootNode) {
        if (this.configs != null) {
            this.getCurrentConfig().setRootNode(rootNode);
        } else {
            super.setRootNode(rootNode);
        }
    }

    @Override
    public void addProperty(String key, Object value2) {
        this.getCurrentConfig().addProperty(key, value2);
    }

    @Override
    public void clear() {
        if (this.configs != null) {
            this.getCurrentConfig().clear();
        }
    }

    @Override
    public void clearProperty(String key) {
        this.getCurrentConfig().clearProperty(key);
    }

    @Override
    public boolean containsKey(String key) {
        return this.getCurrentConfig().containsKey(key);
    }

    @Override
    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue2) {
        return this.getCurrentConfig().getBigDecimal(key, defaultValue2);
    }

    @Override
    public BigDecimal getBigDecimal(String key) {
        return this.getCurrentConfig().getBigDecimal(key);
    }

    @Override
    public BigInteger getBigInteger(String key, BigInteger defaultValue2) {
        return this.getCurrentConfig().getBigInteger(key, defaultValue2);
    }

    @Override
    public BigInteger getBigInteger(String key) {
        return this.getCurrentConfig().getBigInteger(key);
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue2) {
        return this.getCurrentConfig().getBoolean(key, defaultValue2);
    }

    @Override
    public Boolean getBoolean(String key, Boolean defaultValue2) {
        return this.getCurrentConfig().getBoolean(key, defaultValue2);
    }

    @Override
    public boolean getBoolean(String key) {
        return this.getCurrentConfig().getBoolean(key);
    }

    @Override
    public byte getByte(String key, byte defaultValue2) {
        return this.getCurrentConfig().getByte(key, defaultValue2);
    }

    @Override
    public Byte getByte(String key, Byte defaultValue2) {
        return this.getCurrentConfig().getByte(key, defaultValue2);
    }

    @Override
    public byte getByte(String key) {
        return this.getCurrentConfig().getByte(key);
    }

    @Override
    public double getDouble(String key, double defaultValue2) {
        return this.getCurrentConfig().getDouble(key, defaultValue2);
    }

    @Override
    public Double getDouble(String key, Double defaultValue2) {
        return this.getCurrentConfig().getDouble(key, defaultValue2);
    }

    @Override
    public double getDouble(String key) {
        return this.getCurrentConfig().getDouble(key);
    }

    @Override
    public float getFloat(String key, float defaultValue2) {
        return this.getCurrentConfig().getFloat(key, defaultValue2);
    }

    @Override
    public Float getFloat(String key, Float defaultValue2) {
        return this.getCurrentConfig().getFloat(key, defaultValue2);
    }

    @Override
    public float getFloat(String key) {
        return this.getCurrentConfig().getFloat(key);
    }

    @Override
    public int getInt(String key, int defaultValue2) {
        return this.getCurrentConfig().getInt(key, defaultValue2);
    }

    @Override
    public int getInt(String key) {
        return this.getCurrentConfig().getInt(key);
    }

    @Override
    public Integer getInteger(String key, Integer defaultValue2) {
        return this.getCurrentConfig().getInteger(key, defaultValue2);
    }

    @Override
    public Iterator<String> getKeys() {
        return this.getCurrentConfig().getKeys();
    }

    @Override
    public Iterator<String> getKeys(String prefix) {
        return this.getCurrentConfig().getKeys(prefix);
    }

    @Override
    public List<Object> getList(String key, List<?> defaultValue2) {
        return this.getCurrentConfig().getList(key, defaultValue2);
    }

    @Override
    public List<Object> getList(String key) {
        return this.getCurrentConfig().getList(key);
    }

    @Override
    public long getLong(String key, long defaultValue2) {
        return this.getCurrentConfig().getLong(key, defaultValue2);
    }

    @Override
    public Long getLong(String key, Long defaultValue2) {
        return this.getCurrentConfig().getLong(key, defaultValue2);
    }

    @Override
    public long getLong(String key) {
        return this.getCurrentConfig().getLong(key);
    }

    @Override
    public Properties getProperties(String key) {
        return this.getCurrentConfig().getProperties(key);
    }

    @Override
    public Object getProperty(String key) {
        return this.getCurrentConfig().getProperty(key);
    }

    @Override
    public short getShort(String key, short defaultValue2) {
        return this.getCurrentConfig().getShort(key, defaultValue2);
    }

    @Override
    public Short getShort(String key, Short defaultValue2) {
        return this.getCurrentConfig().getShort(key, defaultValue2);
    }

    @Override
    public short getShort(String key) {
        return this.getCurrentConfig().getShort(key);
    }

    @Override
    public String getString(String key, String defaultValue2) {
        return this.getCurrentConfig().getString(key, defaultValue2);
    }

    @Override
    public String getString(String key) {
        return this.getCurrentConfig().getString(key);
    }

    @Override
    public String[] getStringArray(String key) {
        return this.getCurrentConfig().getStringArray(key);
    }

    @Override
    public boolean isEmpty() {
        return this.getCurrentConfig().isEmpty();
    }

    @Override
    public void setProperty(String key, Object value2) {
        if (this.configs != null) {
            this.getCurrentConfig().setProperty(key, value2);
        }
    }

    @Override
    public Configuration subset(String prefix) {
        return this.getCurrentConfig().subset(prefix);
    }

    @Override
    public HierarchicalConfiguration.Node getRoot() {
        return this.getCurrentConfig().getRoot();
    }

    @Override
    public void setRoot(HierarchicalConfiguration.Node node) {
        if (this.configs != null) {
            this.getCurrentConfig().setRoot(node);
        } else {
            super.setRoot(node);
        }
    }

    @Override
    public ExpressionEngine getExpressionEngine() {
        return super.getExpressionEngine();
    }

    @Override
    public void setExpressionEngine(ExpressionEngine expressionEngine) {
        super.setExpressionEngine(expressionEngine);
    }

    @Override
    public void addNodes(String key, Collection<? extends ConfigurationNode> nodes2) {
        this.getCurrentConfig().addNodes(key, nodes2);
    }

    @Override
    public SubnodeConfiguration configurationAt(String key, boolean supportUpdates) {
        return this.getCurrentConfig().configurationAt(key, supportUpdates);
    }

    @Override
    public SubnodeConfiguration configurationAt(String key) {
        return this.getCurrentConfig().configurationAt(key);
    }

    @Override
    public List<HierarchicalConfiguration> configurationsAt(String key) {
        return this.getCurrentConfig().configurationsAt(key);
    }

    @Override
    public void clearTree(String key) {
        this.getCurrentConfig().clearTree(key);
    }

    @Override
    public int getMaxIndex(String key) {
        return this.getCurrentConfig().getMaxIndex(key);
    }

    @Override
    public Configuration interpolatedConfiguration() {
        return this.getCurrentConfig().interpolatedConfiguration();
    }

    @Override
    public Configuration getSource(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key must not be null!");
        }
        return this.getCurrentConfig().getSource(key);
    }

    @Override
    public void addConfigurationListener(ConfigurationListener l) {
        super.addConfigurationListener(l);
        for (CombinedConfiguration cc : this.configs.values()) {
            cc.addConfigurationListener(l);
        }
    }

    @Override
    public boolean removeConfigurationListener(ConfigurationListener l) {
        for (CombinedConfiguration cc : this.configs.values()) {
            cc.removeConfigurationListener(l);
        }
        return super.removeConfigurationListener(l);
    }

    @Override
    public Collection<ConfigurationListener> getConfigurationListeners() {
        return super.getConfigurationListeners();
    }

    @Override
    public void clearConfigurationListeners() {
        for (CombinedConfiguration cc : this.configs.values()) {
            cc.clearConfigurationListeners();
        }
        super.clearConfigurationListeners();
    }

    @Override
    public void addErrorListener(ConfigurationErrorListener l) {
        for (CombinedConfiguration cc : this.configs.values()) {
            cc.addErrorListener(l);
        }
        super.addErrorListener(l);
    }

    @Override
    public boolean removeErrorListener(ConfigurationErrorListener l) {
        for (CombinedConfiguration cc : this.configs.values()) {
            cc.removeErrorListener(l);
        }
        return super.removeErrorListener(l);
    }

    @Override
    public void clearErrorListeners() {
        for (CombinedConfiguration cc : this.configs.values()) {
            cc.clearErrorListeners();
        }
        super.clearErrorListeners();
    }

    @Override
    public Collection<ConfigurationErrorListener> getErrorListeners() {
        return super.getErrorListeners();
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public void invalidate() {
        this.getCurrentConfig().invalidate();
    }

    public void invalidateAll() {
        if (this.configs == null) {
            return;
        }
        for (CombinedConfiguration cc : this.configs.values()) {
            cc.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object resolveContainerStore(String key) {
        if (recursive.get().booleanValue()) {
            return null;
        }
        recursive.set(Boolean.TRUE);
        try {
            Object object = super.resolveContainerStore(key);
            return object;
        }
        finally {
            recursive.set(Boolean.FALSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CombinedConfiguration getCurrentConfig() {
        String key = this.localSubst.replace(this.keyPattern);
        CombinedConfiguration config = (CombinedConfiguration)this.configs.get(key);
        if (config == null) {
            ConcurrentMap<String, CombinedConfiguration> concurrentMap = this.configs;
            synchronized (concurrentMap) {
                config = (CombinedConfiguration)this.configs.get(key);
                if (config == null) {
                    Log log2;
                    config = new CombinedConfiguration(this.getNodeCombiner());
                    if (this.loggerName != null && (log2 = LogFactory.getLog(this.loggerName)) != null) {
                        config.setLogger(log2);
                    }
                    config.setIgnoreReloadExceptions(this.isIgnoreReloadExceptions());
                    config.setExpressionEngine(this.getExpressionEngine());
                    config.setDelimiterParsingDisabled(this.isDelimiterParsingDisabled());
                    config.setConversionExpressionEngine(this.getConversionExpressionEngine());
                    config.setListDelimiter(this.getListDelimiter());
                    for (ConfigurationErrorListener configurationErrorListener : this.getErrorListeners()) {
                        config.addErrorListener(configurationErrorListener);
                    }
                    for (ConfigurationListener configurationListener : this.getConfigurationListeners()) {
                        config.addConfigurationListener(configurationListener);
                    }
                    config.setForceReloadCheck(this.isForceReloadCheck());
                    for (ConfigData configData : this.configurations) {
                        config.addConfiguration(configData.getConfiguration(), configData.getName(), configData.getAt());
                    }
                    this.configs.put(key, config);
                }
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Returning config for " + key + ": " + config);
        }
        return config;
    }

    static class ConfigData {
        private AbstractConfiguration configuration;
        private String name;
        private String at;

        public ConfigData(AbstractConfiguration config, String n, String at) {
            this.configuration = config;
            this.name = n;
            this.at = at;
        }

        public AbstractConfiguration getConfiguration() {
            return this.configuration;
        }

        public String getName() {
            return this.name;
        }

        public String getAt() {
            return this.at;
        }
    }
}

