/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.commons.collections.iterators.AbstractIteratorDecorator;
import org.apache.commons.collections.iterators.AbstractListIteratorDecorator;
import org.apache.commons.collections.list.AbstractSerializableListDecorator;
import org.apache.commons.collections.set.UnmodifiableSet;

public class SetUniqueList
extends AbstractSerializableListDecorator {
    private static final long serialVersionUID = 7196982186153478694L;
    protected final Set set;
    static /* synthetic */ Class class$java$util$HashSet;

    public static SetUniqueList decorate(List list2) {
        if (list2 == null) {
            throw new IllegalArgumentException("List must not be null");
        }
        if (list2.isEmpty()) {
            return new SetUniqueList(list2, new HashSet());
        }
        ArrayList temp = new ArrayList(list2);
        list2.clear();
        SetUniqueList sl = new SetUniqueList(list2, new HashSet());
        sl.addAll((Collection)temp);
        return sl;
    }

    protected SetUniqueList(List list2, Set set2) {
        super(list2);
        if (set2 == null) {
            throw new IllegalArgumentException("Set must not be null");
        }
        this.set = set2;
    }

    public Set asSet() {
        return UnmodifiableSet.decorate(this.set);
    }

    public boolean add(Object object) {
        int sizeBefore = this.size();
        this.add(this.size(), object);
        return sizeBefore != this.size();
    }

    public void add(int index2, Object object) {
        if (!this.set.contains(object)) {
            super.add(index2, object);
            this.set.add(object);
        }
    }

    public boolean addAll(Collection coll) {
        return this.addAll(this.size(), coll);
    }

    public boolean addAll(int index2, Collection coll) {
        int sizeBefore = this.size();
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            int sizeBeforeAddNext = this.size();
            this.add(index2, it.next());
            if (sizeBeforeAddNext == this.size()) continue;
            ++index2;
        }
        return sizeBefore != this.size();
    }

    public Object set(int index2, Object object) {
        int pos = this.indexOf(object);
        Object removed = super.set(index2, object);
        if (pos != -1 && pos != index2) {
            super.remove(pos);
        }
        this.set.remove(removed);
        this.set.add(object);
        return removed;
    }

    public boolean remove(Object object) {
        boolean result2 = super.remove(object);
        this.set.remove(object);
        return result2;
    }

    public Object remove(int index2) {
        Object result2 = super.remove(index2);
        this.set.remove(result2);
        return result2;
    }

    public boolean removeAll(Collection coll) {
        boolean result2 = super.removeAll(coll);
        this.set.removeAll(coll);
        return result2;
    }

    public boolean retainAll(Collection coll) {
        boolean result2 = super.retainAll(coll);
        this.set.retainAll(coll);
        return result2;
    }

    public void clear() {
        super.clear();
        this.set.clear();
    }

    public boolean contains(Object object) {
        return this.set.contains(object);
    }

    public boolean containsAll(Collection coll) {
        return this.set.containsAll(coll);
    }

    public Iterator iterator() {
        return new SetListIterator(super.iterator(), this.set);
    }

    public ListIterator listIterator() {
        return new SetListListIterator(super.listIterator(), this.set);
    }

    public ListIterator listIterator(int index2) {
        return new SetListListIterator(super.listIterator(index2), this.set);
    }

    public List subList(int fromIndex, int toIndex) {
        List superSubList = super.subList(fromIndex, toIndex);
        Set subSet = this.createSetBasedOnList(this.set, superSubList);
        return new SetUniqueList(superSubList, subSet);
    }

    protected Set createSetBasedOnList(Set set2, List list2) {
        Set subSet = null;
        if (set2.getClass().equals(class$java$util$HashSet == null ? (class$java$util$HashSet = SetUniqueList.class$("java.util.HashSet")) : class$java$util$HashSet)) {
            subSet = new HashSet();
        } else {
            try {
                subSet = (Set)set2.getClass().newInstance();
            }
            catch (InstantiationException ie) {
                subSet = new HashSet();
            }
            catch (IllegalAccessException iae) {
                subSet = new HashSet();
            }
        }
        subSet.addAll(list2);
        return subSet;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class SetListListIterator
    extends AbstractListIteratorDecorator {
        protected final Set set;
        protected Object last = null;

        protected SetListListIterator(ListIterator it, Set set2) {
            super(it);
            this.set = set2;
        }

        public Object next() {
            this.last = super.next();
            return this.last;
        }

        public Object previous() {
            this.last = super.previous();
            return this.last;
        }

        public void remove() {
            super.remove();
            this.set.remove(this.last);
            this.last = null;
        }

        public void add(Object object) {
            if (!this.set.contains(object)) {
                super.add(object);
                this.set.add(object);
            }
        }

        public void set(Object object) {
            throw new UnsupportedOperationException("ListIterator does not support set");
        }
    }

    static class SetListIterator
    extends AbstractIteratorDecorator {
        protected final Set set;
        protected Object last = null;

        protected SetListIterator(Iterator it, Set set2) {
            super(it);
            this.set = set2;
        }

        public Object next() {
            this.last = super.next();
            return this.last;
        }

        public void remove() {
            super.remove();
            this.set.remove(this.last);
            this.last = null;
        }
    }
}

