/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Bag;
import org.apache.commons.collections.BoundedCollection;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.collection.PredicatedCollection;
import org.apache.commons.collections.collection.SynchronizedCollection;
import org.apache.commons.collections.collection.TransformedCollection;
import org.apache.commons.collections.collection.TypedCollection;
import org.apache.commons.collections.collection.UnmodifiableBoundedCollection;
import org.apache.commons.collections.collection.UnmodifiableCollection;

public class CollectionUtils {
    private static Integer INTEGER_ONE = new Integer(1);
    public static final Collection EMPTY_COLLECTION = UnmodifiableCollection.decorate(new ArrayList());

    public static Collection union(Collection a, Collection b) {
        ArrayList list2 = new ArrayList();
        Map mapa = CollectionUtils.getCardinalityMap(a);
        Map mapb = CollectionUtils.getCardinalityMap(b);
        HashSet elts = new HashSet(a);
        elts.addAll(b);
        Iterator it = elts.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            int m = Math.max(CollectionUtils.getFreq(obj, mapa), CollectionUtils.getFreq(obj, mapb));
            for (int i = 0; i < m; ++i) {
                list2.add(obj);
            }
        }
        return list2;
    }

    public static Collection intersection(Collection a, Collection b) {
        ArrayList list2 = new ArrayList();
        Map mapa = CollectionUtils.getCardinalityMap(a);
        Map mapb = CollectionUtils.getCardinalityMap(b);
        HashSet elts = new HashSet(a);
        elts.addAll(b);
        Iterator it = elts.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            int m = Math.min(CollectionUtils.getFreq(obj, mapa), CollectionUtils.getFreq(obj, mapb));
            for (int i = 0; i < m; ++i) {
                list2.add(obj);
            }
        }
        return list2;
    }

    public static Collection disjunction(Collection a, Collection b) {
        ArrayList list2 = new ArrayList();
        Map mapa = CollectionUtils.getCardinalityMap(a);
        Map mapb = CollectionUtils.getCardinalityMap(b);
        HashSet elts = new HashSet(a);
        elts.addAll(b);
        Iterator it = elts.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            int m = Math.max(CollectionUtils.getFreq(obj, mapa), CollectionUtils.getFreq(obj, mapb)) - Math.min(CollectionUtils.getFreq(obj, mapa), CollectionUtils.getFreq(obj, mapb));
            for (int i = 0; i < m; ++i) {
                list2.add(obj);
            }
        }
        return list2;
    }

    public static Collection subtract(Collection a, Collection b) {
        ArrayList list2 = new ArrayList(a);
        Iterator it = b.iterator();
        while (it.hasNext()) {
            list2.remove(it.next());
        }
        return list2;
    }

    public static boolean containsAny(Collection coll1, Collection coll2) {
        if (coll1.size() < coll2.size()) {
            Iterator it = coll1.iterator();
            while (it.hasNext()) {
                if (!coll2.contains(it.next())) continue;
                return true;
            }
        } else {
            Iterator it = coll2.iterator();
            while (it.hasNext()) {
                if (!coll1.contains(it.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static Map getCardinalityMap(Collection coll) {
        HashMap count2 = new HashMap();
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            Integer c = (Integer)count2.get(obj);
            if (c == null) {
                count2.put(obj, INTEGER_ONE);
                continue;
            }
            count2.put(obj, new Integer(c + 1));
        }
        return count2;
    }

    public static boolean isSubCollection(Collection a, Collection b) {
        Map mapa = CollectionUtils.getCardinalityMap(a);
        Map mapb = CollectionUtils.getCardinalityMap(b);
        Iterator it = a.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (CollectionUtils.getFreq(obj, mapa) <= CollectionUtils.getFreq(obj, mapb)) continue;
            return false;
        }
        return true;
    }

    public static boolean isProperSubCollection(Collection a, Collection b) {
        return a.size() < b.size() && CollectionUtils.isSubCollection(a, b);
    }

    public static boolean isEqualCollection(Collection a, Collection b) {
        if (a.size() != b.size()) {
            return false;
        }
        Map mapa = CollectionUtils.getCardinalityMap(a);
        Map mapb = CollectionUtils.getCardinalityMap(b);
        if (mapa.size() != mapb.size()) {
            return false;
        }
        Iterator it = mapa.keySet().iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (CollectionUtils.getFreq(obj, mapa) == CollectionUtils.getFreq(obj, mapb)) continue;
            return false;
        }
        return true;
    }

    public static int cardinality(Object obj, Collection coll) {
        if (coll instanceof Set) {
            return coll.contains(obj) ? 1 : 0;
        }
        if (coll instanceof Bag) {
            return ((Bag)coll).getCount(obj);
        }
        int count2 = 0;
        if (obj == null) {
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                if (it.next() != null) continue;
                ++count2;
            }
        } else {
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                if (!obj.equals(it.next())) continue;
                ++count2;
            }
        }
        return count2;
    }

    public static Object find(Collection collection2, Predicate predicate) {
        if (collection2 != null && predicate != null) {
            Iterator iter2 = collection2.iterator();
            while (iter2.hasNext()) {
                Object item = iter2.next();
                if (!predicate.evaluate(item)) continue;
                return item;
            }
        }
        return null;
    }

    public static void forAllDo(Collection collection2, Closure closure) {
        if (collection2 != null && closure != null) {
            Iterator it = collection2.iterator();
            while (it.hasNext()) {
                closure.execute(it.next());
            }
        }
    }

    public static void filter(Collection collection2, Predicate predicate) {
        if (collection2 != null && predicate != null) {
            Iterator it = collection2.iterator();
            while (it.hasNext()) {
                if (predicate.evaluate(it.next())) continue;
                it.remove();
            }
        }
    }

    public static void transform(Collection collection2, Transformer transformer) {
        if (collection2 != null && transformer != null) {
            if (collection2 instanceof List) {
                List list2 = (List)collection2;
                ListIterator<Object> it = list2.listIterator();
                while (it.hasNext()) {
                    it.set(transformer.transform(it.next()));
                }
            } else {
                Collection resultCollection = CollectionUtils.collect(collection2, transformer);
                collection2.clear();
                collection2.addAll(resultCollection);
            }
        }
    }

    public static int countMatches(Collection inputCollection, Predicate predicate) {
        int count2 = 0;
        if (inputCollection != null && predicate != null) {
            Iterator it = inputCollection.iterator();
            while (it.hasNext()) {
                if (!predicate.evaluate(it.next())) continue;
                ++count2;
            }
        }
        return count2;
    }

    public static boolean exists(Collection collection2, Predicate predicate) {
        if (collection2 != null && predicate != null) {
            Iterator it = collection2.iterator();
            while (it.hasNext()) {
                if (!predicate.evaluate(it.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static Collection select(Collection inputCollection, Predicate predicate) {
        ArrayList answer = new ArrayList(inputCollection.size());
        CollectionUtils.select(inputCollection, predicate, answer);
        return answer;
    }

    public static void select(Collection inputCollection, Predicate predicate, Collection outputCollection) {
        if (inputCollection != null && predicate != null) {
            Iterator iter2 = inputCollection.iterator();
            while (iter2.hasNext()) {
                Object item = iter2.next();
                if (!predicate.evaluate(item)) continue;
                outputCollection.add(item);
            }
        }
    }

    public static Collection selectRejected(Collection inputCollection, Predicate predicate) {
        ArrayList answer = new ArrayList(inputCollection.size());
        CollectionUtils.selectRejected(inputCollection, predicate, answer);
        return answer;
    }

    public static void selectRejected(Collection inputCollection, Predicate predicate, Collection outputCollection) {
        if (inputCollection != null && predicate != null) {
            Iterator iter2 = inputCollection.iterator();
            while (iter2.hasNext()) {
                Object item = iter2.next();
                if (predicate.evaluate(item)) continue;
                outputCollection.add(item);
            }
        }
    }

    public static Collection collect(Collection inputCollection, Transformer transformer) {
        ArrayList answer = new ArrayList(inputCollection.size());
        CollectionUtils.collect(inputCollection, transformer, answer);
        return answer;
    }

    public static Collection collect(Iterator inputIterator, Transformer transformer) {
        ArrayList answer = new ArrayList();
        CollectionUtils.collect(inputIterator, transformer, answer);
        return answer;
    }

    public static Collection collect(Collection inputCollection, Transformer transformer, Collection outputCollection) {
        if (inputCollection != null) {
            return CollectionUtils.collect(inputCollection.iterator(), transformer, outputCollection);
        }
        return outputCollection;
    }

    public static Collection collect(Iterator inputIterator, Transformer transformer, Collection outputCollection) {
        if (inputIterator != null && transformer != null) {
            while (inputIterator.hasNext()) {
                Object item = inputIterator.next();
                Object value2 = transformer.transform(item);
                outputCollection.add(value2);
            }
        }
        return outputCollection;
    }

    public static boolean addIgnoreNull(Collection collection2, Object object) {
        return object == null ? false : collection2.add(object);
    }

    public static void addAll(Collection collection2, Iterator iterator2) {
        while (iterator2.hasNext()) {
            collection2.add(iterator2.next());
        }
    }

    public static void addAll(Collection collection2, Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            collection2.add(enumeration.nextElement());
        }
    }

    public static void addAll(Collection collection2, Object[] elements) {
        int size2 = elements.length;
        for (int i = 0; i < size2; ++i) {
            collection2.add(elements[i]);
        }
    }

    public static Object index(Object obj, int idx) {
        return CollectionUtils.index(obj, new Integer(idx));
    }

    public static Object index(Object obj, Object index2) {
        Map map2;
        if (obj instanceof Map && (map2 = (Map)obj).containsKey(index2)) {
            return map2.get(index2);
        }
        int idx = -1;
        if (index2 instanceof Integer) {
            idx = (Integer)index2;
        }
        if (idx < 0) {
            return obj;
        }
        if (obj instanceof Map) {
            Map map3 = (Map)obj;
            Iterator iterator2 = map3.keySet().iterator();
            return CollectionUtils.index(iterator2, idx);
        }
        if (obj instanceof List) {
            return ((List)obj).get(idx);
        }
        if (obj instanceof Object[]) {
            return ((Object[])obj)[idx];
        }
        if (obj instanceof Enumeration) {
            Enumeration it = (Enumeration)obj;
            while (it.hasMoreElements()) {
                if (--idx == -1) {
                    return it.nextElement();
                }
                it.nextElement();
            }
        } else {
            if (obj instanceof Iterator) {
                return CollectionUtils.index((Iterator)obj, idx);
            }
            if (obj instanceof Collection) {
                Iterator iterator3 = ((Collection)obj).iterator();
                return CollectionUtils.index(iterator3, idx);
            }
        }
        return obj;
    }

    private static Object index(Iterator iterator2, int idx) {
        while (iterator2.hasNext()) {
            if (--idx == -1) {
                return iterator2.next();
            }
            iterator2.next();
        }
        return iterator2;
    }

    public static Object get(Object object, int index2) {
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("Index cannot be negative: " + index2);
        }
        if (object instanceof Map) {
            Map map2 = (Map)object;
            Iterator iterator2 = map2.entrySet().iterator();
            return CollectionUtils.get(iterator2, index2);
        }
        if (object instanceof List) {
            return ((List)object).get(index2);
        }
        if (object instanceof Object[]) {
            return ((Object[])object)[index2];
        }
        if (object instanceof Iterator) {
            Iterator it = (Iterator)object;
            while (it.hasNext()) {
                if (--index2 == -1) {
                    return it.next();
                }
                it.next();
            }
            throw new IndexOutOfBoundsException("Entry does not exist: " + index2);
        }
        if (object instanceof Collection) {
            Iterator iterator3 = ((Collection)object).iterator();
            return CollectionUtils.get(iterator3, index2);
        }
        if (object instanceof Enumeration) {
            Enumeration it = (Enumeration)object;
            while (it.hasMoreElements()) {
                if (--index2 == -1) {
                    return it.nextElement();
                }
                it.nextElement();
            }
            throw new IndexOutOfBoundsException("Entry does not exist: " + index2);
        }
        if (object == null) {
            throw new IllegalArgumentException("Unsupported object type: null");
        }
        try {
            return Array.get(object, index2);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Unsupported object type: " + object.getClass().getName());
        }
    }

    public static int size(Object object) {
        int total2 = 0;
        if (object instanceof Map) {
            total2 = ((Map)object).size();
        } else if (object instanceof Collection) {
            total2 = ((Collection)object).size();
        } else if (object instanceof Object[]) {
            total2 = ((Object[])object).length;
        } else if (object instanceof Iterator) {
            Iterator it = (Iterator)object;
            while (it.hasNext()) {
                ++total2;
                it.next();
            }
        } else if (object instanceof Enumeration) {
            Enumeration it = (Enumeration)object;
            while (it.hasMoreElements()) {
                ++total2;
                it.nextElement();
            }
        } else {
            if (object == null) {
                throw new IllegalArgumentException("Unsupported object type: null");
            }
            try {
                total2 = Array.getLength(object);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("Unsupported object type: " + object.getClass().getName());
            }
        }
        return total2;
    }

    public static boolean sizeIsEmpty(Object object) {
        if (object instanceof Collection) {
            return ((Collection)object).isEmpty();
        }
        if (object instanceof Map) {
            return ((Map)object).isEmpty();
        }
        if (object instanceof Object[]) {
            return ((Object[])object).length == 0;
        }
        if (object instanceof Iterator) {
            return !((Iterator)object).hasNext();
        }
        if (object instanceof Enumeration) {
            return !((Enumeration)object).hasMoreElements();
        }
        if (object == null) {
            throw new IllegalArgumentException("Unsupported object type: null");
        }
        try {
            return Array.getLength(object) == 0;
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Unsupported object type: " + object.getClass().getName());
        }
    }

    public static boolean isEmpty(Collection coll) {
        return coll == null || coll.isEmpty();
    }

    public static boolean isNotEmpty(Collection coll) {
        return !CollectionUtils.isEmpty(coll);
    }

    public static void reverseArray(Object[] array2) {
        int i = 0;
        for (int j = array2.length - 1; j > i; --j, ++i) {
            Object tmp = array2[j];
            array2[j] = array2[i];
            array2[i] = tmp;
        }
    }

    private static final int getFreq(Object obj, Map freqMap) {
        Integer count2 = (Integer)freqMap.get(obj);
        if (count2 != null) {
            return count2;
        }
        return 0;
    }

    public static boolean isFull(Collection coll) {
        if (coll == null) {
            throw new NullPointerException("The collection must not be null");
        }
        if (coll instanceof BoundedCollection) {
            return ((BoundedCollection)coll).isFull();
        }
        try {
            BoundedCollection bcoll = UnmodifiableBoundedCollection.decorateUsing(coll);
            return bcoll.isFull();
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static int maxSize(Collection coll) {
        if (coll == null) {
            throw new NullPointerException("The collection must not be null");
        }
        if (coll instanceof BoundedCollection) {
            return ((BoundedCollection)coll).maxSize();
        }
        try {
            BoundedCollection bcoll = UnmodifiableBoundedCollection.decorateUsing(coll);
            return bcoll.maxSize();
        }
        catch (IllegalArgumentException ex) {
            return -1;
        }
    }

    public static Collection retainAll(Collection collection2, Collection retain2) {
        return ListUtils.retainAll(collection2, retain2);
    }

    public static Collection removeAll(Collection collection2, Collection remove2) {
        return ListUtils.removeAll(collection2, remove2);
    }

    public static Collection synchronizedCollection(Collection collection2) {
        return SynchronizedCollection.decorate(collection2);
    }

    public static Collection unmodifiableCollection(Collection collection2) {
        return UnmodifiableCollection.decorate(collection2);
    }

    public static Collection predicatedCollection(Collection collection2, Predicate predicate) {
        return PredicatedCollection.decorate(collection2, predicate);
    }

    public static Collection typedCollection(Collection collection2, Class type) {
        return TypedCollection.decorate(collection2, type);
    }

    public static Collection transformedCollection(Collection collection2, Transformer transformer) {
        return TransformedCollection.decorate(collection2, transformer);
    }
}

