/*
 * Decompiled with CFR 0.152.
 */
package org.HdrHistogram;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.zip.DataFormatException;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.WriterReaderPhaser;

public class ConcurrentHistogram
extends Histogram {
    static final AtomicLongFieldUpdater<ConcurrentHistogram> totalCountUpdater = AtomicLongFieldUpdater.newUpdater(ConcurrentHistogram.class, "totalCount");
    volatile long totalCount;
    volatile AtomicLongArrayWithNormalizingOffset activeCounts;
    volatile AtomicLongArrayWithNormalizingOffset inactiveCounts;
    transient WriterReaderPhaser wrp = new WriterReaderPhaser();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setIntegerToDoubleValueConversionRatio(double integerToDoubleValueConversionRatio) {
        try {
            this.wrp.readerLock();
            this.inactiveCounts.doubleToIntegerValueConversionRatio = 1.0 / integerToDoubleValueConversionRatio;
            AtomicLongArrayWithNormalizingOffset tmp = this.activeCounts;
            this.activeCounts = this.inactiveCounts;
            this.inactiveCounts = tmp;
            this.wrp.flipPhase();
            this.inactiveCounts.doubleToIntegerValueConversionRatio = 1.0 / integerToDoubleValueConversionRatio;
            tmp = this.activeCounts;
            this.activeCounts = this.inactiveCounts;
            this.inactiveCounts = tmp;
            this.wrp.flipPhase();
        }
        finally {
            this.wrp.readerUnlock();
        }
        super.setIntegerToDoubleValueConversionRatio(integerToDoubleValueConversionRatio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    long getCountAtIndex(int index2) {
        try {
            this.wrp.readerLock();
            assert (this.countsArrayLength == this.activeCounts.length());
            assert (this.countsArrayLength == this.inactiveCounts.length());
            long activeCount = this.activeCounts.get(this.normalizeIndex(index2, this.activeCounts.getNormalizingIndexOffset(), this.activeCounts.length()));
            long inactiveCount = this.inactiveCounts.get(this.normalizeIndex(index2, this.inactiveCounts.getNormalizingIndexOffset(), this.inactiveCounts.length()));
            long l = activeCount + inactiveCount;
            return l;
        }
        finally {
            this.wrp.readerUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    long getCountAtNormalizedIndex(int index2) {
        try {
            this.wrp.readerLock();
            assert (this.countsArrayLength == this.activeCounts.length());
            assert (this.countsArrayLength == this.inactiveCounts.length());
            long activeCount = this.activeCounts.get(index2);
            long inactiveCount = this.inactiveCounts.get(index2);
            long l = activeCount + inactiveCount;
            return l;
        }
        finally {
            this.wrp.readerUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void incrementCountAtIndex(int index2) {
        long criticalValue = this.wrp.writerCriticalSectionEnter();
        try {
            this.activeCounts.incrementAndGet(this.normalizeIndex(index2, this.activeCounts.getNormalizingIndexOffset(), this.activeCounts.length()));
        }
        finally {
            this.wrp.writerCriticalSectionExit(criticalValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void addToCountAtIndex(int index2, long value2) {
        long criticalValue = this.wrp.writerCriticalSectionEnter();
        try {
            this.activeCounts.addAndGet(this.normalizeIndex(index2, this.activeCounts.getNormalizingIndexOffset(), this.activeCounts.length()), value2);
        }
        finally {
            this.wrp.writerCriticalSectionExit(criticalValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setCountAtIndex(int index2, long value2) {
        try {
            this.wrp.readerLock();
            assert (this.countsArrayLength == this.activeCounts.length());
            assert (this.countsArrayLength == this.inactiveCounts.length());
            this.activeCounts.lazySet(this.normalizeIndex(index2, this.activeCounts.getNormalizingIndexOffset(), this.activeCounts.length()), value2);
            this.inactiveCounts.lazySet(this.normalizeIndex(index2, this.inactiveCounts.getNormalizingIndexOffset(), this.inactiveCounts.length()), 0L);
        }
        finally {
            this.wrp.readerUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setCountAtNormalizedIndex(int index2, long value2) {
        try {
            this.wrp.readerLock();
            assert (this.countsArrayLength == this.activeCounts.length());
            assert (this.countsArrayLength == this.inactiveCounts.length());
            this.inactiveCounts.lazySet(index2, value2);
            this.activeCounts.lazySet(index2, 0L);
        }
        finally {
            this.wrp.readerUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void recordConvertedDoubleValue(double value2) {
        long criticalValue = this.wrp.writerCriticalSectionEnter();
        try {
            long integerValue = (long)(value2 * this.activeCounts.doubleToIntegerValueConversionRatio);
            int index2 = this.countsArrayIndex(integerValue);
            this.activeCounts.incrementAndGet(this.normalizeIndex(index2, this.activeCounts.getNormalizingIndexOffset(), this.activeCounts.length()));
            this.updateMinAndMax(integerValue);
            this.incrementTotalCount();
        }
        finally {
            this.wrp.writerCriticalSectionExit(criticalValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordConvertedDoubleValueWithCount(double value2, long count2) throws ArrayIndexOutOfBoundsException {
        long criticalValue = this.wrp.writerCriticalSectionEnter();
        try {
            long integerValue = (long)(value2 * this.activeCounts.doubleToIntegerValueConversionRatio);
            int index2 = this.countsArrayIndex(integerValue);
            this.activeCounts.addAndGet(this.normalizeIndex(index2, this.activeCounts.getNormalizingIndexOffset(), this.activeCounts.length()), count2);
            this.updateMinAndMax(integerValue);
            this.addToTotalCount(count2);
        }
        finally {
            this.wrp.writerCriticalSectionExit(criticalValue);
        }
    }

    @Override
    int getNormalizingIndexOffset() {
        return this.activeCounts.getNormalizingIndexOffset();
    }

    @Override
    void setNormalizingIndexOffset(int normalizingIndexOffset) {
        this.setNormalizingIndexOffset(normalizingIndexOffset, 0, false, this.getIntegerToDoubleValueConversionRatio());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNormalizingIndexOffset(int normalizingIndexOffset, int shiftedAmount, boolean lowestHalfBucketPopulated, double newIntegerToDoubleValueConversionRatio) {
        try {
            this.wrp.readerLock();
            assert (this.countsArrayLength == this.activeCounts.length());
            assert (this.countsArrayLength == this.inactiveCounts.length());
            assert (this.activeCounts.getNormalizingIndexOffset() == this.inactiveCounts.getNormalizingIndexOffset());
            if (normalizingIndexOffset == this.activeCounts.getNormalizingIndexOffset()) {
                return;
            }
            int zeroIndex = this.normalizeIndex(0, this.inactiveCounts.getNormalizingIndexOffset(), this.inactiveCounts.length());
            long inactiveZeroValueCount = this.inactiveCounts.get(zeroIndex);
            this.inactiveCounts.lazySet(zeroIndex, 0L);
            this.inactiveCounts.setNormalizingIndexOffset(normalizingIndexOffset);
            if (shiftedAmount > 0 && lowestHalfBucketPopulated) {
                this.shiftLowestInactiveHalfBucketContentsLeft(shiftedAmount, zeroIndex);
            }
            zeroIndex = this.normalizeIndex(0, this.inactiveCounts.getNormalizingIndexOffset(), this.inactiveCounts.length());
            this.inactiveCounts.lazySet(zeroIndex, inactiveZeroValueCount);
            this.inactiveCounts.doubleToIntegerValueConversionRatio = 1.0 / newIntegerToDoubleValueConversionRatio;
            AtomicLongArrayWithNormalizingOffset tmp = this.activeCounts;
            this.activeCounts = this.inactiveCounts;
            this.inactiveCounts = tmp;
            this.wrp.flipPhase();
            zeroIndex = this.normalizeIndex(0, this.inactiveCounts.getNormalizingIndexOffset(), this.inactiveCounts.length());
            inactiveZeroValueCount = this.inactiveCounts.get(zeroIndex);
            this.inactiveCounts.lazySet(zeroIndex, 0L);
            this.inactiveCounts.setNormalizingIndexOffset(normalizingIndexOffset);
            if (shiftedAmount > 0 && lowestHalfBucketPopulated) {
                this.shiftLowestInactiveHalfBucketContentsLeft(shiftedAmount, zeroIndex);
            }
            zeroIndex = this.normalizeIndex(0, this.inactiveCounts.getNormalizingIndexOffset(), this.inactiveCounts.length());
            this.inactiveCounts.lazySet(zeroIndex, inactiveZeroValueCount);
            this.inactiveCounts.doubleToIntegerValueConversionRatio = 1.0 / newIntegerToDoubleValueConversionRatio;
            tmp = this.activeCounts;
            this.activeCounts = this.inactiveCounts;
            this.inactiveCounts = tmp;
            this.wrp.flipPhase();
        }
        finally {
            this.wrp.readerUnlock();
        }
    }

    private void shiftLowestInactiveHalfBucketContentsLeft(int shiftAmount, int preShiftZeroIndex) {
        int numberOfBinaryOrdersOfMagnitude = shiftAmount >> this.subBucketHalfCountMagnitude;
        for (int fromIndex = 1; fromIndex < this.subBucketHalfCount; ++fromIndex) {
            long toValue = this.valueFromIndex(fromIndex) << numberOfBinaryOrdersOfMagnitude;
            int toIndex = this.countsArrayIndex(toValue);
            int normalizedToIndex = this.normalizeIndex(toIndex, this.inactiveCounts.getNormalizingIndexOffset(), this.inactiveCounts.length());
            long countAtFromIndex = this.inactiveCounts.get(fromIndex + preShiftZeroIndex);
            this.inactiveCounts.lazySet(normalizedToIndex, countAtFromIndex);
            this.inactiveCounts.lazySet(fromIndex + preShiftZeroIndex, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void shiftNormalizingIndexByOffset(int offsetToAdd, boolean lowestHalfBucketPopulated, double newIntegerToDoubleValueConversionRatio) {
        try {
            this.wrp.readerLock();
            assert (this.countsArrayLength == this.activeCounts.length());
            assert (this.countsArrayLength == this.inactiveCounts.length());
            int newNormalizingIndexOffset = this.getNormalizingIndexOffset() + offsetToAdd;
            this.setNormalizingIndexOffset(newNormalizingIndexOffset, offsetToAdd, lowestHalfBucketPopulated, newIntegerToDoubleValueConversionRatio);
        }
        finally {
            this.wrp.readerUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void resize(long newHighestTrackableValue) {
        try {
            this.wrp.readerLock();
            assert (this.countsArrayLength == this.activeCounts.length());
            assert (this.countsArrayLength == this.inactiveCounts.length());
            int newArrayLength = this.determineArrayLengthNeeded(newHighestTrackableValue);
            int countsDelta = newArrayLength - this.countsArrayLength;
            if (countsDelta <= 0) {
                return;
            }
            AtomicLongArrayWithNormalizingOffset newInactiveCounts1 = new AtomicLongArrayWithNormalizingOffset(newArrayLength, this.inactiveCounts.getNormalizingIndexOffset());
            AtomicLongArrayWithNormalizingOffset newInactiveCounts2 = new AtomicLongArrayWithNormalizingOffset(newArrayLength, this.activeCounts.getNormalizingIndexOffset());
            AtomicLongArrayWithNormalizingOffset oldInactiveCounts = this.inactiveCounts;
            this.inactiveCounts = newInactiveCounts1;
            this.copyInactiveCountsContentsOnResize(oldInactiveCounts, countsDelta);
            AtomicLongArrayWithNormalizingOffset tmp = this.activeCounts;
            this.activeCounts = this.inactiveCounts;
            this.inactiveCounts = tmp;
            this.wrp.flipPhase();
            oldInactiveCounts = this.inactiveCounts;
            this.inactiveCounts = newInactiveCounts2;
            this.copyInactiveCountsContentsOnResize(oldInactiveCounts, countsDelta);
            tmp = this.activeCounts;
            this.activeCounts = this.inactiveCounts;
            this.inactiveCounts = tmp;
            this.wrp.flipPhase();
            this.establishSize(newHighestTrackableValue);
            assert (this.countsArrayLength == this.activeCounts.length());
            assert (this.countsArrayLength == this.inactiveCounts.length());
        }
        finally {
            this.wrp.readerUnlock();
        }
    }

    private void copyInactiveCountsContentsOnResize(AtomicLongArrayWithNormalizingOffset oldInactiveCounts, int countsDelta) {
        int oldNormalizedZeroIndex = this.normalizeIndex(0, oldInactiveCounts.getNormalizingIndexOffset(), oldInactiveCounts.length());
        for (int i = 0; i < oldInactiveCounts.length(); ++i) {
            this.inactiveCounts.lazySet(i, oldInactiveCounts.get(i));
        }
        if (oldNormalizedZeroIndex != 0) {
            int newNormalizedZeroIndex = oldNormalizedZeroIndex + countsDelta;
            int lengthToCopy = this.inactiveCounts.length() - countsDelta - oldNormalizedZeroIndex;
            int src = oldNormalizedZeroIndex;
            int dst = newNormalizedZeroIndex;
            while (src < oldNormalizedZeroIndex + lengthToCopy) {
                this.inactiveCounts.lazySet(dst, oldInactiveCounts.get(src));
                ++src;
                ++dst;
            }
            for (dst = oldNormalizedZeroIndex; dst < newNormalizedZeroIndex; ++dst) {
                this.inactiveCounts.lazySet(dst, 0L);
            }
        }
    }

    @Override
    public void setAutoResize(boolean autoResize) {
        this.autoResize = true;
    }

    @Override
    void clearCounts() {
        try {
            this.wrp.readerLock();
            assert (this.countsArrayLength == this.activeCounts.length());
            assert (this.countsArrayLength == this.inactiveCounts.length());
            for (int i = 0; i < this.activeCounts.length(); ++i) {
                this.activeCounts.lazySet(i, 0L);
                this.inactiveCounts.lazySet(i, 0L);
            }
            totalCountUpdater.set(this, 0L);
        }
        finally {
            this.wrp.readerUnlock();
        }
    }

    @Override
    public ConcurrentHistogram copy() {
        ConcurrentHistogram copy = new ConcurrentHistogram(this);
        copy.add(this);
        return copy;
    }

    @Override
    public ConcurrentHistogram copyCorrectedForCoordinatedOmission(long expectedIntervalBetweenValueSamples) {
        ConcurrentHistogram toHistogram = new ConcurrentHistogram(this);
        toHistogram.addWhileCorrectingForCoordinatedOmission(this, expectedIntervalBetweenValueSamples);
        return toHistogram;
    }

    @Override
    public long getTotalCount() {
        return totalCountUpdater.get(this);
    }

    @Override
    void setTotalCount(long totalCount) {
        totalCountUpdater.set(this, totalCount);
    }

    @Override
    void incrementTotalCount() {
        totalCountUpdater.incrementAndGet(this);
    }

    @Override
    void addToTotalCount(long value2) {
        totalCountUpdater.addAndGet(this, value2);
    }

    @Override
    int _getEstimatedFootprintInBytes() {
        return 512 + 16 * this.activeCounts.length();
    }

    public ConcurrentHistogram(int numberOfSignificantValueDigits) {
        this(1L, 2L, numberOfSignificantValueDigits);
        this.setAutoResize(true);
    }

    public ConcurrentHistogram(long highestTrackableValue, int numberOfSignificantValueDigits) {
        this(1L, highestTrackableValue, numberOfSignificantValueDigits);
    }

    public ConcurrentHistogram(long lowestDiscernibleValue, long highestTrackableValue, int numberOfSignificantValueDigits) {
        super(lowestDiscernibleValue, highestTrackableValue, numberOfSignificantValueDigits, false);
        this.activeCounts = new AtomicLongArrayWithNormalizingOffset(this.countsArrayLength, 0);
        this.inactiveCounts = new AtomicLongArrayWithNormalizingOffset(this.countsArrayLength, 0);
        this.wordSizeInBytes = 8;
    }

    public ConcurrentHistogram(AbstractHistogram source) {
        super(source, false);
        this.activeCounts = new AtomicLongArrayWithNormalizingOffset(this.countsArrayLength, 0);
        this.inactiveCounts = new AtomicLongArrayWithNormalizingOffset(this.countsArrayLength, 0);
        this.wordSizeInBytes = 8;
    }

    public static ConcurrentHistogram decodeFromByteBuffer(ByteBuffer buffer, long minBarForHighestTrackableValue) {
        return ConcurrentHistogram.decodeFromByteBuffer(buffer, ConcurrentHistogram.class, minBarForHighestTrackableValue);
    }

    public static ConcurrentHistogram decodeFromCompressedByteBuffer(ByteBuffer buffer, long minBarForHighestTrackableValue) throws DataFormatException {
        return ConcurrentHistogram.decodeFromCompressedByteBuffer(buffer, ConcurrentHistogram.class, minBarForHighestTrackableValue);
    }

    private void readObject(ObjectInputStream o) throws IOException, ClassNotFoundException {
        o.defaultReadObject();
        this.wrp = new WriterReaderPhaser();
    }

    @Override
    synchronized void fillCountsArrayFromBuffer(ByteBuffer buffer, int length) {
        LongBuffer logbuffer = buffer.asLongBuffer();
        for (int i = 0; i < length; ++i) {
            this.inactiveCounts.lazySet(i, logbuffer.get());
            this.activeCounts.lazySet(i, 0L);
        }
    }

    @Override
    synchronized void fillBufferFromCountsArray(ByteBuffer buffer) {
        try {
            this.wrp.readerLock();
            super.fillBufferFromCountsArray(buffer);
        }
        finally {
            this.wrp.readerUnlock();
        }
    }

    static class AtomicLongArrayWithNormalizingOffset
    extends AtomicLongArray {
        private int normalizingIndexOffset;
        private double doubleToIntegerValueConversionRatio;

        AtomicLongArrayWithNormalizingOffset(int length, int normalizingIndexOffset) {
            super(length);
            this.normalizingIndexOffset = normalizingIndexOffset;
        }

        public int getNormalizingIndexOffset() {
            return this.normalizingIndexOffset;
        }

        public void setNormalizingIndexOffset(int normalizingIndexOffset) {
            this.normalizingIndexOffset = normalizingIndexOffset;
        }
    }
}

