/*
 * Decompiled with CFR 0.152.
 */
package net.objecthunter.exp4j.function;

import net.objecthunter.exp4j.function.Function;

public class Functions {
    private static final int INDEX_SIN = 0;
    private static final int INDEX_COS = 1;
    private static final int INDEX_TAN = 2;
    private static final int INDEX_COT = 3;
    private static final int INDEX_LOG = 4;
    private static final int INDEX_LOG1P = 5;
    private static final int INDEX_ABS = 6;
    private static final int INDEX_ACOS = 7;
    private static final int INDEX_ASIN = 8;
    private static final int INDEX_ATAN = 9;
    private static final int INDEX_CBRT = 10;
    private static final int INDEX_CEIL = 11;
    private static final int INDEX_FLOOR = 12;
    private static final int INDEX_SINH = 13;
    private static final int INDEX_SQRT = 14;
    private static final int INDEX_TANH = 15;
    private static final int INDEX_COSH = 16;
    private static final int INDEX_POW = 17;
    private static final int INDEX_EXP = 18;
    private static final int INDEX_EXPM1 = 19;
    private static final int INDEX_LOG10 = 20;
    private static final int INDEX_LOG2 = 21;
    private static final int INDEX_SGN = 22;
    private static final Function[] builtinFunctions = new Function[23];

    public static Function getBuiltinFunction(String name2) {
        if (name2.equals("sin")) {
            return builtinFunctions[0];
        }
        if (name2.equals("cos")) {
            return builtinFunctions[1];
        }
        if (name2.equals("tan")) {
            return builtinFunctions[2];
        }
        if (name2.equals("cot")) {
            return builtinFunctions[3];
        }
        if (name2.equals("asin")) {
            return builtinFunctions[8];
        }
        if (name2.equals("acos")) {
            return builtinFunctions[7];
        }
        if (name2.equals("atan")) {
            return builtinFunctions[9];
        }
        if (name2.equals("sinh")) {
            return builtinFunctions[13];
        }
        if (name2.equals("cosh")) {
            return builtinFunctions[16];
        }
        if (name2.equals("tanh")) {
            return builtinFunctions[15];
        }
        if (name2.equals("abs")) {
            return builtinFunctions[6];
        }
        if (name2.equals("log")) {
            return builtinFunctions[4];
        }
        if (name2.equals("log10")) {
            return builtinFunctions[20];
        }
        if (name2.equals("log2")) {
            return builtinFunctions[21];
        }
        if (name2.equals("log1p")) {
            return builtinFunctions[5];
        }
        if (name2.equals("ceil")) {
            return builtinFunctions[11];
        }
        if (name2.equals("floor")) {
            return builtinFunctions[12];
        }
        if (name2.equals("sqrt")) {
            return builtinFunctions[14];
        }
        if (name2.equals("cbrt")) {
            return builtinFunctions[10];
        }
        if (name2.equals("pow")) {
            return builtinFunctions[17];
        }
        if (name2.equals("exp")) {
            return builtinFunctions[18];
        }
        if (name2.equals("expm1")) {
            return builtinFunctions[19];
        }
        if (name2.equals("signum")) {
            return builtinFunctions[22];
        }
        return null;
    }

    static {
        Functions.builtinFunctions[0] = new Function("sin"){

            @Override
            public double apply(double ... args2) {
                return Math.sin(args2[0]);
            }
        };
        Functions.builtinFunctions[1] = new Function("cos"){

            @Override
            public double apply(double ... args2) {
                return Math.cos(args2[0]);
            }
        };
        Functions.builtinFunctions[2] = new Function("tan"){

            @Override
            public double apply(double ... args2) {
                return Math.tan(args2[0]);
            }
        };
        Functions.builtinFunctions[3] = new Function("cot"){

            @Override
            public double apply(double ... args2) {
                double tan = Math.tan(args2[0]);
                if (tan == 0.0) {
                    throw new ArithmeticException("Division by zero in cotangent!");
                }
                return 1.0 / Math.tan(args2[0]);
            }
        };
        Functions.builtinFunctions[4] = new Function("log"){

            @Override
            public double apply(double ... args2) {
                return Math.log(args2[0]);
            }
        };
        Functions.builtinFunctions[21] = new Function("log2"){

            @Override
            public double apply(double ... args2) {
                return Math.log(args2[0]) / Math.log(2.0);
            }
        };
        Functions.builtinFunctions[20] = new Function("log10"){

            @Override
            public double apply(double ... args2) {
                return Math.log10(args2[0]);
            }
        };
        Functions.builtinFunctions[5] = new Function("log1p"){

            @Override
            public double apply(double ... args2) {
                return Math.log1p(args2[0]);
            }
        };
        Functions.builtinFunctions[6] = new Function("abs"){

            @Override
            public double apply(double ... args2) {
                return Math.abs(args2[0]);
            }
        };
        Functions.builtinFunctions[7] = new Function("acos"){

            @Override
            public double apply(double ... args2) {
                return Math.acos(args2[0]);
            }
        };
        Functions.builtinFunctions[8] = new Function("asin"){

            @Override
            public double apply(double ... args2) {
                return Math.asin(args2[0]);
            }
        };
        Functions.builtinFunctions[9] = new Function("atan"){

            @Override
            public double apply(double ... args2) {
                return Math.atan(args2[0]);
            }
        };
        Functions.builtinFunctions[10] = new Function("cbrt"){

            @Override
            public double apply(double ... args2) {
                return Math.cbrt(args2[0]);
            }
        };
        Functions.builtinFunctions[12] = new Function("floor"){

            @Override
            public double apply(double ... args2) {
                return Math.floor(args2[0]);
            }
        };
        Functions.builtinFunctions[13] = new Function("sinh"){

            @Override
            public double apply(double ... args2) {
                return Math.sinh(args2[0]);
            }
        };
        Functions.builtinFunctions[14] = new Function("sqrt"){

            @Override
            public double apply(double ... args2) {
                return Math.sqrt(args2[0]);
            }
        };
        Functions.builtinFunctions[15] = new Function("tanh"){

            @Override
            public double apply(double ... args2) {
                return Math.tanh(args2[0]);
            }
        };
        Functions.builtinFunctions[16] = new Function("cosh"){

            @Override
            public double apply(double ... args2) {
                return Math.cosh(args2[0]);
            }
        };
        Functions.builtinFunctions[11] = new Function("ceil"){

            @Override
            public double apply(double ... args2) {
                return Math.ceil(args2[0]);
            }
        };
        Functions.builtinFunctions[17] = new Function("pow", 2){

            @Override
            public double apply(double ... args2) {
                return Math.pow(args2[0], args2[1]);
            }
        };
        Functions.builtinFunctions[18] = new Function("exp", 1){

            @Override
            public double apply(double ... args2) {
                return Math.exp(args2[0]);
            }
        };
        Functions.builtinFunctions[19] = new Function("expm1", 1){

            @Override
            public double apply(double ... args2) {
                return Math.expm1(args2[0]);
            }
        };
        Functions.builtinFunctions[22] = new Function("signum", 1){

            @Override
            public double apply(double ... args2) {
                if (args2[0] > 0.0) {
                    return 1.0;
                }
                if (args2[0] < 0.0) {
                    return -1.0;
                }
                return 0.0;
            }
        };
    }
}

