/*
 * Decompiled with CFR 0.152.
 */
package net.objecthunter.exp4j.function;

public abstract class Function {
    protected final String name;
    protected final int numArguments;

    public Function(String name2, int numArguments) {
        if (numArguments < 0) {
            throw new IllegalArgumentException("The number of function arguments can not be less than 0 for '" + name2 + "'");
        }
        if (!Function.isValidFunctionName(name2)) {
            throw new IllegalArgumentException("The function name '" + name2 + "' is invalid");
        }
        this.name = name2;
        this.numArguments = numArguments;
    }

    public Function(String name2) {
        this(name2, 1);
    }

    public String getName() {
        return this.name;
    }

    public int getNumArguments() {
        return this.numArguments;
    }

    public abstract double apply(double ... var1);

    public static char[] getAllowedFunctionCharacters() {
        int i;
        char[] chars = new char[53];
        int count2 = 0;
        for (i = 65; i < 91; ++i) {
            chars[count2++] = (char)i;
        }
        for (i = 97; i < 123; ++i) {
            chars[count2++] = (char)i;
        }
        chars[count2] = 95;
        return chars;
    }

    public static boolean isValidFunctionName(String name2) {
        if (name2 == null) {
            return false;
        }
        int size2 = name2.length();
        if (size2 == 0) {
            return false;
        }
        for (int i = 0; i < size2; ++i) {
            char c = name2.charAt(i);
            if (Character.isLetter(c) || c == '_' || Character.isDigit(c) && i > 0) continue;
            return false;
        }
        return true;
    }
}

