/*
 * Decompiled with CFR 0.152.
 */
package jnr.posix;

import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.mapper.DataConverter;
import jnr.ffi.mapper.FromNativeContext;
import jnr.ffi.mapper.ToNativeContext;

public final class HANDLE {
    public static final long INVALID_HANDLE_VALUE = -1L;
    private final Pointer pointer;
    public static final DataConverter<HANDLE, Pointer> Converter = new DataConverter<HANDLE, Pointer>(){

        @Override
        public Pointer toNative(HANDLE value2, ToNativeContext context) {
            return value2 != null ? value2.pointer : null;
        }

        @Override
        public HANDLE fromNative(Pointer nativeValue, FromNativeContext context) {
            return nativeValue != null ? new HANDLE(nativeValue) : null;
        }

        @Override
        public Class<Pointer> nativeType() {
            return Pointer.class;
        }
    };

    public HANDLE(Pointer pointer) {
        this.pointer = pointer;
    }

    public final Pointer toPointer() {
        return this.pointer;
    }

    public final boolean isValid() {
        return this.pointer.address() != (0xFFFFFFFFFFFFFFFFL & Runtime.getSystemRuntime().addressMask());
    }

    public static HANDLE valueOf(Pointer value2) {
        return new HANDLE(value2);
    }

    public static HANDLE valueOf(long value2) {
        return new HANDLE(Runtime.getSystemRuntime().getMemoryManager().newPointer(value2));
    }
}

