/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import jnr.ffi.NativeType;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.Variable;
import jnr.ffi.mapper.DefaultSignatureType;
import jnr.ffi.mapper.FromNativeConverter;
import jnr.ffi.mapper.SignatureTypeMapper;
import jnr.ffi.mapper.ToNativeConverter;
import jnr.ffi.provider.FromNativeType;
import jnr.ffi.provider.ToNativeType;
import jnr.ffi.provider.jffi.AsmBuilder;
import jnr.ffi.provider.jffi.AsmClassLoader;
import jnr.ffi.provider.jffi.AsmLibraryLoader;
import jnr.ffi.provider.jffi.AsmUtil;
import jnr.ffi.provider.jffi.CodegenUtils;
import jnr.ffi.provider.jffi.DirectMemoryIO;
import jnr.ffi.provider.jffi.InvokerUtil;
import jnr.ffi.provider.jffi.NativeLibraryLoader;
import jnr.ffi.provider.jffi.NoTrace;
import jnr.ffi.provider.jffi.SimpleNativeContext;
import jnr.ffi.provider.jffi.SkinnyMethodAdapter;
import jnr.ffi.provider.jffi.ToNativeOp;
import jnr.ffi.provider.jffi.Types;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class VariableAccessorGenerator {
    private final AtomicLong nextClassID = new AtomicLong(0L);
    private final Runtime runtime;
    static final Map<NativeType, PointerOp> pointerOperations;
    private static final PointerOp POINTER_OP_POINTER;

    public VariableAccessorGenerator(Runtime runtime) {
        this.runtime = runtime;
    }

    public void generate(AsmBuilder builder, Class interfaceClass, String variableName, long address, Class javaType2, Collection<Annotation> annotations2, SignatureTypeMapper typeMapper, AsmClassLoader classLoader) {
        if (!NativeLibraryLoader.ASM_ENABLED) {
            throw new UnsupportedOperationException("asm bytecode generation not supported");
        }
        SimpleNativeContext context = new SimpleNativeContext(builder.getRuntime(), annotations2);
        DefaultSignatureType signatureType = DefaultSignatureType.create(javaType2, context);
        jnr.ffi.mapper.FromNativeType fromNativeType = typeMapper.getFromNativeType(signatureType, context);
        FromNativeConverter fromNativeConverter = fromNativeType != null ? fromNativeType.getFromNativeConverter() : null;
        jnr.ffi.mapper.ToNativeType toNativeType = typeMapper.getToNativeType(signatureType, context);
        ToNativeConverter toNativeConverter = toNativeType != null ? toNativeType.getToNativeConverter() : null;
        Variable variableAccessor = this.buildVariableAccessor(builder.getRuntime(), address, interfaceClass, javaType2, annotations2, toNativeConverter, fromNativeConverter, classLoader);
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(builder.getClassVisitor(), 17, variableName, CodegenUtils.sig(Variable.class, new Class[0]), null, null);
        mv.start();
        mv.aload(0);
        mv.getfield(builder.getClassNamePath(), builder.getVariableName(variableAccessor), CodegenUtils.ci(Variable.class));
        mv.areturn();
        mv.visitMaxs(10, 10);
        mv.visitEnd();
    }

    Variable buildVariableAccessor(Runtime runtime, long address, Class interfaceClass, Class javaType2, Collection<Annotation> annotations2, ToNativeConverter toNativeConverter, FromNativeConverter fromNativeConverter, AsmClassLoader classLoader) {
        boolean debug = AsmLibraryLoader.DEBUG && !InvokerUtil.hasAnnotation(annotations2, NoTrace.class);
        ClassWriter cw = new ClassWriter(2);
        ClassVisitor cv = debug ? AsmUtil.newCheckClassAdapter(cw) : cw;
        AsmBuilder builder = new AsmBuilder(runtime, CodegenUtils.p(interfaceClass) + "$VariableAccessor$$" + this.nextClassID.getAndIncrement(), cv, classLoader);
        cv.visit(50, 17, builder.getClassNamePath(), null, CodegenUtils.p(Object.class), new String[]{CodegenUtils.p(Variable.class)});
        SkinnyMethodAdapter set2 = new SkinnyMethodAdapter(builder.getClassVisitor(), 17, "set", CodegenUtils.sig(Void.TYPE, Object.class), null, null);
        Class boxedType = toNativeConverter != null ? toNativeConverter.nativeType() : javaType2;
        NativeType nativeType = Types.getType(runtime, boxedType, annotations2).getNativeType();
        ToNativeType toNativeType = new ToNativeType(javaType2, nativeType, annotations2, toNativeConverter, null);
        FromNativeType fromNativeType = new FromNativeType(javaType2, nativeType, annotations2, fromNativeConverter, null);
        PointerOp pointerOp = pointerOperations.get((Object)nativeType);
        if (pointerOp == null) {
            throw new IllegalArgumentException("global variable type not supported: " + javaType2);
        }
        set2.start();
        set2.aload(0);
        Pointer pointer = DirectMemoryIO.wrap(runtime, address);
        set2.getfield(builder.getClassNamePath(), builder.getObjectFieldName(pointer, Pointer.class), CodegenUtils.ci(Pointer.class));
        set2.lconst_0();
        set2.aload(1);
        set2.checkcast(javaType2);
        AsmUtil.emitToNativeConversion(builder, set2, toNativeType);
        ToNativeOp toNativeOp = ToNativeOp.get(toNativeType);
        if (toNativeOp != null && toNativeOp.isPrimitive()) {
            toNativeOp.emitPrimitive(set2, pointerOp.nativeIntClass, toNativeType.getNativeType());
        } else if (Pointer.class.isAssignableFrom(toNativeType.effectiveJavaType())) {
            pointerOp = POINTER_OP_POINTER;
        } else {
            throw new IllegalArgumentException("global variable type not supported: " + javaType2);
        }
        pointerOp.put(set2);
        set2.voidreturn();
        set2.visitMaxs(10, 10);
        set2.visitEnd();
        SkinnyMethodAdapter get2 = new SkinnyMethodAdapter(builder.getClassVisitor(), 17, "get", CodegenUtils.sig(Object.class, new Class[0]), null, null);
        get2.start();
        get2.aload(0);
        get2.getfield(builder.getClassNamePath(), builder.getObjectFieldName(pointer, Pointer.class), CodegenUtils.ci(Pointer.class));
        get2.lconst_0();
        pointerOp.get(get2);
        AsmUtil.emitFromNativeConversion(builder, get2, fromNativeType, pointerOp.nativeIntClass);
        get2.areturn();
        get2.visitMaxs(10, 10);
        get2.visitEnd();
        SkinnyMethodAdapter init2 = new SkinnyMethodAdapter(cv, 1, "<init>", CodegenUtils.sig(Void.TYPE, Object[].class), null, null);
        init2.start();
        init2.aload(0);
        init2.invokespecial(CodegenUtils.p(Object.class), "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]));
        builder.emitFieldInitialization(init2, 1);
        init2.voidreturn();
        init2.visitMaxs(10, 10);
        init2.visitEnd();
        cv.visitEnd();
        try {
            byte[] bytes2 = cw.toByteArray();
            if (debug) {
                ClassVisitor trace = AsmUtil.newTraceClassVisitor(new PrintWriter(System.err));
                new ClassReader(bytes2).accept(trace, 0);
            }
            Class implClass2 = classLoader.defineClass(builder.getClassNamePath().replace("/", "."), bytes2);
            Constructor cons = implClass2.getDeclaredConstructor(Object[].class);
            return (Variable)cons.newInstance(new Object[]{builder.getObjectFieldValues()});
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void op(Map<NativeType, PointerOp> ops2, NativeType type, String name2, Class nativeIntType) {
        ops2.put(type, new PointerOp(name2, nativeIntType));
    }

    static {
        EnumMap<NativeType, PointerOp> ops2 = new EnumMap<NativeType, PointerOp>(NativeType.class);
        VariableAccessorGenerator.op(ops2, NativeType.SCHAR, "Byte", Byte.TYPE);
        VariableAccessorGenerator.op(ops2, NativeType.UCHAR, "Byte", Byte.TYPE);
        VariableAccessorGenerator.op(ops2, NativeType.SSHORT, "Short", Short.TYPE);
        VariableAccessorGenerator.op(ops2, NativeType.USHORT, "Short", Short.TYPE);
        VariableAccessorGenerator.op(ops2, NativeType.SINT, "Int", Integer.TYPE);
        VariableAccessorGenerator.op(ops2, NativeType.UINT, "Int", Integer.TYPE);
        VariableAccessorGenerator.op(ops2, NativeType.SLONG, "Long", Long.TYPE);
        VariableAccessorGenerator.op(ops2, NativeType.ULONG, "Long", Long.TYPE);
        VariableAccessorGenerator.op(ops2, NativeType.SLONGLONG, "LongLong", Long.TYPE);
        VariableAccessorGenerator.op(ops2, NativeType.ULONGLONG, "LongLong", Long.TYPE);
        VariableAccessorGenerator.op(ops2, NativeType.FLOAT, "Float", Float.TYPE);
        VariableAccessorGenerator.op(ops2, NativeType.DOUBLE, "Double", Double.TYPE);
        VariableAccessorGenerator.op(ops2, NativeType.ADDRESS, "Address", Long.TYPE);
        pointerOperations = Collections.unmodifiableMap(ops2);
        POINTER_OP_POINTER = new PointerOp("Pointer", Pointer.class);
    }

    private static final class PointerOp {
        private final String getMethodName;
        private final String putMethodName;
        final Class nativeIntClass;

        private PointerOp(String name2, Class nativeIntClass) {
            this.getMethodName = "get" + name2;
            this.putMethodName = "put" + name2;
            this.nativeIntClass = nativeIntClass;
        }

        void put(SkinnyMethodAdapter mv) {
            mv.invokevirtual(Pointer.class, this.putMethodName, Void.TYPE, Long.TYPE, this.nativeIntClass);
        }

        void get(SkinnyMethodAdapter mv) {
            mv.invokevirtual(Pointer.class, this.getMethodName, this.nativeIntClass, Long.TYPE);
        }
    }
}

