/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import java.lang.annotation.Annotation;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.nio.Buffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import jnr.ffi.Address;
import jnr.ffi.NativeType;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.Type;
import jnr.ffi.annotations.TypeDefinition;

class Types {
    private static Reference<Map<Class, Map<Collection<Annotation>, Type>>> typeCacheReference;

    Types() {
    }

    static Type getType(Runtime runtime, Class javaType2, Collection<Annotation> annotations2) {
        Map<Class, Map<Collection<Annotation>, Type>> cache2 = typeCacheReference != null ? typeCacheReference.get() : null;
        Map<Collection<Annotation>, Type> aliasCache = cache2 != null ? cache2.get(javaType2) : null;
        Type type = aliasCache != null ? aliasCache.get(annotations2) : null;
        return type != null ? type : Types.lookupAndCacheType(runtime, javaType2, annotations2);
    }

    private static synchronized Type lookupAndCacheType(Runtime runtime, Class javaType2, Collection<Annotation> annotations2) {
        Type type;
        HashMap cache2 = typeCacheReference != null ? typeCacheReference.get() : null;
        HashMap<Collection<Annotation>, Type> aliasCache = cache2 != null ? cache2.get(javaType2) : null;
        Type type2 = type = aliasCache != null ? aliasCache.get(annotations2) : null;
        if (type != null) {
            return type;
        }
        cache2 = new HashMap(cache2 != null ? cache2 : Collections.EMPTY_MAP);
        aliasCache = new HashMap<Collection<Annotation>, Type>(aliasCache != null ? aliasCache : Collections.EMPTY_MAP);
        type = Types.lookupType(runtime, javaType2, annotations2);
        aliasCache.put(annotations2, type);
        cache2.put(javaType2, Collections.unmodifiableMap(aliasCache));
        typeCacheReference = new SoftReference(Collections.unmodifiableMap(new IdentityHashMap(cache2)));
        return type;
    }

    private static Type lookupAliasedType(Runtime runtime, Collection<Annotation> annotations2) {
        for (Annotation a : annotations2) {
            TypeDefinition typedef = a.annotationType().getAnnotation(TypeDefinition.class);
            if (typedef == null) continue;
            return runtime.findType(typedef.alias());
        }
        return null;
    }

    static Type lookupType(Runtime runtime, Class type, Collection<Annotation> annotations2) {
        Type aliasedType;
        Type type2 = aliasedType = type.isArray() ? null : Types.lookupAliasedType(runtime, annotations2);
        if (aliasedType != null) {
            return aliasedType;
        }
        if (Void.class.isAssignableFrom(type) || Void.TYPE == type) {
            return runtime.findType(NativeType.VOID);
        }
        if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE == type) {
            return runtime.findType(NativeType.SINT);
        }
        if (Byte.class.isAssignableFrom(type) || Byte.TYPE == type) {
            return runtime.findType(NativeType.SCHAR);
        }
        if (Short.class.isAssignableFrom(type) || Short.TYPE == type) {
            return runtime.findType(NativeType.SSHORT);
        }
        if (Integer.class.isAssignableFrom(type) || Integer.TYPE == type) {
            return runtime.findType(NativeType.SINT);
        }
        if (Long.class.isAssignableFrom(type) || Long.TYPE == type) {
            return runtime.findType(NativeType.SLONG);
        }
        if (Float.class.isAssignableFrom(type) || Float.TYPE == type) {
            return runtime.findType(NativeType.FLOAT);
        }
        if (Double.class.isAssignableFrom(type) || Double.TYPE == type) {
            return runtime.findType(NativeType.DOUBLE);
        }
        if (Pointer.class.isAssignableFrom(type)) {
            return runtime.findType(NativeType.ADDRESS);
        }
        if (Address.class.isAssignableFrom(type)) {
            return runtime.findType(NativeType.ADDRESS);
        }
        if (Buffer.class.isAssignableFrom(type)) {
            return runtime.findType(NativeType.ADDRESS);
        }
        if (CharSequence.class.isAssignableFrom(type)) {
            return runtime.findType(NativeType.ADDRESS);
        }
        if (type.isArray()) {
            return runtime.findType(NativeType.ADDRESS);
        }
        throw new IllegalArgumentException("unsupported type: " + type);
    }
}

