/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.converters;

import jnr.ffi.NativeLong;
import jnr.ffi.mapper.ToNativeContext;
import jnr.ffi.mapper.ToNativeConverter;
import jnr.ffi.provider.ParameterFlags;

@ToNativeConverter.NoContext
@ToNativeConverter.Cacheable
public class NativeLong32ArrayParameterConverter
implements ToNativeConverter<NativeLong[], int[]> {
    private static final ToNativeConverter<NativeLong[], int[]> IN = new NativeLong32ArrayParameterConverter(2);
    private static final ToNativeConverter<NativeLong[], int[]> OUT = new Out(1);
    private static final ToNativeConverter<NativeLong[], int[]> INOUT = new Out(3);
    private final int parameterFlags;

    public static ToNativeConverter<NativeLong[], int[]> getInstance(ToNativeContext toNativeContext) {
        int parameterFlags = ParameterFlags.parse(toNativeContext.getAnnotations());
        return ParameterFlags.isOut(parameterFlags) ? (ParameterFlags.isIn(parameterFlags) ? INOUT : OUT) : IN;
    }

    NativeLong32ArrayParameterConverter(int parameterFlags) {
        this.parameterFlags = parameterFlags;
    }

    @Override
    public int[] toNative(NativeLong[] array2, ToNativeContext context) {
        if (array2 == null) {
            return null;
        }
        int[] primitive = new int[array2.length];
        if (ParameterFlags.isIn(this.parameterFlags)) {
            for (int i = 0; i < array2.length; ++i) {
                primitive[i] = array2[i] != null ? array2[i].intValue() : 0;
            }
        }
        return primitive;
    }

    @Override
    public Class<int[]> nativeType() {
        return int[].class;
    }

    public static final class Out
    extends NativeLong32ArrayParameterConverter
    implements ToNativeConverter.PostInvocation<NativeLong[], int[]> {
        Out(int parameterFlags) {
            super(parameterFlags);
        }

        @Override
        public void postInvoke(NativeLong[] array2, int[] primitive, ToNativeContext context) {
            if (array2 != null && primitive != null) {
                for (int i = 0; i < array2.length; ++i) {
                    array2[i] = NativeLong.valueOf(primitive[i]);
                }
            }
        }
    }
}

