/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.converters;

import jnr.ffi.mapper.ToNativeContext;
import jnr.ffi.mapper.ToNativeConverter;
import jnr.ffi.provider.ParameterFlags;

@ToNativeConverter.NoContext
@ToNativeConverter.Cacheable
public class BoxedShortArrayParameterConverter
implements ToNativeConverter<Short[], short[]> {
    private static final ToNativeConverter<Short[], short[]> IN = new BoxedShortArrayParameterConverter(2);
    private static final ToNativeConverter<Short[], short[]> OUT = new Out(1);
    private static final ToNativeConverter<Short[], short[]> INOUT = new Out(3);
    private final int parameterFlags;

    public static ToNativeConverter<Short[], short[]> getInstance(ToNativeContext toNativeContext) {
        int parameterFlags = ParameterFlags.parse(toNativeContext.getAnnotations());
        return ParameterFlags.isOut(parameterFlags) ? (ParameterFlags.isIn(parameterFlags) ? INOUT : OUT) : IN;
    }

    public BoxedShortArrayParameterConverter(int parameterFlags) {
        this.parameterFlags = parameterFlags;
    }

    @Override
    public short[] toNative(Short[] array2, ToNativeContext context) {
        if (array2 == null) {
            return null;
        }
        short[] primitive = new short[array2.length];
        if (ParameterFlags.isIn(this.parameterFlags)) {
            for (int i = 0; i < array2.length; ++i) {
                primitive[i] = array2[i] != null ? array2[i] : (short)0;
            }
        }
        return primitive;
    }

    @Override
    public Class<short[]> nativeType() {
        return short[].class;
    }

    public static final class Out
    extends BoxedShortArrayParameterConverter
    implements ToNativeConverter.PostInvocation<Short[], short[]> {
        Out(int parameterFlags) {
            super(parameterFlags);
        }

        @Override
        public void postInvoke(Short[] array2, short[] primitive, ToNativeContext context) {
            if (array2 != null && primitive != null) {
                for (int i = 0; i < array2.length; ++i) {
                    array2[i] = primitive[i];
                }
            }
        }
    }
}

