/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.converters;

import jnr.ffi.mapper.ToNativeContext;
import jnr.ffi.mapper.ToNativeConverter;
import jnr.ffi.provider.ParameterFlags;

@ToNativeConverter.NoContext
@ToNativeConverter.Cacheable
public class BoxedLong32ArrayParameterConverter
implements ToNativeConverter<Long[], int[]> {
    private static final ToNativeConverter<Long[], int[]> IN = new BoxedLong32ArrayParameterConverter(2);
    private static final ToNativeConverter<Long[], int[]> OUT = new Out(1);
    private static final ToNativeConverter<Long[], int[]> INOUT = new Out(3);
    private final int parameterFlags;

    public static ToNativeConverter<Long[], int[]> getInstance(ToNativeContext toNativeContext) {
        int parameterFlags = ParameterFlags.parse(toNativeContext.getAnnotations());
        return ParameterFlags.isOut(parameterFlags) ? (ParameterFlags.isIn(parameterFlags) ? INOUT : OUT) : IN;
    }

    public BoxedLong32ArrayParameterConverter(int parameterFlags) {
        this.parameterFlags = parameterFlags;
    }

    @Override
    public int[] toNative(Long[] array2, ToNativeContext context) {
        if (array2 == null) {
            return null;
        }
        int[] primitive = new int[array2.length];
        if (ParameterFlags.isIn(this.parameterFlags)) {
            for (int i = 0; i < array2.length; ++i) {
                primitive[i] = array2[i] != null ? array2[i].intValue() : 0;
            }
        }
        return primitive;
    }

    @Override
    public Class<int[]> nativeType() {
        return int[].class;
    }

    public static final class Out
    extends BoxedLong32ArrayParameterConverter
    implements ToNativeConverter.PostInvocation<Long[], int[]> {
        Out(int parameterFlags) {
            super(parameterFlags);
        }

        @Override
        public void postInvoke(Long[] array2, int[] primitive, ToNativeContext context) {
            if (array2 != null && primitive != null) {
                for (int i = 0; i < array2.length; ++i) {
                    array2[i] = primitive[i];
                }
            }
        }
    }
}

