/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.converters;

import jnr.ffi.mapper.ToNativeContext;
import jnr.ffi.mapper.ToNativeConverter;
import jnr.ffi.provider.ParameterFlags;

@ToNativeConverter.NoContext
@ToNativeConverter.Cacheable
public class BoxedIntegerArrayParameterConverter
implements ToNativeConverter<Integer[], int[]> {
    private static final ToNativeConverter<Integer[], int[]> IN = new BoxedIntegerArrayParameterConverter(2);
    private static final ToNativeConverter<Integer[], int[]> OUT = new Out(1);
    private static final ToNativeConverter<Integer[], int[]> INOUT = new Out(3);
    private final int parameterFlags;

    public static ToNativeConverter<Integer[], int[]> getInstance(ToNativeContext toNativeContext) {
        int parameterFlags = ParameterFlags.parse(toNativeContext.getAnnotations());
        return ParameterFlags.isOut(parameterFlags) ? (ParameterFlags.isIn(parameterFlags) ? INOUT : OUT) : IN;
    }

    public BoxedIntegerArrayParameterConverter(int parameterFlags) {
        this.parameterFlags = parameterFlags;
    }

    @Override
    public int[] toNative(Integer[] array2, ToNativeContext context) {
        if (array2 == null) {
            return null;
        }
        int[] primitive = new int[array2.length];
        if (ParameterFlags.isIn(this.parameterFlags)) {
            for (int i = 0; i < array2.length; ++i) {
                primitive[i] = array2[i] != null ? array2[i] : 0;
            }
        }
        return primitive;
    }

    @Override
    public Class<int[]> nativeType() {
        return int[].class;
    }

    public static final class Out
    extends BoxedIntegerArrayParameterConverter
    implements ToNativeConverter.PostInvocation<Integer[], int[]> {
        Out(int parameterFlags) {
            super(parameterFlags);
        }

        @Override
        public void postInvoke(Integer[] array2, int[] primitive, ToNativeContext context) {
            if (array2 != null && primitive != null) {
                for (int i = 0; i < array2.length; ++i) {
                    array2[i] = primitive[i];
                }
            }
        }
    }
}

