/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.InternalThreadLocalMap;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public final class StringUtil {
    public static final String EMPTY_STRING = "";
    public static final String NEWLINE = SystemPropertyUtil.get("line.separator", "\n");
    public static final char DOUBLE_QUOTE = '\"';
    public static final char COMMA = ',';
    public static final char LINE_FEED = '\n';
    public static final char CARRIAGE_RETURN = '\r';
    public static final char TAB = '\t';
    public static final char SPACE = ' ';
    private static final String[] BYTE2HEX_PAD = new String[256];
    private static final String[] BYTE2HEX_NOPAD = new String[256];
    private static final byte[] HEX2B;
    private static final int CSV_NUMBER_ESCAPE_CHARACTERS = 7;
    private static final char PACKAGE_SEPARATOR_CHAR = '.';

    private StringUtil() {
    }

    public static String substringAfter(String value2, char delim) {
        int pos = value2.indexOf(delim);
        if (pos >= 0) {
            return value2.substring(pos + 1);
        }
        return null;
    }

    public static boolean commonSuffixOfLength(String s2, String p, int len) {
        return s2 != null && p != null && len >= 0 && s2.regionMatches(s2.length() - len, p, p.length() - len, len);
    }

    public static String byteToHexStringPadded(int value2) {
        return BYTE2HEX_PAD[value2 & 0xFF];
    }

    public static <T extends Appendable> T byteToHexStringPadded(T buf, int value2) {
        try {
            buf.append(StringUtil.byteToHexStringPadded(value2));
        }
        catch (IOException e) {
            PlatformDependent.throwException(e);
        }
        return buf;
    }

    public static String toHexStringPadded(byte[] src) {
        return StringUtil.toHexStringPadded(src, 0, src.length);
    }

    public static String toHexStringPadded(byte[] src, int offset, int length) {
        return StringUtil.toHexStringPadded(new StringBuilder(length << 1), src, offset, length).toString();
    }

    public static <T extends Appendable> T toHexStringPadded(T dst, byte[] src) {
        return StringUtil.toHexStringPadded(dst, src, 0, src.length);
    }

    public static <T extends Appendable> T toHexStringPadded(T dst, byte[] src, int offset, int length) {
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            StringUtil.byteToHexStringPadded(dst, src[i]);
        }
        return dst;
    }

    public static String byteToHexString(int value2) {
        return BYTE2HEX_NOPAD[value2 & 0xFF];
    }

    public static <T extends Appendable> T byteToHexString(T buf, int value2) {
        try {
            buf.append(StringUtil.byteToHexString(value2));
        }
        catch (IOException e) {
            PlatformDependent.throwException(e);
        }
        return buf;
    }

    public static String toHexString(byte[] src) {
        return StringUtil.toHexString(src, 0, src.length);
    }

    public static String toHexString(byte[] src, int offset, int length) {
        return StringUtil.toHexString(new StringBuilder(length << 1), src, offset, length).toString();
    }

    public static <T extends Appendable> T toHexString(T dst, byte[] src) {
        return StringUtil.toHexString(dst, src, 0, src.length);
    }

    public static <T extends Appendable> T toHexString(T dst, byte[] src, int offset, int length) {
        int i;
        assert (length >= 0);
        if (length == 0) {
            return dst;
        }
        int end = offset + length;
        int endMinusOne = end - 1;
        for (i = offset; i < endMinusOne && src[i] == 0; ++i) {
        }
        StringUtil.byteToHexString(dst, src[i++]);
        int remaining = end - i;
        StringUtil.toHexStringPadded(dst, src, i, remaining);
        return dst;
    }

    public static int decodeHexNibble(char c) {
        assert (HEX2B.length == 65536);
        char index2 = c;
        return HEX2B[index2];
    }

    public static byte decodeHexByte(CharSequence s2, int pos) {
        int hi2 = StringUtil.decodeHexNibble(s2.charAt(pos));
        int lo2 = StringUtil.decodeHexNibble(s2.charAt(pos + 1));
        if (hi2 == -1 || lo2 == -1) {
            throw new IllegalArgumentException(String.format("invalid hex byte '%s' at index %d of '%s'", s2.subSequence(pos, pos + 2), pos, s2));
        }
        return (byte)((hi2 << 4) + lo2);
    }

    public static byte[] decodeHexDump(CharSequence hexDump, int fromIndex, int length) {
        if (length < 0 || (length & 1) != 0) {
            throw new IllegalArgumentException("length: " + length);
        }
        if (length == 0) {
            return EmptyArrays.EMPTY_BYTES;
        }
        byte[] bytes2 = new byte[length >>> 1];
        for (int i = 0; i < length; i += 2) {
            bytes2[i >>> 1] = StringUtil.decodeHexByte(hexDump, fromIndex + i);
        }
        return bytes2;
    }

    public static byte[] decodeHexDump(CharSequence hexDump) {
        return StringUtil.decodeHexDump(hexDump, 0, hexDump.length());
    }

    public static String simpleClassName(Object o) {
        if (o == null) {
            return "null_object";
        }
        return StringUtil.simpleClassName(o.getClass());
    }

    public static String simpleClassName(Class<?> clazz2) {
        String className2 = ObjectUtil.checkNotNull(clazz2, "clazz").getName();
        int lastDotIdx = className2.lastIndexOf(46);
        if (lastDotIdx > -1) {
            return className2.substring(lastDotIdx + 1);
        }
        return className2;
    }

    public static CharSequence escapeCsv(CharSequence value2) {
        return StringUtil.escapeCsv(value2, false);
    }

    public static CharSequence escapeCsv(CharSequence value2, boolean trimWhiteSpace) {
        int last2;
        int start;
        int length = ObjectUtil.checkNotNull(value2, "value").length();
        if (trimWhiteSpace) {
            start = StringUtil.indexOfFirstNonOwsChar(value2, length);
            last2 = StringUtil.indexOfLastNonOwsChar(value2, start, length);
        } else {
            start = 0;
            last2 = length - 1;
        }
        if (start > last2) {
            return EMPTY_STRING;
        }
        int firstUnescapedSpecial = -1;
        boolean quoted2 = false;
        if (StringUtil.isDoubleQuote(value2.charAt(start))) {
            boolean bl = quoted2 = StringUtil.isDoubleQuote(value2.charAt(last2)) && last2 > start;
            if (quoted2) {
                ++start;
                --last2;
            } else {
                firstUnescapedSpecial = start;
            }
        }
        if (firstUnescapedSpecial < 0) {
            int i;
            if (quoted2) {
                for (i = start; i <= last2; ++i) {
                    if (!StringUtil.isDoubleQuote(value2.charAt(i))) continue;
                    if (i == last2 || !StringUtil.isDoubleQuote(value2.charAt(i + 1))) {
                        firstUnescapedSpecial = i;
                        break;
                    }
                    ++i;
                }
            } else {
                for (i = start; i <= last2; ++i) {
                    char c = value2.charAt(i);
                    if (c == '\n' || c == '\r' || c == ',') {
                        firstUnescapedSpecial = i;
                        break;
                    }
                    if (!StringUtil.isDoubleQuote(c)) continue;
                    if (i == last2 || !StringUtil.isDoubleQuote(value2.charAt(i + 1))) {
                        firstUnescapedSpecial = i;
                        break;
                    }
                    ++i;
                }
            }
            if (firstUnescapedSpecial < 0) {
                return quoted2 ? value2.subSequence(start - 1, last2 + 2) : value2.subSequence(start, last2 + 1);
            }
        }
        StringBuilder result2 = new StringBuilder(last2 - start + 1 + 7);
        result2.append('\"').append(value2, start, firstUnescapedSpecial);
        for (int i = firstUnescapedSpecial; i <= last2; ++i) {
            char c = value2.charAt(i);
            if (StringUtil.isDoubleQuote(c)) {
                result2.append('\"');
                if (i < last2 && StringUtil.isDoubleQuote(value2.charAt(i + 1))) {
                    ++i;
                }
            }
            result2.append(c);
        }
        return result2.append('\"');
    }

    public static CharSequence unescapeCsv(CharSequence value2) {
        boolean quoted2;
        int length = ObjectUtil.checkNotNull(value2, "value").length();
        if (length == 0) {
            return value2;
        }
        int last2 = length - 1;
        boolean bl = quoted2 = StringUtil.isDoubleQuote(value2.charAt(0)) && StringUtil.isDoubleQuote(value2.charAt(last2)) && length != 1;
        if (!quoted2) {
            StringUtil.validateCsvFormat(value2);
            return value2;
        }
        StringBuilder unescaped = InternalThreadLocalMap.get().stringBuilder();
        for (int i = 1; i < last2; ++i) {
            char current = value2.charAt(i);
            if (current == '\"') {
                if (StringUtil.isDoubleQuote(value2.charAt(i + 1)) && i + 1 != last2) {
                    ++i;
                } else {
                    throw StringUtil.newInvalidEscapedCsvFieldException(value2, i);
                }
            }
            unescaped.append(current);
        }
        return unescaped.toString();
    }

    public static List<CharSequence> unescapeCsvFields(CharSequence value2) {
        ArrayList<CharSequence> unescaped = new ArrayList<CharSequence>(2);
        StringBuilder current = InternalThreadLocalMap.get().stringBuilder();
        boolean quoted2 = false;
        int last2 = value2.length() - 1;
        block8: for (int i = 0; i <= last2; ++i) {
            char c = value2.charAt(i);
            if (quoted2) {
                switch (c) {
                    case '\"': {
                        char next2;
                        if (i == last2) {
                            unescaped.add(current.toString());
                            return unescaped;
                        }
                        if ((next2 = value2.charAt(++i)) == '\"') {
                            current.append('\"');
                            break;
                        }
                        if (next2 == ',') {
                            quoted2 = false;
                            unescaped.add(current.toString());
                            current.setLength(0);
                            break;
                        }
                        throw StringUtil.newInvalidEscapedCsvFieldException(value2, i - 1);
                    }
                    default: {
                        current.append(c);
                        break;
                    }
                }
                continue;
            }
            switch (c) {
                case ',': {
                    unescaped.add(current.toString());
                    current.setLength(0);
                    continue block8;
                }
                case '\"': {
                    if (current.length() == 0) {
                        quoted2 = true;
                        continue block8;
                    }
                }
                case '\n': 
                case '\r': {
                    throw StringUtil.newInvalidEscapedCsvFieldException(value2, i);
                }
                default: {
                    current.append(c);
                }
            }
        }
        if (quoted2) {
            throw StringUtil.newInvalidEscapedCsvFieldException(value2, last2);
        }
        unescaped.add(current.toString());
        return unescaped;
    }

    private static void validateCsvFormat(CharSequence value2) {
        int length = value2.length();
        for (int i = 0; i < length; ++i) {
            switch (value2.charAt(i)) {
                case '\n': 
                case '\r': 
                case '\"': 
                case ',': {
                    throw StringUtil.newInvalidEscapedCsvFieldException(value2, i);
                }
            }
        }
    }

    private static IllegalArgumentException newInvalidEscapedCsvFieldException(CharSequence value2, int index2) {
        return new IllegalArgumentException("invalid escaped CSV field: " + value2 + " index: " + index2);
    }

    public static int length(String s2) {
        return s2 == null ? 0 : s2.length();
    }

    public static boolean isNullOrEmpty(String s2) {
        return s2 == null || s2.isEmpty();
    }

    public static int indexOfNonWhiteSpace(CharSequence seq, int offset) {
        while (offset < seq.length()) {
            if (!Character.isWhitespace(seq.charAt(offset))) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    public static int indexOfWhiteSpace(CharSequence seq, int offset) {
        while (offset < seq.length()) {
            if (Character.isWhitespace(seq.charAt(offset))) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    public static boolean isSurrogate(char c) {
        return c >= '\ud800' && c <= '\udfff';
    }

    private static boolean isDoubleQuote(char c) {
        return c == '\"';
    }

    public static boolean endsWith(CharSequence s2, char c) {
        int len = s2.length();
        return len > 0 && s2.charAt(len - 1) == c;
    }

    public static CharSequence trimOws(CharSequence value2) {
        int length = value2.length();
        if (length == 0) {
            return value2;
        }
        int start = StringUtil.indexOfFirstNonOwsChar(value2, length);
        int end = StringUtil.indexOfLastNonOwsChar(value2, start, length);
        return start == 0 && end == length - 1 ? value2 : value2.subSequence(start, end + 1);
    }

    public static CharSequence join(CharSequence separator, Iterable<? extends CharSequence> elements) {
        ObjectUtil.checkNotNull(separator, "separator");
        ObjectUtil.checkNotNull(elements, "elements");
        Iterator<? extends CharSequence> iterator2 = elements.iterator();
        if (!iterator2.hasNext()) {
            return EMPTY_STRING;
        }
        CharSequence firstElement = iterator2.next();
        if (!iterator2.hasNext()) {
            return firstElement;
        }
        StringBuilder builder = new StringBuilder(firstElement);
        do {
            builder.append(separator).append(iterator2.next());
        } while (iterator2.hasNext());
        return builder;
    }

    private static int indexOfFirstNonOwsChar(CharSequence value2, int length) {
        int i;
        for (i = 0; i < length && StringUtil.isOws(value2.charAt(i)); ++i) {
        }
        return i;
    }

    private static int indexOfLastNonOwsChar(CharSequence value2, int start, int length) {
        int i;
        for (i = length - 1; i > start && StringUtil.isOws(value2.charAt(i)); --i) {
        }
        return i;
    }

    private static boolean isOws(char c) {
        return c == ' ' || c == '\t';
    }

    static {
        for (int i = 0; i < BYTE2HEX_PAD.length; ++i) {
            String str = Integer.toHexString(i);
            StringUtil.BYTE2HEX_PAD[i] = i > 15 ? str : '0' + str;
            StringUtil.BYTE2HEX_NOPAD[i] = str;
        }
        HEX2B = new byte[65536];
        Arrays.fill(HEX2B, (byte)-1);
        StringUtil.HEX2B[48] = 0;
        StringUtil.HEX2B[49] = 1;
        StringUtil.HEX2B[50] = 2;
        StringUtil.HEX2B[51] = 3;
        StringUtil.HEX2B[52] = 4;
        StringUtil.HEX2B[53] = 5;
        StringUtil.HEX2B[54] = 6;
        StringUtil.HEX2B[55] = 7;
        StringUtil.HEX2B[56] = 8;
        StringUtil.HEX2B[57] = 9;
        StringUtil.HEX2B[65] = 10;
        StringUtil.HEX2B[66] = 11;
        StringUtil.HEX2B[67] = 12;
        StringUtil.HEX2B[68] = 13;
        StringUtil.HEX2B[69] = 14;
        StringUtil.HEX2B[70] = 15;
        StringUtil.HEX2B[97] = 10;
        StringUtil.HEX2B[98] = 11;
        StringUtil.HEX2B[99] = 12;
        StringUtil.HEX2B[100] = 13;
        StringUtil.HEX2B[101] = 14;
        StringUtil.HEX2B[102] = 15;
    }
}

