/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl.util;

import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.handler.ssl.util.SimpleTrustManagerFactory;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public final class FingerprintTrustManagerFactory
extends SimpleTrustManagerFactory {
    private static final Pattern FINGERPRINT_PATTERN = Pattern.compile("^[0-9a-fA-F:]+$");
    private static final Pattern FINGERPRINT_STRIP_PATTERN = Pattern.compile(":");
    private static final int SHA1_BYTE_LEN = 20;
    private static final int SHA1_HEX_LEN = 40;
    private static final FastThreadLocal<MessageDigest> tlmd = new FastThreadLocal<MessageDigest>(){

        @Override
        protected MessageDigest initialValue() {
            try {
                return MessageDigest.getInstance("SHA1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new Error(e);
            }
        }
    };
    private final TrustManager tm = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain2, String s2) throws CertificateException {
            this.checkTrusted("client", chain2);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain2, String s2) throws CertificateException {
            this.checkTrusted("server", chain2);
        }

        private void checkTrusted(String type, X509Certificate[] chain2) throws CertificateException {
            X509Certificate cert = chain2[0];
            byte[] fingerprint = this.fingerprint(cert);
            boolean found = false;
            for (byte[] allowedFingerprint : FingerprintTrustManagerFactory.this.fingerprints) {
                if (!Arrays.equals(fingerprint, allowedFingerprint)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new CertificateException(type + " certificate with unknown fingerprint: " + cert.getSubjectDN());
            }
        }

        private byte[] fingerprint(X509Certificate cert) throws CertificateEncodingException {
            MessageDigest md = (MessageDigest)tlmd.get();
            md.reset();
            return md.digest(cert.getEncoded());
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return EmptyArrays.EMPTY_X509_CERTIFICATES;
        }
    };
    private final byte[][] fingerprints;

    public FingerprintTrustManagerFactory(Iterable<String> fingerprints) {
        this(FingerprintTrustManagerFactory.toFingerprintArray(fingerprints));
    }

    public FingerprintTrustManagerFactory(String ... fingerprints) {
        this(FingerprintTrustManagerFactory.toFingerprintArray(Arrays.asList(fingerprints)));
    }

    public FingerprintTrustManagerFactory(byte[] ... fingerprints) {
        ObjectUtil.checkNotNull(fingerprints, "fingerprints");
        ArrayList<Object> list2 = new ArrayList<Object>(fingerprints.length);
        for (byte[] f2 : fingerprints) {
            if (f2 == null) break;
            if (f2.length != 20) {
                throw new IllegalArgumentException("malformed fingerprint: " + ByteBufUtil.hexDump(Unpooled.wrappedBuffer(f2)) + " (expected: SHA1)");
            }
            list2.add(f2.clone());
        }
        this.fingerprints = (byte[][])list2.toArray((T[])new byte[0][]);
    }

    private static byte[][] toFingerprintArray(Iterable<String> fingerprints) {
        ObjectUtil.checkNotNull(fingerprints, "fingerprints");
        ArrayList<byte[]> list2 = new ArrayList<byte[]>();
        for (String f2 : fingerprints) {
            if (f2 == null) break;
            if (!FINGERPRINT_PATTERN.matcher(f2).matches()) {
                throw new IllegalArgumentException("malformed fingerprint: " + f2);
            }
            if ((f2 = FINGERPRINT_STRIP_PATTERN.matcher(f2).replaceAll("")).length() != 40) {
                throw new IllegalArgumentException("malformed fingerprint: " + f2 + " (expected: SHA1)");
            }
            list2.add(StringUtil.decodeHexDump(f2));
        }
        return (byte[][])list2.toArray((T[])new byte[0][]);
    }

    @Override
    protected void engineInit(KeyStore keyStore) throws Exception {
    }

    @Override
    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws Exception {
    }

    @Override
    protected TrustManager[] engineGetTrustManagers() {
        return new TrustManager[]{this.tm};
    }
}

