/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class SignatureAlgorithmConverter {
    private static final Pattern PATTERN = Pattern.compile("(?:(^[a-zA-Z].+)With(.+)Encryption$)|(?:(^[a-zA-Z].+)(?:_with_|-with-|_pkcs1_|_pss_rsae_)(.+$))|(?:(^[a-zA-Z].+)_(.+$))");

    private SignatureAlgorithmConverter() {
    }

    static String toJavaName(String opensslName) {
        if (opensslName == null) {
            return null;
        }
        Matcher matcher2 = PATTERN.matcher(opensslName);
        if (matcher2.matches()) {
            String group1 = matcher2.group(1);
            if (group1 != null) {
                return group1.toUpperCase(Locale.ROOT) + "with" + matcher2.group(2).toUpperCase(Locale.ROOT);
            }
            if (matcher2.group(3) != null) {
                return matcher2.group(4).toUpperCase(Locale.ROOT) + "with" + matcher2.group(3).toUpperCase(Locale.ROOT);
            }
            if (matcher2.group(5) != null) {
                return matcher2.group(6).toUpperCase(Locale.ROOT) + "with" + matcher2.group(5).toUpperCase(Locale.ROOT);
            }
        }
        return null;
    }
}

