/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.AbstractUnsafeSwappedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.util.internal.PlatformDependent;

final class UnsafeHeapSwappedByteBuf
extends AbstractUnsafeSwappedByteBuf {
    UnsafeHeapSwappedByteBuf(AbstractByteBuf buf) {
        super(buf);
    }

    private static int idx(ByteBuf wrapped2, int index2) {
        return wrapped2.arrayOffset() + index2;
    }

    @Override
    protected long _getLong(AbstractByteBuf wrapped2, int index2) {
        return PlatformDependent.getLong(wrapped2.array(), UnsafeHeapSwappedByteBuf.idx(wrapped2, index2));
    }

    @Override
    protected int _getInt(AbstractByteBuf wrapped2, int index2) {
        return PlatformDependent.getInt(wrapped2.array(), UnsafeHeapSwappedByteBuf.idx(wrapped2, index2));
    }

    @Override
    protected short _getShort(AbstractByteBuf wrapped2, int index2) {
        return PlatformDependent.getShort(wrapped2.array(), UnsafeHeapSwappedByteBuf.idx(wrapped2, index2));
    }

    @Override
    protected void _setShort(AbstractByteBuf wrapped2, int index2, short value2) {
        PlatformDependent.putShort(wrapped2.array(), UnsafeHeapSwappedByteBuf.idx(wrapped2, index2), value2);
    }

    @Override
    protected void _setInt(AbstractByteBuf wrapped2, int index2, int value2) {
        PlatformDependent.putInt(wrapped2.array(), UnsafeHeapSwappedByteBuf.idx(wrapped2, index2), value2);
    }

    @Override
    protected void _setLong(AbstractByteBuf wrapped2, int index2, long value2) {
        PlatformDependent.putLong(wrapped2.array(), UnsafeHeapSwappedByteBuf.idx(wrapped2, index2), value2);
    }
}

