/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjarpicocli.groovy;

import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import groovyjarjarpicocli.CommandLine;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PicocliBaseScript
extends Script {
    public static final String COMMAND_LINE = "commandLine";

    protected abstract Object runScriptBody();

    @Override
    public Object run() {
        String[] args2 = this.getScriptArguments();
        CommandLine commandLine2 = this.getOrCreateCommandLine();
        List<CommandLine> parsedCommands = null;
        try {
            parsedCommands = this.parseScriptArguments(commandLine2, args2);
        }
        catch (CommandLine.ParameterException pe) {
            return this.handleParameterException(pe, args2);
        }
        try {
            for (CommandLine parsed : parsedCommands) {
                if (parsed.isUsageHelpRequested()) {
                    return this.printHelpMessage(parsed, System.out);
                }
                if (!parsed.isVersionHelpRequested()) continue;
                return this.printVersionHelpMessage(parsed);
            }
            this.runRunnableSubcommand(parsedCommands);
            return this.runScriptBody();
        }
        catch (Exception ex) {
            return this.handleExecutionException(commandLine2, args2, ex);
        }
    }

    public String[] getScriptArguments() {
        return (String[])this.getProperty("args");
    }

    protected CommandLine getOrCreateCommandLine() {
        try {
            CommandLine commandLine2 = (CommandLine)this.getProperty(COMMAND_LINE);
            if (commandLine2 == null) {
                commandLine2 = this.createCommandLine();
                this.getMetaClass().setProperty(this, COMMAND_LINE, commandLine2);
            }
            return commandLine2;
        }
        catch (MissingPropertyException mpe) {
            CommandLine commandLine3 = this.createCommandLine();
            this.setProperty(COMMAND_LINE, commandLine3);
            return commandLine3;
        }
    }

    public CommandLine createCommandLine() {
        CommandLine commandLine2 = new CommandLine(this);
        if (commandLine2.getCommandName().equals("<main class>")) {
            commandLine2.setCommandName(this.getClass().getSimpleName());
        }
        return commandLine2;
    }

    public List<CommandLine> parseScriptArguments(CommandLine commandLine2, String[] args2) {
        return commandLine2.parse(args2);
    }

    public void runRunnableSubcommand(List<CommandLine> parsedCommands) throws Exception {
        CommandLine deepestSubcommand = parsedCommands.get(parsedCommands.size() - 1);
        Object commandObject = deepestSubcommand.getCommand();
        if (commandObject == this) {
            return;
        }
        if (commandObject instanceof Runnable) {
            ((Runnable)commandObject).run();
        } else if (commandObject instanceof Callable) {
            ((Callable)commandObject).call();
        }
    }

    public void printErrorMessage(String message) {
        System.err.println(message);
    }

    public Object handleParameterException(CommandLine.ParameterException pe, String[] args2) {
        this.printErrorMessage(String.format("args: %s%n%s", Arrays.toString(args2), pe.getMessage()));
        this.printHelpMessage(pe.getCommandLine());
        return 1;
    }

    public Object handleExecutionException(CommandLine commandLine2, String[] args2, Exception ex) {
        if (ex instanceof CommandLine.ExecutionException) {
            throw (CommandLine.ExecutionException)ex;
        }
        throw new CommandLine.ExecutionException(commandLine2, ex.toString(), ex);
    }

    public Object printHelpMessage(CommandLine commandLine2) {
        return this.printHelpMessage(commandLine2, System.err);
    }

    public Object printHelpMessage(CommandLine commandLine2, PrintStream stream) {
        commandLine2.usage(stream);
        return null;
    }

    public Object printVersionHelpMessage(CommandLine commandLine2) {
        commandLine2.printVersionHelp(System.out);
        return null;
    }
}

