/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjarcommonscli;

final class OptionValidator {
    OptionValidator() {
    }

    static void validateOption(String opt2) throws IllegalArgumentException {
        if (opt2 == null) {
            return;
        }
        if (opt2.length() == 1) {
            char ch = opt2.charAt(0);
            if (!OptionValidator.isValidOpt(ch)) {
                throw new IllegalArgumentException("Illegal option name '" + ch + "'");
            }
        } else {
            for (char ch : opt2.toCharArray()) {
                if (OptionValidator.isValidChar(ch)) continue;
                throw new IllegalArgumentException("The option '" + opt2 + "' contains an illegal character : '" + ch + "'");
            }
        }
    }

    private static boolean isValidOpt(char c) {
        return OptionValidator.isValidChar(c) || c == '?' || c == '@';
    }

    private static boolean isValidChar(char c) {
        return Character.isJavaIdentifierPart(c);
    }
}

