/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjarcommonscli;

import groovyjarjarcommonscli.AlreadySelectedException;
import groovyjarjarcommonscli.Option;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, Option> optionMap = new LinkedHashMap<String, Option>();
    private String selected;
    private boolean required;

    public OptionGroup addOption(Option option2) {
        this.optionMap.put(option2.getKey(), option2);
        return this;
    }

    public Collection<String> getNames() {
        return this.optionMap.keySet();
    }

    public Collection<Option> getOptions() {
        return this.optionMap.values();
    }

    public void setSelected(Option option2) throws AlreadySelectedException {
        if (option2 == null) {
            this.selected = null;
            return;
        }
        if (this.selected != null && !this.selected.equals(option2.getKey())) {
            throw new AlreadySelectedException(this, option2);
        }
        this.selected = option2.getKey();
    }

    public String getSelected() {
        return this.selected;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        Iterator<Option> iter2 = this.getOptions().iterator();
        buff.append("[");
        while (iter2.hasNext()) {
            Option option2 = iter2.next();
            if (option2.getOpt() != null) {
                buff.append("-");
                buff.append(option2.getOpt());
            } else {
                buff.append("--");
                buff.append(option2.getLongOpt());
            }
            if (option2.getDescription() != null) {
                buff.append(" ");
                buff.append(option2.getDescription());
            }
            if (!iter2.hasNext()) continue;
            buff.append(", ");
        }
        buff.append("]");
        return buff.toString();
    }
}

