/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjarcommonscli;

import groovyjarjarcommonscli.AlreadySelectedException;
import groovyjarjarcommonscli.AmbiguousOptionException;
import groovyjarjarcommonscli.CommandLine;
import groovyjarjarcommonscli.CommandLineParser;
import groovyjarjarcommonscli.MissingArgumentException;
import groovyjarjarcommonscli.MissingOptionException;
import groovyjarjarcommonscli.Option;
import groovyjarjarcommonscli.OptionGroup;
import groovyjarjarcommonscli.Options;
import groovyjarjarcommonscli.ParseException;
import groovyjarjarcommonscli.UnrecognizedOptionException;
import groovyjarjarcommonscli.Util;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public class DefaultParser
implements CommandLineParser {
    protected CommandLine cmd;
    protected Options options;
    protected boolean stopAtNonOption;
    protected String currentToken;
    protected Option currentOption;
    protected boolean skipParsing;
    protected List expectedOpts;

    public CommandLine parse(Options options, String[] arguments) throws ParseException {
        return this.parse(options, arguments, null);
    }

    public CommandLine parse(Options options, String[] arguments, Properties properties2) throws ParseException {
        return this.parse(options, arguments, properties2, false);
    }

    public CommandLine parse(Options options, String[] arguments, boolean stopAtNonOption) throws ParseException {
        return this.parse(options, arguments, null, stopAtNonOption);
    }

    public CommandLine parse(Options options, String[] arguments, Properties properties2, boolean stopAtNonOption) throws ParseException {
        this.options = options;
        this.stopAtNonOption = stopAtNonOption;
        this.skipParsing = false;
        this.currentOption = null;
        this.expectedOpts = new ArrayList(options.getRequiredOptions());
        for (OptionGroup group : options.getOptionGroups()) {
            group.setSelected(null);
        }
        this.cmd = new CommandLine();
        if (arguments != null) {
            for (String argument2 : arguments) {
                this.handleToken(argument2);
            }
        }
        this.checkRequiredArgs();
        this.handleProperties(properties2);
        this.checkRequiredOptions();
        return this.cmd;
    }

    private void handleProperties(Properties properties2) throws ParseException {
        if (properties2 == null) {
            return;
        }
        Enumeration<?> e = properties2.propertyNames();
        while (e.hasMoreElements()) {
            boolean selected;
            String option2 = e.nextElement().toString();
            Option opt2 = this.options.getOption(option2);
            if (opt2 == null) {
                throw new UnrecognizedOptionException("Default option wasn't defined", option2);
            }
            OptionGroup group = this.options.getOptionGroup(opt2);
            boolean bl = selected = group != null && group.getSelected() != null;
            if (this.cmd.hasOption(option2) || selected) continue;
            String value2 = properties2.getProperty(option2);
            if (opt2.hasArg()) {
                if (opt2.getValues() == null || opt2.getValues().length == 0) {
                    opt2.addValueForProcessing(value2);
                }
            } else if (!"yes".equalsIgnoreCase(value2) && !"true".equalsIgnoreCase(value2) && !"1".equalsIgnoreCase(value2)) continue;
            this.handleOption(opt2);
            this.currentOption = null;
        }
    }

    private void checkRequiredOptions() throws MissingOptionException {
        if (!this.expectedOpts.isEmpty()) {
            throw new MissingOptionException(this.expectedOpts);
        }
    }

    private void checkRequiredArgs() throws ParseException {
        if (this.currentOption != null && this.currentOption.requiresArg()) {
            throw new MissingArgumentException(this.currentOption);
        }
    }

    private void handleToken(String token2) throws ParseException {
        this.currentToken = token2;
        if (this.skipParsing) {
            this.cmd.addArg(token2);
        } else if ("--".equals(token2)) {
            this.skipParsing = true;
        } else if (this.currentOption != null && this.currentOption.acceptsArg() && this.isArgument(token2)) {
            this.currentOption.addValueForProcessing(Util.stripLeadingAndTrailingQuotes(token2));
        } else if (token2.startsWith("--")) {
            this.handleLongOption(token2);
        } else if (token2.startsWith("-") && !"-".equals(token2)) {
            this.handleShortAndLongOption(token2);
        } else {
            this.handleUnknownToken(token2);
        }
        if (this.currentOption != null && !this.currentOption.acceptsArg()) {
            this.currentOption = null;
        }
    }

    private boolean isArgument(String token2) {
        return !this.isOption(token2) || this.isNegativeNumber(token2);
    }

    private boolean isNegativeNumber(String token2) {
        try {
            Double.parseDouble(token2);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isOption(String token2) {
        return this.isLongOption(token2) || this.isShortOption(token2);
    }

    private boolean isShortOption(String token2) {
        String optName;
        if (!token2.startsWith("-") || token2.length() == 1) {
            return false;
        }
        int pos = token2.indexOf("=");
        String string2 = optName = pos == -1 ? token2.substring(1) : token2.substring(1, pos);
        if (this.options.hasShortOption(optName)) {
            return true;
        }
        return optName.length() > 0 && this.options.hasShortOption(String.valueOf(optName.charAt(0)));
    }

    private boolean isLongOption(String token2) {
        String t;
        if (!token2.startsWith("-") || token2.length() == 1) {
            return false;
        }
        int pos = token2.indexOf("=");
        String string2 = t = pos == -1 ? token2 : token2.substring(0, pos);
        if (!this.options.getMatchingOptions(t).isEmpty()) {
            return true;
        }
        return this.getLongPrefix(token2) != null && !token2.startsWith("--");
    }

    private void handleUnknownToken(String token2) throws ParseException {
        if (token2.startsWith("-") && token2.length() > 1 && !this.stopAtNonOption) {
            throw new UnrecognizedOptionException("Unrecognized option: " + token2, token2);
        }
        this.cmd.addArg(token2);
        if (this.stopAtNonOption) {
            this.skipParsing = true;
        }
    }

    private void handleLongOption(String token2) throws ParseException {
        if (token2.indexOf(61) == -1) {
            this.handleLongOptionWithoutEqual(token2);
        } else {
            this.handleLongOptionWithEqual(token2);
        }
    }

    private void handleLongOptionWithoutEqual(String token2) throws ParseException {
        List<String> matchingOpts = this.options.getMatchingOptions(token2);
        if (matchingOpts.isEmpty()) {
            this.handleUnknownToken(this.currentToken);
        } else {
            if (matchingOpts.size() > 1) {
                throw new AmbiguousOptionException(token2, matchingOpts);
            }
            this.handleOption(this.options.getOption(matchingOpts.get(0)));
        }
    }

    private void handleLongOptionWithEqual(String token2) throws ParseException {
        int pos = token2.indexOf(61);
        String value2 = token2.substring(pos + 1);
        String opt2 = token2.substring(0, pos);
        List<String> matchingOpts = this.options.getMatchingOptions(opt2);
        if (matchingOpts.isEmpty()) {
            this.handleUnknownToken(this.currentToken);
        } else {
            if (matchingOpts.size() > 1) {
                throw new AmbiguousOptionException(opt2, matchingOpts);
            }
            Option option2 = this.options.getOption(matchingOpts.get(0));
            if (option2.acceptsArg()) {
                this.handleOption(option2);
                this.currentOption.addValueForProcessing(value2);
                this.currentOption = null;
            } else {
                this.handleUnknownToken(this.currentToken);
            }
        }
    }

    private void handleShortAndLongOption(String token2) throws ParseException {
        String t = Util.stripLeadingHyphens(token2);
        int pos = t.indexOf(61);
        if (t.length() == 1) {
            if (this.options.hasShortOption(t)) {
                this.handleOption(this.options.getOption(t));
            } else {
                this.handleUnknownToken(token2);
            }
        } else if (pos == -1) {
            if (this.options.hasShortOption(t)) {
                this.handleOption(this.options.getOption(t));
            } else if (!this.options.getMatchingOptions(t).isEmpty()) {
                this.handleLongOptionWithoutEqual(token2);
            } else {
                String opt2 = this.getLongPrefix(t);
                if (opt2 != null && this.options.getOption(opt2).acceptsArg()) {
                    this.handleOption(this.options.getOption(opt2));
                    this.currentOption.addValueForProcessing(t.substring(opt2.length()));
                    this.currentOption = null;
                } else if (this.isJavaProperty(t)) {
                    this.handleOption(this.options.getOption(t.substring(0, 1)));
                    this.currentOption.addValueForProcessing(t.substring(1));
                    this.currentOption = null;
                } else {
                    this.handleConcatenatedOptions(token2);
                }
            }
        } else {
            String opt3 = t.substring(0, pos);
            String value2 = t.substring(pos + 1);
            if (opt3.length() == 1) {
                Option option2 = this.options.getOption(opt3);
                if (option2 != null && option2.acceptsArg()) {
                    this.handleOption(option2);
                    this.currentOption.addValueForProcessing(value2);
                    this.currentOption = null;
                } else {
                    this.handleUnknownToken(token2);
                }
            } else if (this.isJavaProperty(opt3)) {
                this.handleOption(this.options.getOption(opt3.substring(0, 1)));
                this.currentOption.addValueForProcessing(opt3.substring(1));
                this.currentOption.addValueForProcessing(value2);
                this.currentOption = null;
            } else {
                this.handleLongOptionWithEqual(token2);
            }
        }
    }

    private String getLongPrefix(String token2) {
        String t = Util.stripLeadingHyphens(token2);
        String opt2 = null;
        for (int i = t.length() - 2; i > 1; --i) {
            String prefix = t.substring(0, i);
            if (!this.options.hasLongOption(prefix)) continue;
            opt2 = prefix;
            break;
        }
        return opt2;
    }

    private boolean isJavaProperty(String token2) {
        String opt2 = token2.substring(0, 1);
        Option option2 = this.options.getOption(opt2);
        return option2 != null && (option2.getArgs() >= 2 || option2.getArgs() == -2);
    }

    private void handleOption(Option option2) throws ParseException {
        this.checkRequiredArgs();
        option2 = (Option)option2.clone();
        this.updateRequiredOptions(option2);
        this.cmd.addOption(option2);
        this.currentOption = option2.hasArg() ? option2 : null;
    }

    private void updateRequiredOptions(Option option2) throws AlreadySelectedException {
        if (option2.isRequired()) {
            this.expectedOpts.remove(option2.getKey());
        }
        if (this.options.getOptionGroup(option2) != null) {
            OptionGroup group = this.options.getOptionGroup(option2);
            if (group.isRequired()) {
                this.expectedOpts.remove(group);
            }
            group.setSelected(option2);
        }
    }

    protected void handleConcatenatedOptions(String token2) throws ParseException {
        for (int i = 1; i < token2.length(); ++i) {
            String ch = String.valueOf(token2.charAt(i));
            if (this.options.hasOption(ch)) {
                this.handleOption(this.options.getOption(ch));
                if (this.currentOption == null || token2.length() == i + 1) continue;
                this.currentOption.addValueForProcessing(token2.substring(i + 1));
                break;
            }
            this.handleUnknownToken(this.stopAtNonOption && i > 1 ? token2.substring(i) : token2);
            break;
        }
    }
}

