/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjarcommonscli;

import groovyjarjarcommonscli.Option;
import groovyjarjarcommonscli.ParseException;
import groovyjarjarcommonscli.TypeHandler;
import groovyjarjarcommonscli.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLine
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<String> args = new LinkedList<String>();
    private final List<Option> options = new ArrayList<Option>();

    protected CommandLine() {
    }

    public boolean hasOption(String opt2) {
        return this.options.contains(this.resolveOption(opt2));
    }

    public boolean hasOption(char opt2) {
        return this.hasOption(String.valueOf(opt2));
    }

    @Deprecated
    public Object getOptionObject(String opt2) {
        try {
            return this.getParsedOptionValue(opt2);
        }
        catch (ParseException pe) {
            System.err.println("Exception found converting " + opt2 + " to desired type: " + pe.getMessage());
            return null;
        }
    }

    public Object getParsedOptionValue(String opt2) throws ParseException {
        String res = this.getOptionValue(opt2);
        Option option2 = this.resolveOption(opt2);
        if (option2 == null || res == null) {
            return null;
        }
        return TypeHandler.createValue(res, option2.getType());
    }

    public Object getOptionObject(char opt2) {
        return this.getOptionObject(String.valueOf(opt2));
    }

    public String getOptionValue(String opt2) {
        String[] values2 = this.getOptionValues(opt2);
        return values2 == null ? null : values2[0];
    }

    public String getOptionValue(char opt2) {
        return this.getOptionValue(String.valueOf(opt2));
    }

    public String[] getOptionValues(String opt2) {
        ArrayList<String> values2 = new ArrayList<String>();
        for (Option option2 : this.options) {
            if (!opt2.equals(option2.getOpt()) && !opt2.equals(option2.getLongOpt())) continue;
            values2.addAll(option2.getValuesList());
        }
        return values2.isEmpty() ? null : values2.toArray(new String[values2.size()]);
    }

    private Option resolveOption(String opt2) {
        opt2 = Util.stripLeadingHyphens(opt2);
        for (Option option2 : this.options) {
            if (opt2.equals(option2.getOpt())) {
                return option2;
            }
            if (!opt2.equals(option2.getLongOpt())) continue;
            return option2;
        }
        return null;
    }

    public String[] getOptionValues(char opt2) {
        return this.getOptionValues(String.valueOf(opt2));
    }

    public String getOptionValue(String opt2, String defaultValue2) {
        String answer = this.getOptionValue(opt2);
        return answer != null ? answer : defaultValue2;
    }

    public String getOptionValue(char opt2, String defaultValue2) {
        return this.getOptionValue(String.valueOf(opt2), defaultValue2);
    }

    public Properties getOptionProperties(String opt2) {
        Properties props = new Properties();
        for (Option option2 : this.options) {
            if (!opt2.equals(option2.getOpt()) && !opt2.equals(option2.getLongOpt())) continue;
            List<String> values2 = option2.getValuesList();
            if (values2.size() >= 2) {
                props.put(values2.get(0), values2.get(1));
                continue;
            }
            if (values2.size() != 1) continue;
            props.put(values2.get(0), "true");
        }
        return props;
    }

    public String[] getArgs() {
        String[] answer = new String[this.args.size()];
        this.args.toArray(answer);
        return answer;
    }

    public List<String> getArgList() {
        return this.args;
    }

    protected void addArg(String arg) {
        this.args.add(arg);
    }

    protected void addOption(Option opt2) {
        this.options.add(opt2);
    }

    public Iterator<Option> iterator() {
        return this.options.iterator();
    }

    public Option[] getOptions() {
        List<Option> processed = this.options;
        Option[] optionsArray = new Option[processed.size()];
        return processed.toArray(optionsArray);
    }

    public static final class Builder {
        private final CommandLine commandLine = new CommandLine();

        public Builder addOption(Option opt2) {
            this.commandLine.addOption(opt2);
            return this;
        }

        public Builder addArg(String arg) {
            this.commandLine.addArg(arg);
            return this;
        }

        public CommandLine build() {
            return this.commandLine;
        }
    }
}

