/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjarasm.asm.util;

import groovyjarjarasm.asm.AnnotationVisitor;
import groovyjarjarasm.asm.Attribute;
import groovyjarjarasm.asm.ClassVisitor;
import groovyjarjarasm.asm.FieldVisitor;
import groovyjarjarasm.asm.MethodVisitor;
import groovyjarjarasm.asm.ModuleVisitor;
import groovyjarjarasm.asm.TypePath;
import groovyjarjarasm.asm.util.Printer;
import groovyjarjarasm.asm.util.Textifier;
import groovyjarjarasm.asm.util.TraceAnnotationVisitor;
import groovyjarjarasm.asm.util.TraceFieldVisitor;
import groovyjarjarasm.asm.util.TraceMethodVisitor;
import groovyjarjarasm.asm.util.TraceModuleVisitor;
import java.io.PrintWriter;

public final class TraceClassVisitor
extends ClassVisitor {
    private final PrintWriter printWriter;
    public final Printer p;

    public TraceClassVisitor(PrintWriter printWriter) {
        this(null, printWriter);
    }

    public TraceClassVisitor(ClassVisitor classVisitor, PrintWriter printWriter) {
        this(classVisitor, new Textifier(), printWriter);
    }

    public TraceClassVisitor(ClassVisitor classVisitor, Printer printer, PrintWriter printWriter) {
        super(458752, classVisitor);
        this.printWriter = printWriter;
        this.p = printer;
    }

    public void visit(int version, int access, String name2, String signature2, String superName, String[] interfaces2) {
        this.p.visit(version, access, name2, signature2, superName, interfaces2);
        super.visit(version, access, name2, signature2, superName, interfaces2);
    }

    public void visitSource(String file, String debug) {
        this.p.visitSource(file, debug);
        super.visitSource(file, debug);
    }

    public ModuleVisitor visitModule(String name2, int flags2, String version) {
        Printer modulePrinter = this.p.visitModule(name2, flags2, version);
        return new TraceModuleVisitor(super.visitModule(name2, flags2, version), modulePrinter);
    }

    public void visitNestHost(String nestHost) {
        this.p.visitNestHost(nestHost);
        super.visitNestHost(nestHost);
    }

    public void visitOuterClass(String owner, String name2, String descriptor) {
        this.p.visitOuterClass(owner, name2, descriptor);
        super.visitOuterClass(owner, name2, descriptor);
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        Printer annotationPrinter = this.p.visitClassAnnotation(descriptor, visible);
        return new TraceAnnotationVisitor(super.visitAnnotation(descriptor, visible), annotationPrinter);
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath2, String descriptor, boolean visible) {
        Printer annotationPrinter = this.p.visitClassTypeAnnotation(typeRef, typePath2, descriptor, visible);
        return new TraceAnnotationVisitor(super.visitTypeAnnotation(typeRef, typePath2, descriptor, visible), annotationPrinter);
    }

    public void visitAttribute(Attribute attribute2) {
        this.p.visitClassAttribute(attribute2);
        super.visitAttribute(attribute2);
    }

    public void visitNestMember(String nestMember) {
        this.p.visitNestMember(nestMember);
        super.visitNestMember(nestMember);
    }

    public void visitInnerClass(String name2, String outerName, String innerName, int access) {
        this.p.visitInnerClass(name2, outerName, innerName, access);
        super.visitInnerClass(name2, outerName, innerName, access);
    }

    public FieldVisitor visitField(int access, String name2, String descriptor, String signature2, Object value2) {
        Printer fieldPrinter = this.p.visitField(access, name2, descriptor, signature2, value2);
        return new TraceFieldVisitor(super.visitField(access, name2, descriptor, signature2, value2), fieldPrinter);
    }

    public MethodVisitor visitMethod(int access, String name2, String descriptor, String signature2, String[] exceptions) {
        Printer methodPrinter = this.p.visitMethod(access, name2, descriptor, signature2, exceptions);
        return new TraceMethodVisitor(super.visitMethod(access, name2, descriptor, signature2, exceptions), methodPrinter);
    }

    public void visitEnd() {
        this.p.visitClassEnd();
        if (this.printWriter != null) {
            this.p.print(this.printWriter);
            this.printWriter.flush();
        }
        super.visitEnd();
    }
}

