/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjarasm.asm.commons;

import groovyjarjarasm.asm.AnnotationVisitor;
import groovyjarjarasm.asm.Attribute;
import groovyjarjarasm.asm.ClassVisitor;
import groovyjarjarasm.asm.FieldVisitor;
import groovyjarjarasm.asm.MethodVisitor;
import groovyjarjarasm.asm.ModuleVisitor;
import groovyjarjarasm.asm.TypePath;
import groovyjarjarasm.asm.commons.AnnotationRemapper;
import groovyjarjarasm.asm.commons.FieldRemapper;
import groovyjarjarasm.asm.commons.MethodRemapper;
import groovyjarjarasm.asm.commons.ModuleHashesAttribute;
import groovyjarjarasm.asm.commons.ModuleRemapper;
import groovyjarjarasm.asm.commons.Remapper;
import java.util.List;

public class ClassRemapper
extends ClassVisitor {
    protected final Remapper remapper;
    protected String className;

    public ClassRemapper(ClassVisitor classVisitor, Remapper remapper) {
        this(458752, classVisitor, remapper);
    }

    protected ClassRemapper(int api, ClassVisitor classVisitor, Remapper remapper) {
        super(api, classVisitor);
        this.remapper = remapper;
    }

    public void visit(int version, int access, String name2, String signature2, String superName, String[] interfaces2) {
        this.className = name2;
        super.visit(version, access, this.remapper.mapType(name2), this.remapper.mapSignature(signature2, false), this.remapper.mapType(superName), interfaces2 == null ? null : this.remapper.mapTypes(interfaces2));
    }

    public ModuleVisitor visitModule(String name2, int flags2, String version) {
        ModuleVisitor moduleVisitor = super.visitModule(this.remapper.mapModuleName(name2), flags2, version);
        return moduleVisitor == null ? null : this.createModuleRemapper(moduleVisitor);
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        AnnotationVisitor annotationVisitor = super.visitAnnotation(this.remapper.mapDesc(descriptor), visible);
        return annotationVisitor == null ? null : this.createAnnotationRemapper(annotationVisitor);
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath2, String descriptor, boolean visible) {
        AnnotationVisitor annotationVisitor = super.visitTypeAnnotation(typeRef, typePath2, this.remapper.mapDesc(descriptor), visible);
        return annotationVisitor == null ? null : this.createAnnotationRemapper(annotationVisitor);
    }

    public void visitAttribute(Attribute attribute2) {
        if (attribute2 instanceof ModuleHashesAttribute) {
            ModuleHashesAttribute moduleHashesAttribute = (ModuleHashesAttribute)attribute2;
            List<String> modules = moduleHashesAttribute.modules;
            for (int i = 0; i < modules.size(); ++i) {
                modules.set(i, this.remapper.mapModuleName(modules.get(i)));
            }
        }
        super.visitAttribute(attribute2);
    }

    public FieldVisitor visitField(int access, String name2, String descriptor, String signature2, Object value2) {
        FieldVisitor fieldVisitor = super.visitField(access, this.remapper.mapFieldName(this.className, name2, descriptor), this.remapper.mapDesc(descriptor), this.remapper.mapSignature(signature2, true), value2 == null ? null : this.remapper.mapValue(value2));
        return fieldVisitor == null ? null : this.createFieldRemapper(fieldVisitor);
    }

    public MethodVisitor visitMethod(int access, String name2, String descriptor, String signature2, String[] exceptions) {
        String remappedDescriptor = this.remapper.mapMethodDesc(descriptor);
        MethodVisitor methodVisitor = super.visitMethod(access, this.remapper.mapMethodName(this.className, name2, descriptor), remappedDescriptor, this.remapper.mapSignature(signature2, false), exceptions == null ? null : this.remapper.mapTypes(exceptions));
        return methodVisitor == null ? null : this.createMethodRemapper(methodVisitor);
    }

    public void visitInnerClass(String name2, String outerName, String innerName, int access) {
        super.visitInnerClass(this.remapper.mapType(name2), outerName == null ? null : this.remapper.mapType(outerName), innerName == null ? null : this.remapper.mapInnerClassName(name2, outerName, innerName), access);
    }

    public void visitOuterClass(String owner, String name2, String descriptor) {
        super.visitOuterClass(this.remapper.mapType(owner), name2 == null ? null : this.remapper.mapMethodName(owner, name2, descriptor), descriptor == null ? null : this.remapper.mapMethodDesc(descriptor));
    }

    public void visitNestHost(String nestHost) {
        super.visitNestHost(this.remapper.mapType(nestHost));
    }

    public void visitNestMember(String nestMember) {
        super.visitNestMember(this.remapper.mapType(nestMember));
    }

    protected FieldVisitor createFieldRemapper(FieldVisitor fieldVisitor) {
        return new FieldRemapper(this.api, fieldVisitor, this.remapper);
    }

    protected MethodVisitor createMethodRemapper(MethodVisitor methodVisitor) {
        return new MethodRemapper(this.api, methodVisitor, this.remapper);
    }

    protected AnnotationVisitor createAnnotationRemapper(AnnotationVisitor annotationVisitor) {
        return new AnnotationRemapper(this.api, annotationVisitor, this.remapper);
    }

    protected ModuleVisitor createModuleRemapper(ModuleVisitor moduleVisitor) {
        return new ModuleRemapper(this.api, moduleVisitor, this.remapper);
    }
}

