/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjarasm.asm;

import groovyjarjarasm.asm.ByteVector;
import groovyjarjarasm.asm.ClassReader;
import groovyjarjarasm.asm.ClassWriter;
import groovyjarjarasm.asm.Label;
import groovyjarjarasm.asm.SymbolTable;

public class Attribute {
    public final String type;
    private byte[] content;
    Attribute nextAttribute;

    protected Attribute(String type) {
        this.type = type;
    }

    public boolean isUnknown() {
        return true;
    }

    public boolean isCodeAttribute() {
        return false;
    }

    protected Label[] getLabels() {
        return new Label[0];
    }

    protected Attribute read(ClassReader classReader, int offset, int length, char[] charBuffer, int codeAttributeOffset, Label[] labels) {
        Attribute attribute2 = new Attribute(this.type);
        attribute2.content = new byte[length];
        System.arraycopy(classReader.classFileBuffer, offset, attribute2.content, 0, length);
        return attribute2;
    }

    protected ByteVector write(ClassWriter classWriter, byte[] code, int codeLength, int maxStack, int maxLocals) {
        return new ByteVector(this.content);
    }

    final int getAttributeCount() {
        int count2 = 0;
        Attribute attribute2 = this;
        while (attribute2 != null) {
            ++count2;
            attribute2 = attribute2.nextAttribute;
        }
        return count2;
    }

    final int computeAttributesSize(SymbolTable symbolTable) {
        byte[] code = null;
        boolean codeLength = false;
        int maxStack = -1;
        int maxLocals = -1;
        return this.computeAttributesSize(symbolTable, code, 0, -1, -1);
    }

    final int computeAttributesSize(SymbolTable symbolTable, byte[] code, int codeLength, int maxStack, int maxLocals) {
        ClassWriter classWriter = symbolTable.classWriter;
        int size2 = 0;
        Attribute attribute2 = this;
        while (attribute2 != null) {
            symbolTable.addConstantUtf8(attribute2.type);
            size2 += 6 + attribute2.write((ClassWriter)classWriter, (byte[])code, (int)codeLength, (int)maxStack, (int)maxLocals).length;
            attribute2 = attribute2.nextAttribute;
        }
        return size2;
    }

    static int computeAttributesSize(SymbolTable symbolTable, int accessFlags, int signatureIndex) {
        int size2 = 0;
        if ((accessFlags & 0x1000) != 0 && symbolTable.getMajorVersion() < 49) {
            symbolTable.addConstantUtf8("Synthetic");
            size2 += 6;
        }
        if (signatureIndex != 0) {
            symbolTable.addConstantUtf8("Signature");
            size2 += 8;
        }
        if ((accessFlags & 0x20000) != 0) {
            symbolTable.addConstantUtf8("Deprecated");
            size2 += 6;
        }
        return size2;
    }

    final void putAttributes(SymbolTable symbolTable, ByteVector output) {
        byte[] code = null;
        boolean codeLength = false;
        int maxStack = -1;
        int maxLocals = -1;
        this.putAttributes(symbolTable, code, 0, -1, -1, output);
    }

    final void putAttributes(SymbolTable symbolTable, byte[] code, int codeLength, int maxStack, int maxLocals, ByteVector output) {
        ClassWriter classWriter = symbolTable.classWriter;
        Attribute attribute2 = this;
        while (attribute2 != null) {
            ByteVector attributeContent = attribute2.write(classWriter, code, codeLength, maxStack, maxLocals);
            output.putShort(symbolTable.addConstantUtf8(attribute2.type)).putInt(attributeContent.length);
            output.putByteArray(attributeContent.data, 0, attributeContent.length);
            attribute2 = attribute2.nextAttribute;
        }
    }

    static void putAttributes(SymbolTable symbolTable, int accessFlags, int signatureIndex, ByteVector output) {
        if ((accessFlags & 0x1000) != 0 && symbolTable.getMajorVersion() < 49) {
            output.putShort(symbolTable.addConstantUtf8("Synthetic")).putInt(0);
        }
        if (signatureIndex != 0) {
            output.putShort(symbolTable.addConstantUtf8("Signature")).putInt(2).putShort(signatureIndex);
        }
        if ((accessFlags & 0x20000) != 0) {
            output.putShort(symbolTable.addConstantUtf8("Deprecated")).putInt(0);
        }
    }

    static final class Set {
        private static final int SIZE_INCREMENT = 6;
        private int size;
        private Attribute[] data = new Attribute[6];

        Set() {
        }

        void addAttributes(Attribute attributeList) {
            Attribute attribute2 = attributeList;
            while (attribute2 != null) {
                if (!this.contains(attribute2)) {
                    this.add(attribute2);
                }
                attribute2 = attribute2.nextAttribute;
            }
        }

        Attribute[] toArray() {
            Attribute[] result2 = new Attribute[this.size];
            System.arraycopy(this.data, 0, result2, 0, this.size);
            return result2;
        }

        private boolean contains(Attribute attribute2) {
            for (int i = 0; i < this.size; ++i) {
                if (!this.data[i].type.equals(attribute2.type)) continue;
                return true;
            }
            return false;
        }

        private void add(Attribute attribute2) {
            if (this.size >= this.data.length) {
                Attribute[] newData = new Attribute[this.data.length + 6];
                System.arraycopy(this.data, 0, newData, 0, this.size);
                this.data = newData;
            }
            this.data[this.size++] = attribute2;
        }
    }
}

