/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjarantlr;

import groovyjarjarantlr.ASdebug.ASDebugStream;
import groovyjarjarantlr.ASdebug.IASDebugStream;
import groovyjarjarantlr.ASdebug.TokenOffsetInfo;
import groovyjarjarantlr.Token;
import groovyjarjarantlr.TokenStream;
import groovyjarjarantlr.TokenStreamException;
import groovyjarjarantlr.TokenWithIndex;
import groovyjarjarantlr.collections.impl.BitSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TokenStreamRewriteEngine
implements TokenStream,
IASDebugStream {
    public static final int MIN_TOKEN_INDEX = 0;
    public static final String DEFAULT_PROGRAM_NAME = "default";
    public static final int PROGRAM_INIT_SIZE = 100;
    protected List tokens;
    protected Map programs = null;
    protected Map lastRewriteTokenIndexes = null;
    protected int index = 0;
    protected TokenStream stream;
    protected BitSet discardMask = new BitSet();

    public TokenStreamRewriteEngine(TokenStream tokenStream) {
        this(tokenStream, 1000);
    }

    public TokenStreamRewriteEngine(TokenStream tokenStream, int n) {
        this.stream = tokenStream;
        this.tokens = new ArrayList(n);
        this.programs = new HashMap();
        this.programs.put(DEFAULT_PROGRAM_NAME, new ArrayList(100));
        this.lastRewriteTokenIndexes = new HashMap();
    }

    public Token nextToken() throws TokenStreamException {
        TokenWithIndex tokenWithIndex;
        do {
            if ((tokenWithIndex = (TokenWithIndex)this.stream.nextToken()) == null) continue;
            tokenWithIndex.setIndex(this.index);
            if (tokenWithIndex.getType() != 1) {
                this.tokens.add(tokenWithIndex);
            }
            ++this.index;
        } while (tokenWithIndex != null && this.discardMask.member(tokenWithIndex.getType()));
        return tokenWithIndex;
    }

    public void rollback(int n) {
        this.rollback(DEFAULT_PROGRAM_NAME, n);
    }

    public void rollback(String string2, int n) {
        List list2 = (List)this.programs.get(string2);
        if (list2 != null) {
            this.programs.put(string2, list2.subList(0, n));
        }
    }

    public void deleteProgram() {
        this.deleteProgram(DEFAULT_PROGRAM_NAME);
    }

    public void deleteProgram(String string2) {
        this.rollback(string2, 0);
    }

    protected void addToSortedRewriteList(RewriteOperation rewriteOperation) {
        this.addToSortedRewriteList(DEFAULT_PROGRAM_NAME, rewriteOperation);
    }

    protected void addToSortedRewriteList(String string2, RewriteOperation rewriteOperation) {
        Comparator comparator;
        List list2 = this.getProgram(string2);
        int n = Collections.binarySearch(list2, rewriteOperation, comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                RewriteOperation rewriteOperation = (RewriteOperation)object;
                RewriteOperation rewriteOperation2 = (RewriteOperation)object2;
                if (rewriteOperation.index < rewriteOperation2.index) {
                    return -1;
                }
                if (rewriteOperation.index > rewriteOperation2.index) {
                    return 1;
                }
                return 0;
            }
        });
        if (n >= 0) {
            while (n >= 0) {
                RewriteOperation rewriteOperation2 = (RewriteOperation)list2.get(n);
                if (rewriteOperation2.index < rewriteOperation.index) break;
                --n;
            }
            ++n;
            if (rewriteOperation instanceof ReplaceOp) {
                int n2;
                boolean bl = false;
                for (n2 = n; n2 < list2.size(); ++n2) {
                    RewriteOperation rewriteOperation3 = (RewriteOperation)list2.get(n);
                    if (rewriteOperation3.index != rewriteOperation.index) break;
                    if (!(rewriteOperation3 instanceof ReplaceOp)) continue;
                    list2.set(n, rewriteOperation);
                    bl = true;
                    break;
                }
                if (!bl) {
                    list2.add(n2, rewriteOperation);
                }
            } else {
                list2.add(n, rewriteOperation);
            }
        } else {
            list2.add(-n - 1, rewriteOperation);
        }
    }

    public void insertAfter(Token token2, String string2) {
        this.insertAfter(DEFAULT_PROGRAM_NAME, token2, string2);
    }

    public void insertAfter(int n, String string2) {
        this.insertAfter(DEFAULT_PROGRAM_NAME, n, string2);
    }

    public void insertAfter(String string2, Token token2, String string3) {
        this.insertAfter(string2, ((TokenWithIndex)token2).getIndex(), string3);
    }

    public void insertAfter(String string2, int n, String string3) {
        this.insertBefore(string2, n + 1, string3);
    }

    public void insertBefore(Token token2, String string2) {
        this.insertBefore(DEFAULT_PROGRAM_NAME, token2, string2);
    }

    public void insertBefore(int n, String string2) {
        this.insertBefore(DEFAULT_PROGRAM_NAME, n, string2);
    }

    public void insertBefore(String string2, Token token2, String string3) {
        this.insertBefore(string2, ((TokenWithIndex)token2).getIndex(), string3);
    }

    public void insertBefore(String string2, int n, String string3) {
        this.addToSortedRewriteList(string2, new InsertBeforeOp(n, string3));
    }

    public void replace(int n, String string2) {
        this.replace(DEFAULT_PROGRAM_NAME, n, n, string2);
    }

    public void replace(int n, int n2, String string2) {
        this.replace(DEFAULT_PROGRAM_NAME, n, n2, string2);
    }

    public void replace(Token token2, String string2) {
        this.replace(DEFAULT_PROGRAM_NAME, token2, token2, string2);
    }

    public void replace(Token token2, Token token3, String string2) {
        this.replace(DEFAULT_PROGRAM_NAME, token2, token3, string2);
    }

    public void replace(String string2, int n, int n2, String string3) {
        this.addToSortedRewriteList(new ReplaceOp(n, n2, string3));
    }

    public void replace(String string2, Token token2, Token token3, String string3) {
        this.replace(string2, ((TokenWithIndex)token2).getIndex(), ((TokenWithIndex)token3).getIndex(), string3);
    }

    public void delete(int n) {
        this.delete(DEFAULT_PROGRAM_NAME, n, n);
    }

    public void delete(int n, int n2) {
        this.delete(DEFAULT_PROGRAM_NAME, n, n2);
    }

    public void delete(Token token2) {
        this.delete(DEFAULT_PROGRAM_NAME, token2, token2);
    }

    public void delete(Token token2, Token token3) {
        this.delete(DEFAULT_PROGRAM_NAME, token2, token3);
    }

    public void delete(String string2, int n, int n2) {
        this.replace(string2, n, n2, null);
    }

    public void delete(String string2, Token token2, Token token3) {
        this.replace(string2, token2, token3, null);
    }

    public void discard(int n) {
        this.discardMask.add(n);
    }

    public TokenWithIndex getToken(int n) {
        return (TokenWithIndex)this.tokens.get(n);
    }

    public int getTokenStreamSize() {
        return this.tokens.size();
    }

    public String toOriginalString() {
        return this.toOriginalString(0, this.getTokenStreamSize() - 1);
    }

    public String toOriginalString(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i >= 0 && i <= n2 && i < this.tokens.size(); ++i) {
            stringBuffer.append(this.getToken(i).getText());
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(0, this.getTokenStreamSize() - 1);
    }

    public String toString(String string2) {
        return this.toString(string2, 0, this.getTokenStreamSize() - 1);
    }

    public String toString(int n, int n2) {
        return this.toString(DEFAULT_PROGRAM_NAME, n, n2);
    }

    public String toString(String string2, int n, int n2) {
        List list2 = (List)this.programs.get(string2);
        if (list2 == null || list2.size() == 0) {
            return this.toOriginalString(n, n2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        int n4 = n;
        while (n4 >= 0 && n4 <= n2 && n4 < this.tokens.size()) {
            if (n3 < list2.size()) {
                RewriteOperation rewriteOperation = (RewriteOperation)list2.get(n3);
                while (rewriteOperation.index < n4 && n3 < list2.size()) {
                    if (++n3 >= list2.size()) continue;
                    rewriteOperation = (RewriteOperation)list2.get(n3);
                }
                while (n4 == rewriteOperation.index && n3 < list2.size()) {
                    n4 = rewriteOperation.execute(stringBuffer);
                    if (++n3 >= list2.size()) continue;
                    rewriteOperation = (RewriteOperation)list2.get(n3);
                }
            }
            if (n4 > n2) continue;
            stringBuffer.append(this.getToken(n4).getText());
            ++n4;
        }
        for (int i = n3; i < list2.size(); ++i) {
            RewriteOperation rewriteOperation = (RewriteOperation)list2.get(i);
            if (rewriteOperation.index < this.size()) continue;
            rewriteOperation.execute(stringBuffer);
        }
        return stringBuffer.toString();
    }

    public String toDebugString() {
        return this.toDebugString(0, this.getTokenStreamSize() - 1);
    }

    public String toDebugString(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i >= 0 && i <= n2 && i < this.tokens.size(); ++i) {
            stringBuffer.append(this.getToken(i));
        }
        return stringBuffer.toString();
    }

    public int getLastRewriteTokenIndex() {
        return this.getLastRewriteTokenIndex(DEFAULT_PROGRAM_NAME);
    }

    protected int getLastRewriteTokenIndex(String string2) {
        Integer n = (Integer)this.lastRewriteTokenIndexes.get(string2);
        if (n == null) {
            return -1;
        }
        return n;
    }

    protected void setLastRewriteTokenIndex(String string2, int n) {
        this.lastRewriteTokenIndexes.put(string2, new Integer(n));
    }

    protected List getProgram(String string2) {
        List list2 = (List)this.programs.get(string2);
        if (list2 == null) {
            list2 = this.initializeProgram(string2);
        }
        return list2;
    }

    private List initializeProgram(String string2) {
        ArrayList arrayList = new ArrayList(100);
        this.programs.put(string2, arrayList);
        return arrayList;
    }

    public int size() {
        return this.tokens.size();
    }

    public int index() {
        return this.index;
    }

    public String getEntireText() {
        return ASDebugStream.getEntireText(this.stream);
    }

    public TokenOffsetInfo getOffsetInfo(Token token2) {
        return ASDebugStream.getOffsetInfo(this.stream, token2);
    }

    static class DeleteOp
    extends ReplaceOp {
        public DeleteOp(int n, int n2) {
            super(n, n2, null);
        }
    }

    static class ReplaceOp
    extends RewriteOperation {
        protected int lastIndex;

        public ReplaceOp(int n, int n2, String string2) {
            super(n, string2);
            this.lastIndex = n2;
        }

        public int execute(StringBuffer stringBuffer) {
            if (this.text != null) {
                stringBuffer.append(this.text);
            }
            return this.lastIndex + 1;
        }
    }

    static class InsertBeforeOp
    extends RewriteOperation {
        public InsertBeforeOp(int n, String string2) {
            super(n, string2);
        }

        public int execute(StringBuffer stringBuffer) {
            stringBuffer.append(this.text);
            return this.index;
        }
    }

    static class RewriteOperation {
        protected int index;
        protected String text;

        protected RewriteOperation(int n, String string2) {
            this.index = n;
            this.text = string2;
        }

        public int execute(StringBuffer stringBuffer) {
            return this.index;
        }

        public String toString() {
            String string2 = this.getClass().getName();
            int n = string2.indexOf(36);
            string2 = string2.substring(n + 1, string2.length());
            return string2 + "@" + this.index + '\"' + this.text + '\"';
        }
    }
}

