/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import groovy.lang.Closure;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ObservableMap
implements Map {
    private final Map delegate;
    private final PropertyChangeSupport pcs;
    private final Closure test;
    public static final String SIZE_PROPERTY = "size";
    public static final String CONTENT_PROPERTY = "content";
    public static final String CLEARED_PROPERTY = "cleared";

    public ObservableMap() {
        this(new LinkedHashMap(), null);
    }

    public ObservableMap(Closure test) {
        this(new LinkedHashMap(), test);
    }

    public ObservableMap(Map delegate) {
        this(delegate, null);
    }

    public ObservableMap(Map delegate, Closure test) {
        this.delegate = delegate;
        this.test = test;
        this.pcs = new PropertyChangeSupport(this);
    }

    protected Map getMapDelegate() {
        return this.delegate;
    }

    protected Closure getTest() {
        return this.test;
    }

    public Map getContent() {
        return Collections.unmodifiableMap(this.delegate);
    }

    protected void firePropertyClearedEvent(Map values2) {
        this.firePropertyEvent(new PropertyClearedEvent(this, values2));
    }

    protected void firePropertyAddedEvent(Object key, Object value2) {
        this.firePropertyEvent(new PropertyAddedEvent(this, String.valueOf(key), value2));
    }

    protected void firePropertyUpdatedEvent(Object key, Object oldValue, Object newValue) {
        this.firePropertyEvent(new PropertyUpdatedEvent(this, String.valueOf(key), oldValue, newValue));
    }

    protected void fireMultiPropertyEvent(List<PropertyEvent> events2) {
        this.firePropertyEvent(new MultiPropertyEvent(this, events2.toArray(new PropertyEvent[0])));
    }

    protected void fireMultiPropertyEvent(PropertyEvent[] events2) {
        this.firePropertyEvent(new MultiPropertyEvent(this, events2));
    }

    protected void firePropertyRemovedEvent(Object key, Object value2) {
        this.firePropertyEvent(new PropertyRemovedEvent(this, String.valueOf(key), value2));
    }

    protected void firePropertyEvent(PropertyEvent event) {
        this.pcs.firePropertyChange(event);
    }

    protected void fireSizeChangedEvent(int oldValue, int newValue) {
        this.pcs.firePropertyChange(new PropertyChangeEvent(this, SIZE_PROPERTY, oldValue, newValue));
    }

    @Override
    public void clear() {
        int oldSize = this.size();
        HashMap values2 = new HashMap();
        if (!this.delegate.isEmpty()) {
            values2.putAll(this.delegate);
        }
        this.delegate.clear();
        this.firePropertyClearedEvent(values2);
        this.fireSizeChangedEvent(oldSize, this.size());
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value2) {
        return this.delegate.containsValue(value2);
    }

    public Set entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    public Object get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public Set keySet() {
        return this.delegate.keySet();
    }

    public Object put(Object key, Object value2) {
        boolean newKey;
        int oldSize = this.size();
        Object oldValue = null;
        boolean bl = newKey = !this.delegate.containsKey(key);
        if (this.test != null) {
            oldValue = this.delegate.put(key, value2);
            Object result2 = null;
            result2 = this.test.getMaximumNumberOfParameters() == 2 ? this.test.call(key, value2) : this.test.call(value2);
            if (result2 instanceof Boolean && ((Boolean)result2).booleanValue()) {
                if (newKey) {
                    this.firePropertyAddedEvent(key, value2);
                    this.fireSizeChangedEvent(oldSize, this.size());
                } else if (oldValue != value2) {
                    this.firePropertyUpdatedEvent(key, oldValue, value2);
                }
            }
        } else {
            oldValue = this.delegate.put(key, value2);
            if (newKey) {
                this.firePropertyAddedEvent(key, value2);
                this.fireSizeChangedEvent(oldSize, this.size());
            } else if (oldValue != value2) {
                this.firePropertyUpdatedEvent(key, oldValue, value2);
            }
        }
        return oldValue;
    }

    public void putAll(Map map2) {
        int oldSize = this.size();
        if (map2 != null) {
            ArrayList<PropertyEvent> events2 = new ArrayList<PropertyEvent>();
            Iterator iterator2 = map2.entrySet().iterator();
            while (iterator2.hasNext()) {
                boolean newKey;
                Map.Entry o;
                Map.Entry entry2 = o = iterator2.next();
                String key = String.valueOf(entry2.getKey());
                Object newValue = entry2.getValue();
                Object oldValue = null;
                boolean bl = newKey = !this.delegate.containsKey(key);
                if (this.test != null) {
                    oldValue = this.delegate.put(key, newValue);
                    Object result2 = null;
                    result2 = this.test.getMaximumNumberOfParameters() == 2 ? this.test.call(key, newValue) : this.test.call(newValue);
                    if (!(result2 instanceof Boolean) || !((Boolean)result2).booleanValue()) continue;
                    if (newKey) {
                        events2.add(new PropertyAddedEvent(this, key, newValue));
                        continue;
                    }
                    if (oldValue == newValue) continue;
                    events2.add(new PropertyUpdatedEvent(this, key, oldValue, newValue));
                    continue;
                }
                oldValue = this.delegate.put(key, newValue);
                if (newKey) {
                    events2.add(new PropertyAddedEvent(this, key, newValue));
                    continue;
                }
                if (oldValue == newValue) continue;
                events2.add(new PropertyUpdatedEvent(this, key, oldValue, newValue));
            }
            if (!events2.isEmpty()) {
                this.fireMultiPropertyEvent(events2);
                this.fireSizeChangedEvent(oldSize, this.size());
            }
        }
    }

    public Object remove(Object key) {
        int oldSize = this.size();
        Object result2 = this.delegate.remove(key);
        if (key != null) {
            this.firePropertyRemovedEvent(key, result2);
            this.fireSizeChangedEvent(oldSize, this.size());
        }
        return result2;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    public int getSize() {
        return this.size();
    }

    public Collection values() {
        return this.delegate.values();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.pcs.getPropertyChangeListeners(propertyName);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public boolean hasListeners(String propertyName) {
        return this.pcs.hasListeners(propertyName);
    }

    public static class MultiPropertyEvent
    extends PropertyEvent {
        public static final String MULTI_PROPERTY = "groovy_util_ObservableMap_MultiPropertyEvent_MULTI";
        private static final PropertyEvent[] EMPTY_PROPERTY_EVENTS = new PropertyEvent[0];
        private static final long serialVersionUID = 3925136810810084267L;
        private final PropertyEvent[] events;

        public MultiPropertyEvent(Object source, PropertyEvent[] events2) {
            super(source, MULTI_PROPERTY, ChangeType.oldValue, ChangeType.newValue, ChangeType.MULTI);
            if (events2 != null && events2.length > 0) {
                this.events = new PropertyEvent[events2.length];
                System.arraycopy(events2, 0, this.events, 0, events2.length);
            } else {
                this.events = EMPTY_PROPERTY_EVENTS;
            }
        }

        public PropertyEvent[] getEvents() {
            PropertyEvent[] copy = new PropertyEvent[this.events.length];
            System.arraycopy(this.events, 0, copy, 0, this.events.length);
            return copy;
        }
    }

    public static class PropertyClearedEvent
    extends PropertyEvent {
        private static final long serialVersionUID = -1472110679547513634L;
        private Map values = new HashMap();

        public PropertyClearedEvent(Object source, Map values2) {
            super(source, ObservableMap.CLEARED_PROPERTY, values2, null, ChangeType.CLEARED);
            if (values2 != null) {
                this.values.putAll(values2);
            }
        }

        public Map getValues() {
            return Collections.unmodifiableMap(this.values);
        }
    }

    public static class PropertyRemovedEvent
    extends PropertyEvent {
        private static final long serialVersionUID = 1882656655856158470L;

        public PropertyRemovedEvent(Object source, String propertyName, Object oldValue) {
            super(source, propertyName, oldValue, null, ChangeType.REMOVED);
        }
    }

    public static class PropertyUpdatedEvent
    extends PropertyEvent {
        private static final long serialVersionUID = -1104637722950032690L;

        public PropertyUpdatedEvent(Object source, String propertyName, Object oldValue, Object newValue) {
            super(source, propertyName, oldValue, newValue, ChangeType.UPDATED);
        }
    }

    public static class PropertyAddedEvent
    extends PropertyEvent {
        private static final long serialVersionUID = -5761685843732329868L;

        public PropertyAddedEvent(Object source, String propertyName, Object newValue) {
            super(source, propertyName, null, newValue, ChangeType.ADDED);
        }
    }

    public static abstract class PropertyEvent
    extends PropertyChangeEvent {
        private static final long serialVersionUID = -8328412226044328674L;
        private ChangeType type;

        public PropertyEvent(Object source, String propertyName, Object oldValue, Object newValue, ChangeType type) {
            super(source, propertyName, oldValue, newValue);
            this.type = type;
        }

        public int getType() {
            return this.type.ordinal();
        }

        public ChangeType getChangeType() {
            return this.type;
        }

        public String getTypeAsString() {
            return this.type.name().toUpperCase();
        }
    }

    public static enum ChangeType {
        ADDED,
        UPDATED,
        REMOVED,
        CLEARED,
        MULTI,
        NONE;

        public static final Object oldValue;
        public static final Object newValue;

        public static ChangeType resolve(int ordinal) {
            switch (ordinal) {
                case 0: {
                    return ADDED;
                }
                case 2: {
                    return REMOVED;
                }
                case 3: {
                    return CLEARED;
                }
                case 4: {
                    return MULTI;
                }
                case 5: {
                    return NONE;
                }
            }
            return UPDATED;
        }

        static {
            oldValue = new Object[0];
            newValue = new Object[0];
        }
    }
}

