/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import groovy.lang.GroovyRuntimeException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class IndentPrinter {
    private int indentLevel;
    private final String indent;
    private final Writer out;
    private final boolean addNewlines;
    private boolean autoIndent;

    public IndentPrinter() {
        this(new PrintWriter(System.out), "  ");
    }

    public IndentPrinter(Writer out) {
        this(out, "  ");
    }

    public IndentPrinter(Writer out, String indent2) {
        this(out, indent2, true);
    }

    public IndentPrinter(Writer out, String indent2, boolean addNewlines) {
        this(out, indent2, addNewlines, false);
    }

    public IndentPrinter(Writer out, String indent2, boolean addNewlines, boolean autoIndent) {
        this.addNewlines = addNewlines;
        if (out == null) {
            throw new IllegalArgumentException("Must specify a Writer");
        }
        this.out = out;
        this.indent = indent2;
        this.autoIndent = autoIndent;
    }

    public void println(String text2) {
        try {
            if (this.autoIndent) {
                this.printIndent();
            }
            this.out.write(text2);
            this.println();
        }
        catch (IOException ioe) {
            throw new GroovyRuntimeException(ioe);
        }
    }

    public void print(String text2) {
        try {
            this.out.write(text2);
        }
        catch (IOException ioe) {
            throw new GroovyRuntimeException(ioe);
        }
    }

    public void print(char c) {
        try {
            this.out.write(c);
        }
        catch (IOException ioe) {
            throw new GroovyRuntimeException(ioe);
        }
    }

    public void printIndent() {
        for (int i = 0; i < this.indentLevel; ++i) {
            try {
                this.out.write(this.indent);
                continue;
            }
            catch (IOException ioe) {
                throw new GroovyRuntimeException(ioe);
            }
        }
    }

    public void println() {
        if (this.addNewlines) {
            try {
                this.out.write("\n");
            }
            catch (IOException ioe) {
                throw new GroovyRuntimeException(ioe);
            }
        }
    }

    public void incrementIndent() {
        ++this.indentLevel;
    }

    public void decrementIndent() {
        --this.indentLevel;
    }

    public int getIndentLevel() {
        return this.indentLevel;
    }

    public void setIndentLevel(int indentLevel) {
        this.indentLevel = indentLevel;
    }

    public boolean getAutoIndent() {
        return this.autoIndent;
    }

    public void setAutoIndent(boolean autoIndent) {
        this.autoIndent = autoIndent;
    }

    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException ioe) {
            throw new GroovyRuntimeException(ioe);
        }
    }
}

